/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.jena;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdql.Query;
import com.hp.hpl.jena.rdql.QueryEngine;
import com.hp.hpl.jena.rdql.QueryExecution;
import com.hp.hpl.jena.rdql.QueryResults;
import org.mindswap.pellet.exceptions.UnsupportedFeatureException;
import org.mindswap.pellet.jena.OWLReasoner;
import org.mindswap.pellet.jena.PelletInfGraph;

public class PelletQueryEngine
implements QueryExecution {
    private Query query;
    private OWLReasoner reasoner;
    private Model source;
    private boolean initialized = false;

    public PelletQueryEngine(String query, Model source) {
        this.query = new Query(query);
        this.source = source;
    }

    public PelletQueryEngine(Query query) {
        this.query = query;
        this.source = query.getSource();
    }

    public void init() {
        if (!this.initialized) {
            Graph graph = this.source.getGraph();
            if (graph instanceof PelletInfGraph) {
                PelletInfGraph pelletInfGraph = (PelletInfGraph)this.source.getGraph();
                if (!pelletInfGraph.isPrepared()) {
                    pelletInfGraph.prepare();
                }
                this.reasoner = pelletInfGraph.getOWLReasoner();
            }
            if (this.reasoner == null) {
                this.reasoner = new OWLReasoner();
                this.reasoner.load(this.source);
            }
        }
        this.initialized = true;
    }

    public QueryResults exec() {
        this.init();
        QueryResults results = null;
        try {
            results = this.reasoner.runQuery(this.query);
        }
        catch (UnsupportedFeatureException e) {
            results = new QueryEngine(this.query).exec();
        }
        return results;
    }

    public void abort() {
    }

    public void close() {
    }

    public static QueryResults exec(Query query) {
        return new PelletQueryEngine(query).exec();
    }
}

