/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.owlapi;

import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermList;
import java.net.URI;
import java.util.Iterator;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.owlapi.PelletLoader;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.QNameProvider;
import org.semanticweb.owl.io.vocabulary.OWLVocabularyAdapter;
import org.semanticweb.owl.model.OWLAnd;
import org.semanticweb.owl.model.OWLAnnotationInstance;
import org.semanticweb.owl.model.OWLAnnotationProperty;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLDataAllRestriction;
import org.semanticweb.owl.model.OWLDataCardinalityRestriction;
import org.semanticweb.owl.model.OWLDataEnumeration;
import org.semanticweb.owl.model.OWLDataProperty;
import org.semanticweb.owl.model.OWLDataPropertyInstance;
import org.semanticweb.owl.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLDataSomeRestriction;
import org.semanticweb.owl.model.OWLDataType;
import org.semanticweb.owl.model.OWLDataValue;
import org.semanticweb.owl.model.OWLDataValueRestriction;
import org.semanticweb.owl.model.OWLDescription;
import org.semanticweb.owl.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owl.model.OWLDisjointClassesAxiom;
import org.semanticweb.owl.model.OWLEnumeration;
import org.semanticweb.owl.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owl.model.OWLEquivalentPropertiesAxiom;
import org.semanticweb.owl.model.OWLException;
import org.semanticweb.owl.model.OWLFrame;
import org.semanticweb.owl.model.OWLFunctionalPropertyAxiom;
import org.semanticweb.owl.model.OWLIndividual;
import org.semanticweb.owl.model.OWLIndividualTypeAssertion;
import org.semanticweb.owl.model.OWLInverseFunctionalPropertyAxiom;
import org.semanticweb.owl.model.OWLInversePropertyAxiom;
import org.semanticweb.owl.model.OWLNamedObject;
import org.semanticweb.owl.model.OWLNot;
import org.semanticweb.owl.model.OWLObject;
import org.semanticweb.owl.model.OWLObjectAllRestriction;
import org.semanticweb.owl.model.OWLObjectCardinalityRestriction;
import org.semanticweb.owl.model.OWLObjectProperty;
import org.semanticweb.owl.model.OWLObjectPropertyInstance;
import org.semanticweb.owl.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owl.model.OWLObjectSomeRestriction;
import org.semanticweb.owl.model.OWLObjectValueRestriction;
import org.semanticweb.owl.model.OWLObjectVisitor;
import org.semanticweb.owl.model.OWLOntology;
import org.semanticweb.owl.model.OWLOr;
import org.semanticweb.owl.model.OWLProperty;
import org.semanticweb.owl.model.OWLPropertyDomainAxiom;
import org.semanticweb.owl.model.OWLSameIndividualsAxiom;
import org.semanticweb.owl.model.OWLSubClassAxiom;
import org.semanticweb.owl.model.OWLSubPropertyAxiom;
import org.semanticweb.owl.model.OWLSymmetricPropertyAxiom;
import org.semanticweb.owl.model.OWLTransitivePropertyAxiom;

public class PelletVisitor
implements OWLObjectVisitor {
    public static boolean DEBUG = false;
    public static QNameProvider qnames = new QNameProvider();
    private static OWLVocabularyAdapter OWL = OWLVocabularyAdapter.INSTANCE;
    PelletLoader loader;
    ATermAppl term;

    public PelletVisitor(PelletLoader loader) {
        this.loader = loader;
    }

    public ATermAppl result() {
        return this.term;
    }

    public void reset() {
        this.term = null;
    }

    public ATermAppl term(OWLDataValue dv) throws OWLException {
        URI datatypeURI = dv.getURI();
        String lexicalValue = dv.getValue().toString();
        String lang = dv.getLang();
        if (datatypeURI != null) {
            return ATermUtils.makeTypedLiteral(lexicalValue, datatypeURI.toString());
        }
        if (lang != null) {
            return ATermUtils.makePlainLiteral(lexicalValue, lang);
        }
        return ATermUtils.makePlainLiteral(lexicalValue);
    }

    public ATermAppl term(OWLNamedObject o) throws OWLException {
        URI uri = o.getURI();
        if (uri == null) {
            if (o instanceof OWLIndividual) {
                uri = ((OWLIndividual)o).getAnonId();
                return this.term(uri);
            }
            throw new OWLException("No name can be created for " + o);
        }
        return this.term(uri);
    }

    public ATermAppl term(String s) {
        return ATermUtils.makeTermAppl(s);
    }

    public ATermAppl term(URI u) {
        if (u.toString().equals(OWL.getThing())) {
            return ATermUtils.TOP;
        }
        if (u.toString().equals(OWL.getNothing())) {
            return ATermUtils.BOTTOM;
        }
        if (PelletOptions.USE_LOCAL_NAME) {
            return this.term(u.getFragment());
        }
        if (PelletOptions.USE_QNAME) {
            return this.term(qnames.shortForm(u));
        }
        return this.term(u.toString());
    }

    public void visit(OWLClass clazz) throws OWLException {
        this.term = this.term((OWLNamedObject)clazz);
    }

    public void visit(OWLIndividual ind) throws OWLException {
        this.term = this.term((OWLNamedObject)ind);
    }

    public void visit(OWLObjectProperty prop) throws OWLException {
        this.term = this.term((OWLNamedObject)prop);
    }

    public void visit(OWLDataProperty prop) throws OWLException {
        this.term = this.term((OWLNamedObject)prop);
    }

    public void visit(OWLDataValue cd) throws OWLException {
        this.term = this.term(cd);
    }

    public void visit(OWLDataType ocdt) throws OWLException {
        this.term = this.term(ocdt.getURI());
        KnowledgeBase kb = this.loader.getKB();
        kb.loadDatatype((ATerm)this.term);
    }

    public void visit(OWLAnd and) throws OWLException {
        ATermList ops = ATermUtils.EMPTY_LIST;
        Iterator it = and.getOperands().iterator();
        while (it.hasNext()) {
            OWLDescription desc = (OWLDescription)it.next();
            desc.accept((OWLObjectVisitor)this);
            ops = ops.insert((ATerm)this.result());
        }
        this.term = ATermUtils.makeAnd(ops);
    }

    public void visit(OWLOr or) throws OWLException {
        ATermList ops = ATermUtils.EMPTY_LIST;
        Iterator it = or.getOperands().iterator();
        while (it.hasNext()) {
            OWLDescription desc = (OWLDescription)it.next();
            desc.accept((OWLObjectVisitor)this);
            ops = ops.insert((ATerm)this.result());
        }
        this.term = ATermUtils.makeOr(ops);
    }

    public void visit(OWLNot not) throws OWLException {
        OWLDescription desc = not.getOperand();
        desc.accept((OWLObjectVisitor)this);
        this.term = ATermUtils.makeNot((ATerm)this.term);
    }

    public void visit(OWLEnumeration enumeration) throws OWLException {
        ATermList ops = ATermUtils.EMPTY_LIST;
        Iterator it = enumeration.getIndividuals().iterator();
        while (it.hasNext()) {
            OWLIndividual desc = (OWLIndividual)it.next();
            desc.accept((OWLObjectVisitor)this);
            ops = ops.insert((ATerm)ATermUtils.makeValue((ATerm)this.result()));
        }
        this.term = ATermUtils.makeOr(ops);
    }

    public void visit(OWLObjectSomeRestriction restriction) throws OWLException {
        restriction.getObjectProperty().accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        restriction.getDescription().accept((OWLObjectVisitor)this);
        ATermAppl c = this.term;
        this.term = ATermUtils.makeSomeValues((ATerm)p, (ATerm)c);
    }

    public void visit(OWLObjectAllRestriction restriction) throws OWLException {
        restriction.getObjectProperty().accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        restriction.getDescription().accept((OWLObjectVisitor)this);
        ATermAppl c = this.term;
        this.term = ATermUtils.makeAllValues((ATerm)p, (ATerm)c);
    }

    public void visit(OWLObjectValueRestriction restriction) throws OWLException {
        restriction.getObjectProperty().accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        restriction.getIndividual().accept((OWLObjectVisitor)this);
        ATermAppl ind = this.term;
        this.term = ATermUtils.makeHasValue((ATerm)p, (ATerm)ind);
    }

    public void visit(OWLObjectCardinalityRestriction restriction) throws OWLException {
        if (restriction.isExactly()) {
            restriction.getObjectProperty().accept((OWLObjectVisitor)this);
            ATermAppl p = this.term;
            int n = restriction.getAtLeast();
            this.term = ATermUtils.makeCard((ATerm)p, n);
        } else if (restriction.isAtMost()) {
            restriction.getObjectProperty().accept((OWLObjectVisitor)this);
            ATermAppl p = this.term;
            int n = restriction.getAtMost();
            this.term = ATermUtils.makeMax((ATerm)p, n);
        } else if (restriction.isAtLeast()) {
            restriction.getObjectProperty().accept((OWLObjectVisitor)this);
            ATermAppl p = this.term;
            int n = restriction.getAtLeast();
            this.term = ATermUtils.makeMin((ATerm)p, n);
        }
    }

    public void visit(OWLDataCardinalityRestriction restriction) throws OWLException {
        if (restriction.isExactly()) {
            restriction.getDataProperty().accept((OWLObjectVisitor)this);
            ATermAppl p = this.term;
            int n = restriction.getAtLeast();
            this.term = ATermUtils.makeCard((ATerm)p, n);
        } else if (restriction.isAtMost()) {
            restriction.getDataProperty().accept((OWLObjectVisitor)this);
            ATermAppl p = this.term;
            int n = restriction.getAtMost();
            this.term = ATermUtils.makeMax((ATerm)p, n);
        } else if (restriction.isAtLeast()) {
            restriction.getDataProperty().accept((OWLObjectVisitor)this);
            ATermAppl p = this.term;
            int n = restriction.getAtLeast();
            this.term = ATermUtils.makeMin((ATerm)p, n);
        }
    }

    public void visit(OWLEquivalentClassesAxiom axiom) throws OWLException {
        KnowledgeBase kb = this.loader.getKB();
        Iterator eqs = axiom.getEquivalentClasses().iterator();
        if (eqs.hasNext()) {
            OWLDescription desc1 = (OWLDescription)eqs.next();
            desc1.accept((OWLObjectVisitor)this);
            ATermAppl c1 = this.term;
            while (eqs.hasNext()) {
                OWLDescription desc2 = (OWLDescription)eqs.next();
                desc2.accept((OWLObjectVisitor)this);
                ATermAppl c2 = this.term;
                kb.addSameClass(c1, c2);
            }
        }
    }

    public void visit(OWLDisjointClassesAxiom axiom) throws OWLException {
        KnowledgeBase kb = this.loader.getKB();
        Object[] disjs = axiom.getDisjointClasses().toArray();
        for (int i = 0; i < disjs.length; ++i) {
            for (int j = i + 1; j < disjs.length; ++j) {
                OWLDescription desc1 = (OWLDescription)disjs[i];
                OWLDescription desc2 = (OWLDescription)disjs[j];
                desc1.accept((OWLObjectVisitor)this);
                ATermAppl c1 = this.term;
                desc2.accept((OWLObjectVisitor)this);
                ATermAppl c2 = this.term;
                kb.addDisjointClass((ATerm)c1, (ATerm)c2);
            }
        }
    }

    public void visit(OWLSubClassAxiom axiom) throws OWLException {
        axiom.getSubClass().accept((OWLObjectVisitor)this);
        ATermAppl c1 = this.term;
        axiom.getSuperClass().accept((OWLObjectVisitor)this);
        ATermAppl c2 = this.term;
        KnowledgeBase kb = this.loader.getKB();
        kb.addSubClass(c1, c2);
    }

    public void visit(OWLEquivalentPropertiesAxiom axiom) throws OWLException {
        KnowledgeBase kb = this.loader.getKB();
        Object[] eqs = axiom.getProperties().toArray();
        for (int i = 0; i < eqs.length; ++i) {
            for (int j = i + 1; j < eqs.length; ++j) {
                OWLProperty prop1 = (OWLProperty)eqs[i];
                OWLProperty prop2 = (OWLProperty)eqs[j];
                prop1.accept((OWLObjectVisitor)this);
                ATermAppl p1 = this.term;
                prop2.accept((OWLObjectVisitor)this);
                ATermAppl p2 = this.term;
                kb.addSameProperty(p1, p2);
            }
        }
    }

    public void visit(OWLSubPropertyAxiom axiom) throws OWLException {
        axiom.getSubProperty().accept((OWLObjectVisitor)this);
        ATermAppl p1 = this.term;
        axiom.getSuperProperty().accept((OWLObjectVisitor)this);
        ATermAppl p2 = this.term;
        KnowledgeBase kb = this.loader.getKB();
        kb.addSubProperty(p1, p2);
    }

    public void visit(OWLDifferentIndividualsAxiom axiom) throws OWLException {
        KnowledgeBase kb = this.loader.getKB();
        Object[] inds = axiom.getIndividuals().toArray();
        for (int i = 0; i < inds.length; ++i) {
            for (int j = i + 1; j < inds.length; ++j) {
                ATermAppl i1 = this.loader.term((OWLObject)((OWLIndividual)inds[i]));
                ATermAppl i2 = this.loader.term((OWLObject)((OWLIndividual)inds[j]));
                kb.addDifferent(i1, i2);
            }
        }
    }

    public void visit(OWLSameIndividualsAxiom axiom) throws OWLException {
        KnowledgeBase kb = this.loader.getKB();
        Iterator eqs = axiom.getIndividuals().iterator();
        if (eqs.hasNext()) {
            ATermAppl i1 = this.loader.term((OWLObject)((OWLIndividual)eqs.next()));
            while (eqs.hasNext()) {
                ATermAppl i2 = this.loader.term((OWLObject)((OWLIndividual)eqs.next()));
                kb.addSame(i1, i2);
            }
        }
    }

    public void visit(OWLAnnotationProperty ap) {
        if (DEBUG) {
            System.out.println("OWLAnnotationProperty " + ap);
        }
    }

    public void visit(OWLAnnotationInstance ai) {
        if (DEBUG) {
            System.out.println("OWLAnnotationInstance " + ai);
        }
    }

    public void visit(OWLDataEnumeration enumeration) throws OWLException {
        ATermList ops = ATermUtils.EMPTY_LIST;
        Iterator it = enumeration.getValues().iterator();
        while (it.hasNext()) {
            OWLDataValue value = (OWLDataValue)it.next();
            value.accept((OWLObjectVisitor)this);
            ops = ops.insert((ATerm)ATermUtils.makeValue((ATerm)this.result()));
        }
        this.term = ATermUtils.makeOr(ops);
    }

    public void visit(OWLDataAllRestriction restriction) throws OWLException {
        restriction.getDataProperty().accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        restriction.getDataType().accept((OWLObjectVisitor)this);
        ATermAppl c = this.term;
        this.term = ATermUtils.makeAllValues((ATerm)p, (ATerm)c);
    }

    public void visit(OWLDataSomeRestriction restriction) throws OWLException {
        restriction.getDataProperty().accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        restriction.getDataType().accept((OWLObjectVisitor)this);
        ATermAppl c = this.term;
        this.term = ATermUtils.makeSomeValues((ATerm)p, (ATerm)c);
    }

    public void visit(OWLDataValueRestriction restriction) throws OWLException {
        restriction.getDataProperty().accept((OWLObjectVisitor)this);
        ATermAppl p = this.term;
        restriction.getValue().accept((OWLObjectVisitor)this);
        ATermAppl dv = this.term;
        this.term = ATermUtils.makeHasValue((ATerm)p, (ATerm)dv);
    }

    public void visit(OWLFrame f) {
        if (DEBUG) {
            System.out.println("OWLFrame " + f);
        }
    }

    public void visit(OWLOntology o) {
        if (DEBUG) {
            System.out.println("OWLOntology " + o);
        }
    }

    public void visit(OWLFunctionalPropertyAxiom node) throws OWLException {
        throw new OWLException("Invalid axiom " + node);
    }

    public void visit(OWLInverseFunctionalPropertyAxiom node) throws OWLException {
        throw new OWLException("Invalid axiom " + node);
    }

    public void visit(OWLTransitivePropertyAxiom node) throws OWLException {
        throw new OWLException("Invalid axiom " + node);
    }

    public void visit(OWLSymmetricPropertyAxiom node) throws OWLException {
        throw new OWLException("Invalid axiom " + node);
    }

    public void visit(OWLInversePropertyAxiom node) throws OWLException {
        throw new OWLException("Invalid axiom " + node);
    }

    public void visit(OWLPropertyDomainAxiom node) throws OWLException {
        throw new OWLException("Invalid axiom " + node);
    }

    public void visit(OWLObjectPropertyRangeAxiom node) throws OWLException {
        throw new OWLException("Invalid axiom " + node);
    }

    public void visit(OWLDataPropertyRangeAxiom node) throws OWLException {
        throw new OWLException("Invalid axiom " + node);
    }

    public void visit(OWLObjectPropertyInstance node) throws OWLException {
        throw new OWLException("Invalid axiom " + node);
    }

    public void visit(OWLDataPropertyInstance node) throws OWLException {
        throw new OWLException("Invalid axiom " + node);
    }

    public void visit(OWLIndividualTypeAssertion node) throws OWLException {
        throw new OWLException("Invalid axiom " + node);
    }
}

