/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.query;

import aterm.ATermAppl;
import aterm.ATermList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.datatypes.Datatype;
import org.mindswap.pellet.query.Query;
import org.mindswap.pellet.query.QueryEngine;
import org.mindswap.pellet.query.QueryPattern;
import org.mindswap.pellet.query.impl.QueryImpl;

public class QuerySplitter {
    private Query oldQuery;
    private Query newQuery;
    private Set addedVars;
    private Set addedPatterns;

    public List split(Query query) {
        try {
            ArrayList<Query> queries = new ArrayList<Query>();
            KnowledgeBase kb = query.getKB();
            this.oldQuery = query;
            this.addedVars = new HashSet();
            this.addedPatterns = new HashSet();
            if (QueryEngine.DEBUG) {
                System.out.println(this.oldQuery);
            }
            List vars = query.getObjVars();
            Iterator i = vars.iterator();
            while (i.hasNext()) {
                ATermAppl var = (ATermAppl)i.next();
                if (this.addedVars.contains(var)) continue;
                this.newQuery = new QueryImpl(kb);
                this.addVar(var);
                queries.add(this.newQuery);
                if (!QueryEngine.DEBUG) continue;
                System.out.println(this.newQuery);
            }
            return queries;
        }
        catch (RuntimeException e) {
            System.err.println("WARNNING: Query split failed, continuing with query execution.");
            System.err.println(this.oldQuery);
            System.err.println(this.newQuery);
            return Collections.singletonList(query);
        }
    }

    private void addVar(ATermAppl var) {
        if (this.addedVars.contains(var)) {
            return;
        }
        this.addedVars.add(var);
        if (this.oldQuery.getResultVars().contains(var)) {
            this.newQuery.addResultVar(var);
        }
        if (this.oldQuery.getObjVars().contains(var)) {
            ATermList classes = this.oldQuery.getClasses(var);
            while (!classes.isEmpty()) {
                ATermAppl c = (ATermAppl)classes.getFirst();
                this.newQuery.addTypePattern(var, c);
                classes = classes.getNext();
            }
            LinkedHashSet<ATermAppl> neighbors = new LinkedHashSet<ATermAppl>();
            List outList = this.oldQuery.findPatterns(var, null, null);
            Iterator i = outList.iterator();
            while (i.hasNext()) {
                QueryPattern pattern = (QueryPattern)i.next();
                if (this.addedPatterns.contains(pattern)) continue;
                this.addedPatterns.add(pattern);
                ATermAppl pred = pattern.getPredicate();
                ATermAppl obj = pattern.getObject();
                this.newQuery.addEdgePattern(var, pred, obj);
                neighbors.add(obj);
            }
            List inList = this.oldQuery.findPatterns(null, null, var);
            Iterator i2 = inList.iterator();
            while (i2.hasNext()) {
                QueryPattern pattern = (QueryPattern)i2.next();
                if (this.addedPatterns.contains(pattern)) continue;
                this.addedPatterns.add(pattern);
                ATermAppl subj = pattern.getSubject();
                ATermAppl pred = pattern.getPredicate();
                this.newQuery.addEdgePattern(subj, pred, var);
                neighbors.add(subj);
            }
            i2 = neighbors.iterator();
            while (i2.hasNext()) {
                ATermAppl neighbor = (ATermAppl)i2.next();
                this.addVar(neighbor);
            }
        } else {
            Datatype datatype = this.oldQuery.getDatatype(var);
            this.newQuery.addConstraint(var, datatype);
        }
    }
}

