/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.query.impl;

import aterm.ATerm;
import aterm.ATermAppl;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdql.Constraint;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.List;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.exceptions.UnsupportedFeatureException;
import org.mindswap.pellet.jena.JenaUtils;
import org.mindswap.pellet.query.Query;
import org.mindswap.pellet.query.QueryEngine;
import org.mindswap.pellet.query.QueryParser;
import org.mindswap.pellet.query.QueryPattern;
import org.mindswap.pellet.query.impl.DConstraint;
import org.mindswap.pellet.query.impl.QueryImpl;
import org.mindswap.pellet.utils.ATermUtils;

public class JenaRDQLParser
implements QueryParser {
    public Query parse(InputStream in, KnowledgeBase kb) throws IOException {
        return this.parse(new InputStreamReader(in), kb);
    }

    public Query parse(Reader in, KnowledgeBase kb) throws IOException {
        StringBuffer queryString = new StringBuffer();
        BufferedReader r = new BufferedReader(in);
        String line = r.readLine();
        while (line != null) {
            queryString.append(line).append("\n");
            line = r.readLine();
        }
        return this.parse(queryString.toString(), kb);
    }

    public Query parse(String queryStr, KnowledgeBase kb) {
        com.hp.hpl.jena.rdql.Query rdql = new com.hp.hpl.jena.rdql.Query(queryStr);
        return this.parse(rdql, kb);
    }

    public Query parse(com.hp.hpl.jena.rdql.Query rdql, KnowledgeBase kb) {
        QueryImpl query = new QueryImpl(kb);
        Iterator i = rdql.getResultVars().iterator();
        while (i.hasNext()) {
            String var = (String)i.next();
            query.addResultVar(ATermUtils.makeVar(var));
        }
        i = rdql.getTriplePatterns().iterator();
        while (i.hasNext()) {
            ATermAppl subj;
            Triple t = (Triple)i.next();
            if (t.getPredicate().equals((Object)RDF.Nodes.type)) {
                if (t.getObject().isVariable()) {
                    throw new UnsupportedFeatureException("Variables cannot be used as objects of rdf:type triples in ABoxQuery");
                }
                subj = this.makeTerm(t.getSubject());
                ATermAppl obj = this.makeTerm(t.getObject());
                query.addTypePattern(subj, obj);
                continue;
            }
            if (t.getPredicate().isVariable()) {
                throw new UnsupportedFeatureException("Variables cannot be used in predicate position in AboxQuery");
            }
            if (t.getPredicate().toString().startsWith(RDF.getURI()) || t.getPredicate().toString().startsWith(OWL.getURI()) || t.getPredicate().toString().startsWith(RDFS.getURI())) {
                throw new UnsupportedFeatureException("Predicates that belong to [RDF, RDFS, OWL] namespaces cannot be used in ABoxQuery");
            }
            subj = this.makeTerm(t.getSubject());
            ATermAppl pred = this.makeTerm(t.getPredicate());
            ATermAppl obj = this.makeTerm(t.getObject());
            if (!kb.isProperty((ATerm)pred)) {
                throw new UnsupportedFeatureException("Property " + t.getPredicate().toString() + " is not present in KB.");
            }
            if (kb.isDatatypeProperty((ATerm)pred) && query.getDistVars().contains(obj) && t.getSubject().isVariable()) {
                if (QueryEngine.DEBUG) {
                    System.out.println("Warning: Forcing variable " + t.getSubject() + " to be distinguished (Subject of datatype triple)");
                }
                query.addDistVar(subj);
            }
            query.addEdgePattern(subj, pred, obj);
        }
        i = rdql.getConstraints().iterator();
        while (i.hasNext()) {
            Constraint c = (Constraint)i.next();
            String[] tokens = c.toString().split(" ");
            String var = tokens[1];
            String op = tokens[2];
            String val = tokens[3];
            if (var.charAt(0) != '?') {
                throw new UnsupportedFeatureException("Expecting '?' to be the first char in the expression (" + c + ")");
            }
            ATermAppl curr = ATermUtils.makeVar(var.substring(1));
            if (query.getLitVars().contains(curr)) {
                DConstraint dc = new DConstraint(curr, op, val);
                query.addConstraint(curr, dc.getDerivedDatatype());
                kb.getDatatypeReasoner().defineDatatype(dc.getDerivedDatatype());
                if (!dc.isForced()) continue;
                List patterns = query.findPatterns(null, null, curr);
                Iterator it = patterns.iterator();
                while (it.hasNext()) {
                    QueryPattern triple = (QueryPattern)it.next();
                    ATermAppl subj = triple.getSubject();
                    if (!ATermUtils.isVar(subj) || query.getDistVars().contains(subj)) continue;
                    query.addDistVar(subj);
                }
                continue;
            }
            throw new UnsupportedFeatureException("Literal variable in the expression (" + c + ") does not exist in the query.");
        }
        return query;
    }

    private ATermAppl makeTerm(Node node) {
        if (node.equals((Object)OWL.Thing.getNode())) {
            return ATermUtils.TOP;
        }
        if (node.equals((Object)OWL.Nothing.getNode())) {
            return ATermUtils.BOTTOM;
        }
        if (node.isLiteral()) {
            return JenaUtils.makeLiteral(node.getLiteral());
        }
        if (node.isVariable()) {
            return ATermUtils.makeVar(node.getName());
        }
        if (PelletOptions.USE_LOCAL_NAME) {
            return ATermUtils.makeTermAppl(node.getLocalName());
        }
        return ATermUtils.makeTermAppl(node.toString());
    }
}

