/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.query.impl;

import aterm.ATermAppl;
import java.util.List;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.exceptions.UnsupportedFeatureException;
import org.mindswap.pellet.query.Query;
import org.mindswap.pellet.query.QueryEngine;
import org.mindswap.pellet.query.QueryExec;
import org.mindswap.pellet.query.QueryPattern;
import org.mindswap.pellet.query.QueryResults;
import org.mindswap.pellet.query.impl.QueryResultBindingImpl;
import org.mindswap.pellet.query.impl.QueryResultsImpl;
import org.mindswap.pellet.utils.Bool;

public class NoDistVarsQueryExec
implements QueryExec {
    private KnowledgeBase kb;

    public boolean supports(Query q) {
        return q.getDistVars().isEmpty();
    }

    public QueryResults exec(Query query) {
        QueryResultsImpl results = new QueryResultsImpl(query);
        boolean success = this.execBoolean(query);
        if (success) {
            results.add(new QueryResultBindingImpl());
        }
        return results;
    }

    public boolean execBoolean(Query query) {
        boolean querySatisfied;
        this.kb = query.getKB();
        if (query.getConstants().isEmpty()) {
            throw new UnsupportedFeatureException("Executing queries with no constants is not implemented yet!");
        }
        Bool allTriplesSatisfied = Bool.TRUE;
        List patterns = query.getQueryPatterns();
        for (int i = 0; i < patterns.size(); ++i) {
            QueryPattern triple = (QueryPattern)patterns.get(i);
            Bool tripleSatisfied = Bool.UNKNOWN;
            if (triple.isGround()) {
                Bool bool = tripleSatisfied = triple.isTypePattern() ? this.kb.isKnownType(triple.getSubject(), triple.getObject()) : this.kb.hasKnownPropertyValue(triple.getSubject(), triple.getPredicate(), triple.getObject());
            }
            if (tripleSatisfied.isUnknown()) {
                allTriplesSatisfied = Bool.UNKNOWN;
                continue;
            }
            if (!tripleSatisfied.isFalse()) continue;
            allTriplesSatisfied = Bool.FALSE;
            if (!QueryEngine.DEBUG) break;
            System.out.println("Failed triple: " + triple);
            break;
        }
        if (allTriplesSatisfied.isKnown()) {
            querySatisfied = allTriplesSatisfied.isTrue();
        } else {
            ATermAppl testInd = (ATermAppl)query.getConstants().get(0);
            ATermAppl testClass = query.rollUpTo(testInd);
            if (QueryEngine.DEBUG) {
                System.out.println("Boolean query: " + testInd + " -> " + testClass);
            }
            querySatisfied = this.kb.isType(testInd, testClass);
        }
        return querySatisfied;
    }
}

