/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.servlet;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.rdf.model.Model;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashSet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mindswap.pellet.servlet.DatasetManager;

public class Spas
extends HttpServlet {
    DatasetManager dataManager = null;

    public void init(ServletConfig config) {
        int managerSize;
        try {
            managerSize = Integer.parseInt(config.getInitParameter("dataset.cachesize"));
        }
        catch (NumberFormatException e) {
            managerSize = 10;
        }
        this.dataManager = new DatasetManager(managerSize);
        String backgroundList = config.getInitParameter("dataset.default.graphs");
        String namedList = config.getInitParameter("dataset.default.named");
        HashSet<Object> backgrounds = new HashSet();
        HashSet<Object> named = new HashSet();
        if (backgroundList != null && backgroundList.trim().length() > 0) {
            backgrounds = new HashSet<String>(Arrays.asList(backgroundList.split("\\s+")));
        }
        if (namedList != null && namedList.trim().length() > 0) {
            named = new HashSet<String>(Arrays.asList(namedList.split(" ")));
        }
        System.out.println("Setting default dataset: " + backgrounds + ", " + named);
        this.dataManager.setDefaultDataset(backgrounds, named);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getParameterMap().containsKey("reset")) {
            this.dataManager.reset();
        }
        if (request.getParameterMap().containsKey("query")) {
            this.doQuery(request, response);
        }
    }

    public void doQuery(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String queryString = request.getParameter("query");
        Query query = QueryFactory.create(queryString);
        Dataset dataset = this.getDataset(request, query);
        QueryExecution qexec = QueryExecutionFactory.create(query, dataset);
        this.setContentType(request, response, query);
        if (query.isAskType()) {
            this.execAsk(request, response, qexec);
        } else if (query.isConstructType()) {
            this.outputModel(request, response, qexec.execConstruct());
        } else if (query.isDescribeType()) {
            this.outputModel(request, response, qexec.execDescribe());
        } else if (query.isSelectType()) {
            this.execSelect(request, response, query, qexec);
        } else {
            response.setStatus(400);
            response.setContentType("text/plain");
            PrintWriter out = response.getWriter();
            ((Writer)out).write("Unknown type for query:\n" + queryString);
        }
        this.dataManager.returnDataset(dataset);
    }

    public void execAsk(HttpServletRequest request, HttpServletResponse response, QueryExecution qexec) throws IOException {
        boolean result = qexec.execAsk();
        ServletOutputStream out = response.getOutputStream();
        if (request.getParameterMap().containsKey("text")) {
            ResultSetFormatter.out((OutputStream)out, result);
        } else {
            ResultSetFormatter.outputAsXML((OutputStream)out, result);
        }
    }

    public void execSelect(HttpServletRequest request, HttpServletResponse response, Query query, QueryExecution qexec) throws IOException {
        ResultSet results = qexec.execSelect();
        ServletOutputStream out = response.getOutputStream();
        if (request.getParameterMap().containsKey("text")) {
            ResultSetFormatter.out((OutputStream)out, results, query);
        } else {
            ResultSetFormatter.outputAsXML((OutputStream)out, results, query);
        }
    }

    public Dataset getDataset(HttpServletRequest request, Query query) {
        HashSet<Object> defaultGraphs = new HashSet(query.getGraphURIs());
        HashSet<Object> namedGraphs = new HashSet(query.getNamedGraphURIs());
        String[] defaultList = request.getParameterValues("default-graph-uri");
        String[] namedList = request.getParameterValues("named-graph-uri");
        if (defaultList != null) {
            defaultGraphs = new HashSet<String>(Arrays.asList(defaultList));
        }
        if (namedList != null) {
            namedGraphs = new HashSet<String>(Arrays.asList(namedList));
        }
        return this.dataManager.getDataset(defaultGraphs, namedGraphs);
    }

    public void outputModel(HttpServletRequest request, HttpServletResponse response, Model model) throws IOException {
        ServletOutputStream out = response.getOutputStream();
        model.write((OutputStream)out);
    }

    public void setContentType(HttpServletRequest request, HttpServletResponse response, Query query) throws IOException {
        if (request.getParameterMap().containsKey("text")) {
            response.setContentType("text/plain");
        } else if (query.isAskType() || query.isSelectType()) {
            response.setContentType("application/sparql+xml");
        } else if (query.isConstructType() || query.isDescribeType()) {
            response.setContentType("applicate/rdf+xml");
        }
    }
}

