/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SetUtils {
    public static final Set EMPTY_SET = Collections.EMPTY_SET;

    public static final Set singleton(Object o) {
        return Collections.singleton(o);
    }

    public static final Set binary(Object o1, Object o2) {
        HashSet<Object> set = new HashSet<Object>();
        set.add(o1);
        set.add(o2);
        return set;
    }

    public static Set union(Collection coll) {
        HashSet set = new HashSet();
        Iterator i = coll.iterator();
        while (i.hasNext()) {
            set.addAll((Collection)i.next());
        }
        return set;
    }

    public static Set union(Collection c1, Collection c2) {
        HashSet set = new HashSet();
        set.addAll(c1);
        set.addAll(c2);
        return set;
    }

    public static Set intersection(Collection c1, Collection c2) {
        HashSet set = new HashSet();
        set.addAll(c1);
        set.retainAll(c2);
        return set;
    }

    public static boolean intersects(Collection c1, Collection c2) {
        Iterator i = c1.iterator();
        while (i.hasNext()) {
            if (!c2.contains(i.next())) continue;
            return true;
        }
        return false;
    }

    public static boolean subset(Set sub, Set sup) {
        return sub.size() <= sup.size() && sup.containsAll(sub);
    }

    public static boolean equals(Set s1, Set s2) {
        return s1.size() == s2.size() && s1.containsAll(s2);
    }

    public static Set difference(Collection c1, Collection c2) {
        HashSet set = new HashSet();
        set.addAll(c1);
        set.removeAll(c2);
        return set;
    }

    public static Set create(Object[] elems) {
        HashSet<Object> set = new HashSet<Object>();
        for (int i = 0; i < elems.length; ++i) {
            set.add(elems[i]);
        }
        return set;
    }

    public static Set create(Collection coll) {
        return new HashSet(coll);
    }
}

