/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils;

import org.mindswap.pellet.exceptions.TimeoutException;

public class Timer {
    public static final long NOT_STARTED = -1L;
    public static final long NO_TIMEOUT = 0L;
    private String name;
    private long totalTime;
    private long startTime;
    private long count;
    private long startCount;
    private long timeout;
    private long lastTime;
    private Timer dependant;

    public Timer(String name) {
        this(name, null);
    }

    public Timer(String name, Timer dependant) {
        this.name = name;
        this.dependant = dependant;
        this.timeout = 0L;
        this.reset();
    }

    public void start() {
        if (this.startCount == 0L) {
            this.startTime = System.currentTimeMillis();
        }
        ++this.startCount;
    }

    public void stop() {
        if (!this.isStarted()) {
            throw new UnsupportedOperationException("Cannot stop timer '" + this.name + "' which is not started!");
        }
        --this.startCount;
        if (!this.isStarted()) {
            this.lastTime = System.currentTimeMillis() - this.startTime;
            this.totalTime += this.lastTime;
            this.startTime = -1L;
            ++this.count;
        }
    }

    public void reset() {
        this.totalTime = 0L;
        this.startTime = -1L;
        this.startCount = 0L;
        this.count = 0L;
    }

    public void check() throws TimeoutException {
        long elapsed = this.getElapsed();
        if (this.timeout != 0L && elapsed > this.timeout) {
            throw new TimeoutException("Running time of " + this.name + " exceeded timeout of " + this.timeout);
        }
        if (this.dependant != null) {
            this.dependant.check();
        }
    }

    public boolean isStarted() {
        return this.startCount > 0L;
    }

    public String getName() {
        return this.name;
    }

    public long getElapsed() {
        return this.isStarted() ? System.currentTimeMillis() - this.startTime : 0L;
    }

    public long getTotal() {
        return this.totalTime;
    }

    public long getCount() {
        return this.count;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public double getAverage() {
        return (double)this.totalTime / (double)this.count;
    }

    public long getLast() {
        return this.lastTime;
    }

    public void setTimeout(long timeout) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("Cannot set the timeout to a negative value!");
        }
        this.timeout = timeout;
    }

    public String toString() {
        if (this.startCount > 0L) {
            return "Timer " + this.name + " Avg: " + this.getAverage() + " Count: " + this.count + " Total: " + this.getTotal() + " Still running: " + this.startCount;
        }
        return "Timer " + this.name + " Avg: " + this.getAverage() + " Count: " + this.count + " Total: " + this.getTotal();
    }
}

