/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.mindswap.pellet.output.TableData;
import org.mindswap.pellet.utils.Timer;

public class Timers {
    private Map timers = new HashMap();
    public Timer mainTimer = this.createTimer("main");

    public Timers() {
        this.mainTimer.start();
    }

    public Timer createTimer(String name) {
        Timer t = new Timer(name, this.mainTimer);
        this.timers.put(name, t);
        return t;
    }

    public Timer startTimer(String name) {
        Timer t = this.getTimer(name);
        if (t == null) {
            t = this.createTimer(name);
        }
        t.start();
        return t;
    }

    public void checkTimer(String name) {
        Timer t = this.getTimer(name);
        if (t == null) {
            throw new UnsupportedOperationException("Timer " + name + " does not exist!");
        }
        t.check();
    }

    public void resetTimer(String name) {
        Timer t = this.getTimer(name);
        if (t == null) {
            throw new UnsupportedOperationException("Timer " + name + " does not exist!");
        }
        t.start();
    }

    public void setTimeout(String name, long timeout) {
        Timer t = this.getTimer(name);
        if (t == null) {
            t = this.createTimer(name);
        }
        t.setTimeout(timeout);
    }

    public void stopTimer(String name) {
        Timer t = this.getTimer(name);
        if (t == null) {
            throw new UnsupportedOperationException("Timer " + name + " does not exist!");
        }
        t.stop();
    }

    public void resetAll() {
        Iterator i = this.timers.values().iterator();
        while (i.hasNext()) {
            Timer timer = (Timer)i.next();
            timer.reset();
        }
    }

    public Timer getTimer(String name) {
        return (Timer)this.timers.get(name);
    }

    public void print() {
        this.print(false);
    }

    public void print(boolean shortForm) {
        String[] stringArray;
        if (shortForm) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "Name";
            stringArray = stringArray2;
            stringArray2[1] = "Total (ms)";
        } else {
            String[] stringArray3 = new String[4];
            stringArray3[0] = "Name";
            stringArray3[1] = "Count";
            stringArray3[2] = "Avg";
            stringArray = stringArray3;
            stringArray3[3] = "Total (ms)";
        }
        String[] colNames = stringArray;
        ArrayList list = new ArrayList(this.timers.values());
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                return (int)(((Timer)o2).getTotal() - ((Timer)o1).getTotal());
            }
        });
        TableData table = new TableData(Arrays.asList(colNames));
        Iterator i = list.iterator();
        while (i.hasNext()) {
            Timer timer = (Timer)i.next();
            ArrayList<Object> row = new ArrayList<Object>();
            row.add(timer.getName());
            if (!shortForm) {
                row.add(new Long(timer.getCount()));
                row.add(new Double(timer.getAverage()));
            }
            row.add(new Long(timer.getTotal()));
            table.addRow(row);
        }
        table.print(System.out);
    }

    public void printShort() {
        String[] colNames = new String[]{"Name", "Total (ms)"};
        ArrayList list = new ArrayList(this.timers.values());
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                return (int)(((Timer)o2).getTotal() - ((Timer)o1).getTotal());
            }
        });
        TableData table = new TableData(Arrays.asList(colNames));
        Iterator i = list.iterator();
        while (i.hasNext()) {
            Timer timer = (Timer)i.next();
            ArrayList<Object> row = new ArrayList<Object>();
            row.add(timer.getName());
            row.add(new Long(timer.getCount()));
            row.add(new Double(timer.getAverage()));
            row.add(new Long(timer.getTotal()));
            table.addRow(row);
        }
        table.print(System.out);
    }

    public String toString() {
        return this.timers.values().toString();
    }
}

