/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.owlsmx;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import de.dfki.owlsmx.Indexer.Index;
import de.dfki.owlsmx.Indexer.SimpleIndex;
import de.dfki.owlsmx.SimilarityMatchmaker;
import de.dfki.owlsmx.data.ConceptServiceRegistry;
import de.dfki.owlsmx.data.DOM;
import de.dfki.owlsmx.data.ExtendedServiceInformation;
import de.dfki.owlsmx.data.InputServiceContainer;
import de.dfki.owlsmx.data.LocalOntologyContainer;
import de.dfki.owlsmx.data.MatchingResult;
import de.dfki.owlsmx.data.OutputServiceContainer;
import de.dfki.owlsmx.data.ServiceInformation;
import de.dfki.owlsmx.exceptions.ConceptNotFoundException;
import de.dfki.owlsmx.exceptions.MatchingException;
import de.dfki.owlsmx.io.ErrorLog;
import de.dfki.owlsmx.reasoning.PelletReasoner;
import de.dfki.owlsmx.similaritymeasures.SimilarityMeasure;
import de.dfki.owlsmx.utils.MatchmakerUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import org.mindswap.owl.OWLConfig;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owls.process.ParameterList;
import org.mindswap.owls.service.Service;
import org.mindswap.pellet.TuBox;
import org.mindswap.utils.URIUtils;

public class OWLSMXMatchmaker
extends SimilarityMatchmaker {
    private OWLKnowledgeBase base = OWLFactory.createKB();
    private LocalOntologyContainer localOntologyContainer = new LocalOntologyContainer();
    private ConceptServiceRegistry registry;
    private PelletReasoner reason;
    private HashMap<Integer, String> unfoldedInputs = new HashMap();
    private HashMap<Integer, String> unfoldedOutputs = new HashMap();
    private HashMap<Integer, Vector<String>> inputConcepts = new HashMap();
    private HashMap<Integer, Vector<String>> outputConcepts = new HashMap();
    private Index inputIndex = new SimpleIndex();
    private Index outputIndex = new SimpleIndex();
    private boolean integrative = false;
    private Index inConceptIndex = new SimpleIndex();
    private Index outConceptIndex = new SimpleIndex();
    private Index descIndex = new SimpleIndex();
    private HashMap<Integer, String> offerDescriptions = new HashMap();
    private double alpha = 1.0;

    private void init(SimilarityMeasure similar) {
        this.reason = new PelletReasoner();
        this.registry = ConceptServiceRegistry.instanceOf();
        this.sim = similar;
    }

    public OWLSMXMatchmaker() {
        this.init(null);
    }

    public OWLSMXMatchmaker(SimilarityMeasure similar) {
        this.init(similar);
    }

    public OWLSMXMatchmaker(short sim) {
        SimilarityMeasure similar = this.switchSimilarityMeasure(sim);
        this.init(similar);
    }

    public OWLSMXMatchmaker(SimilarityMeasure similar, boolean integrative) {
        this.init(similar);
        this.integrative = integrative;
    }

    public OWLSMXMatchmaker(SimilarityMeasure similar, boolean integrative, boolean structure) {
        this.init(similar);
        this.integrative = integrative;
        this.useStructuralFilter = structure;
    }

    public OWLSMXMatchmaker(short sim, boolean integrative) {
        SimilarityMeasure similar = this.switchSimilarityMeasure(sim);
        this.init(similar);
        this.integrative = integrative;
    }

    public String toString() {
        return this.registry.toString();
    }

    public void print() {
        System.err.println(this.getClass().toString());
        System.err.println(this.toString());
    }

    private SortedSet getServicesFromSet(boolean isInput, Set classes, OntClass concept, int degreeOfMatch) throws URISyntaxException, ConceptNotFoundException {
        this.save();
        TreeSet<ExtendedServiceInformation> result = new TreeSet<ExtendedServiceInformation>();
        for (RDFNode clazz : classes) {
            Set services = this.registry.getServices(isInput, clazz.toString());
            for (ServiceInformation info : services) {
                try {
                    if (this.useSyntacticFilter()) {
                        result.add(new ExtendedServiceInformation(info, degreeOfMatch, this.reason.unfoldTerm(clazz)));
                        continue;
                    }
                    result.add(new ExtendedServiceInformation(info, degreeOfMatch, ""));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    private SortedSet getServicesForOutputConcept(String concept) throws URISyntaxException, ConceptNotFoundException {
        OntClass clazz = this.localOntologyContainer.getOntClass(concept);
        Set equivalent = this.reason.retrieveEquivalentClasses(clazz);
        Set parents = this.reason.retrieveDirectParentClasses(clazz, equivalent);
        Set ancestors = this.reason.retrieveAncestorClasses(clazz, equivalent, parents);
        Set childs = this.reason.retrieveDirectSubClasses(clazz, equivalent);
        Set decendants = this.reason.retrieveDescendantClasses(clazz, equivalent, childs);
        TreeSet candidates = new TreeSet();
        candidates.addAll(this.getServicesFromSet(false, equivalent, clazz, 0));
        candidates.addAll(this.getServicesFromSet(false, childs, clazz, 1));
        candidates.addAll(this.getServicesFromSet(false, decendants, clazz, 2));
        candidates.addAll(this.getServicesFromSet(false, parents, clazz, 3));
        candidates.addAll(this.getServicesFromSet(false, this.reason.retrieveRemainingClasses(clazz, equivalent, parents, new HashSet(), childs, decendants), clazz, 4));
        return candidates;
    }

    private SortedSet getServicesForInputConcept(String concept) throws URISyntaxException, ConceptNotFoundException {
        OntClass clazz = this.localOntologyContainer.getOntClass(concept);
        Set equivalent = this.reason.retrieveEquivalentClasses(clazz);
        Set ancestors = this.reason.retrieveAllAncestorClasses(clazz);
        TreeSet candidates = new TreeSet();
        candidates.addAll(this.getServicesFromSet(true, equivalent, clazz, 0));
        candidates.addAll(this.getServicesFromSet(true, ancestors, clazz, 1));
        candidates.addAll(this.getServicesFromSet(true, this.reason.retrieveAllRemainingClasses(clazz, equivalent, ancestors), clazz, 4));
        return candidates;
    }

    private Map getOutputCandidates(Vector outConcepts) throws URISyntaxException, MatchingException {
        if (outConcepts.size() == 0) {
            return this.registry.getAllServices(false);
        }
        OutputServiceContainer resultContainer = new OutputServiceContainer();
        resultContainer.addServices(this.getServicesForOutputConcept(((URI)outConcepts.get(0)).toString()));
        int i = 1;
        while (i < outConcepts.size()) {
            OutputServiceContainer serviceContainer = new OutputServiceContainer();
            serviceContainer.addServices(this.getServicesForOutputConcept(((URI)outConcepts.get(i)).toString()));
            resultContainer.merge(serviceContainer);
            ++i;
        }
        System.out.println("Output candidates: " + resultContainer.getServiceMap().values().toString());
        return resultContainer.getServiceMap();
    }

    private Map addEmptyInputs(Map inputCandidates) {
        Map ServicesWithoutInput = this.registry.getAllServicesWithoutInput();
        for (Map.Entry me : ServicesWithoutInput.entrySet()) {
            ExtendedServiceInformation exInfo = (ExtendedServiceInformation)me.getValue();
            inputCandidates.put((Integer)me.getKey(), new ExtendedServiceInformation(exInfo.serviceID, true, exInfo.conceptID, exInfo.noConcepts, 0, 0.0));
        }
        return inputCandidates;
    }

    protected Map getInputCandidates(Vector inConcepts) throws URISyntaxException, ConceptNotFoundException {
        if (inConcepts.size() <= 0) {
            return this.registry.getAllServicesWithoutInput();
        }
        InputServiceContainer inputs = new InputServiceContainer();
        int i = 0;
        while (i < inConcepts.size()) {
            SortedSet sort = this.getServicesForInputConcept(((URI)inConcepts.get(i)).toString());
            inputs.addServices(sort);
            ++i;
        }
        System.out.println("Input candidates: " + inputs.getServices().values().toString());
        return this.addEmptyInputs(inputs.getServices());
    }

    protected Set getServiceInformationFromDOM(Set serviceDOMs) {
        HashSet<ExtendedServiceInformation> result = new HashSet<ExtendedServiceInformation>();
        Iterator iter = serviceDOMs.iterator();
        while (iter.hasNext()) {
            result.add(((DOM)iter.next()).getBestDegree());
        }
        return result;
    }

    private SortedSet inputCandidatesToResult(Map inputCandidates) {
        TreeSet<MatchingResult> result = new TreeSet<MatchingResult>();
        for (Map.Entry me : inputCandidates.entrySet()) {
            ExtendedServiceInformation inInfo = (ExtendedServiceInformation)me.getValue();
            result.add(new MatchingResult(inInfo, inInfo.unfoldedconcept, ""));
        }
        return result;
    }

    protected SortedSet semanticMatch(Vector inConcepts, Vector outConcepts) throws URISyntaxException, MatchingException {
        Map input = this.getInputCandidates(inConcepts);
        if (outConcepts == null || outConcepts.size() <= 0) {
            return this.inputCandidatesToResult(input);
        }
        Map output = this.getOutputCandidates(outConcepts);
        TreeSet<MatchingResult> result = new TreeSet<MatchingResult>();
        for (Map.Entry me : input.entrySet()) {
            Integer ID = (Integer)me.getKey();
            if (!output.containsKey(ID)) continue;
            ExtendedServiceInformation inInfo = (ExtendedServiceInformation)me.getValue();
            DOM degree = (DOM)output.get(ID);
            ExtendedServiceInformation outInfo = degree.getBestDegree();
            if (inInfo.degreeOfMatch > outInfo.degreeOfMatch || inInfo.degreeOfMatch == outInfo.degreeOfMatch && inInfo.similarity < outInfo.similarity) {
                result.add(new MatchingResult(inInfo, inInfo.unfoldedconcept, outInfo.unfoldedconcept));
                continue;
            }
            result.add(new MatchingResult(outInfo, inInfo.unfoldedconcept, outInfo.unfoldedconcept));
        }
        return result;
    }

    protected SortedSet syntacticFilter(Service queryService, Vector queryInputs, Vector queryOutputs, SortedSet semanticResults) throws TuBox.NotUnfoldableException, URISyntaxException, MatchingException {
        TreeSet<MatchingResult> result = new TreeSet<MatchingResult>();
        String input = this.reason.unfoldURIs(queryInputs);
        String output = this.reason.unfoldURIs(queryOutputs);
        for (MatchingResult info : semanticResults) {
            double sim_output;
            double sim_input;
            Vector<String> sInputs = this.inputConcepts.get(info.getServiceID());
            Vector<String> sOutputs = this.outputConcepts.get(info.getServiceID());
            if (sInputs.size() == 0 && queryInputs.size() == 0) {
                sim_input = 1.0;
            } else if (sInputs.size() == 0 || queryInputs.size() == 0) {
                sim_input = 0.0;
            } else {
                this.sim.setIndex(this.inputIndex);
                sim_input = this.sim.computeSimilarity(queryService.getURI().toString(), input, info.serviceID + "_I", info.unfoldedInput);
            }
            if (sOutputs.size() == 0 && queryOutputs.size() == 0) {
                sim_output = 1.0;
            } else if (sOutputs.size() == 0 || queryOutputs.size() == 0) {
                sim_output = 0.0;
            } else {
                this.sim.setIndex(this.outputIndex);
                sim_output = this.sim.computeSimilarity(queryService.getURI().toString(), output, info.serviceID + "_O", info.unfoldedOutput);
            }
            double simC = 0.5 * (sim_input + sim_output);
            double simSA = -1.0;
            String queryDescription = queryService.getProfile().getTextDescription();
            String offerDescription = this.offerDescriptions.get(info.serviceID);
            if (queryDescription != null && !queryDescription.equals("") && offerDescription != null && !offerDescription.equals("")) {
                this.sim.setIndex(this.descIndex);
                simSA = this.sim.computeSimilarity(queryService.getURI().toString(), queryDescription, "" + info.serviceID, this.offerDescriptions.get(info.serviceID));
            }
            info.similarity = simSA >= 0.0 ? this.alpha * simC + (1.0 - this.alpha) * simSA : simC;
            if (this.useStructuralFilter()) {
                double structScore;
                double inScore = 0.0;
                for (String sInput : sInputs) {
                    double maxScore = 0.0;
                    for (Object qInput : queryInputs) {
                        double score = this.compareStructure(qInput.toString(), sInput.toString());
                        maxScore = Math.max(maxScore, score);
                    }
                    inScore += maxScore;
                }
                if (!sInputs.isEmpty()) {
                    inScore /= (double)sInputs.size();
                }
                double outScore = 0.0;
                for (Object qOutput : queryOutputs) {
                    double maxScore = 0.0;
                    for (String sOutput : sOutputs) {
                        double score = this.compareStructure(qOutput.toString(), sOutput.toString());
                        maxScore = Math.max(maxScore, score);
                    }
                    outScore += maxScore;
                }
                if (!queryOutputs.isEmpty()) {
                    outScore /= (double)queryOutputs.size();
                }
                if (sInputs.size() == 0 && queryInputs.size() == 0) {
                    inScore = 1.0;
                }
                if (sOutputs.size() == 0 && queryOutputs.size() == 0) {
                    outScore = 1.0;
                }
                int maxInSize = Math.max(sInputs.size(), queryInputs.size());
                double inSigScore = 1.0;
                if (maxInSize != 0) {
                    inSigScore = 1.0 - (double)Math.abs(sInputs.size() - queryInputs.size()) / (double)maxInSize;
                }
                inScore = 0.5 * (inScore + inSigScore);
                int maxOutSize = Math.max(sOutputs.size(), queryOutputs.size());
                double outSigScore = 1.0;
                if (maxOutSize != 0) {
                    outSigScore = 1.0 - (double)Math.abs(sOutputs.size() - queryOutputs.size()) / (double)maxOutSize;
                }
                outScore = 0.5 * (outScore + outSigScore);
                info.structure = structScore = 0.5 * (inScore + outScore);
            }
            if (info.similarity < this.getSyntacticTreshold()) {
                if (info.degreeOfMatch == 4 || info.degreeOfMatch == 3) {
                    info.degreeOfMatch = 5;
                } else if (this.integrative) {
                    info.degreeOfMatch = 5;
                } else {
                    result.add(info);
                }
            } else {
                result.add(info);
            }
            if (info.degreeOfMatch != 5) continue;
            result.add(info);
        }
        return result;
    }

    protected double compareStructure(String qConcept, String sConcept) {
        OntClass qClass = this.localOntologyContainer.getOntClass(qConcept);
        OntClass sClass = this.localOntologyContainer.getOntClass(sConcept);
        double simDist = 1.0;
        if (!sConcept.equals(qConcept)) {
            try {
                OntClass dcs = this.getDirectCommonSubsumer(qClass, sClass);
                int h = this.getDepth(dcs);
                int l = this.getDepth(qClass) + this.getDepth(sClass) - 2 * h;
                double alpha = 0.2;
                double beta = 0.6;
                double expBetaH = Math.exp(beta * (double)h);
                double mExpBetaH = Math.exp(-beta * (double)h);
                simDist = Math.exp(-alpha * (double)l) * (expBetaH - mExpBetaH) / (expBetaH + mExpBetaH);
            }
            catch (Exception e) {
                simDist = 0.0;
            }
        }
        return simDist;
    }

    protected int getDepth(OntClass clazz) {
        if (clazz == null || clazz.getURI().toString().contains("owl#Thing")) {
            return 0;
        }
        Set equivalents = this.reason.retrieveEquivalentClasses(clazz);
        Set parents = this.reason.retrieveDirectParentClasses(clazz, equivalents);
        if (parents.isEmpty()) {
            return 0;
        }
        int min = Integer.MAX_VALUE;
        for (Object parent : parents) {
            String pUri = ((RDFNode)parent).asNode().getURI();
            int depth = 0;
            if (!pUri.contains("owl#Thing")) {
                OntClass pClass = this.localOntologyContainer.getOntClass(pUri);
                depth = this.getDepth(pClass);
            }
            min = Math.min(min, depth);
        }
        return min + 1;
    }

    protected OntClass getDirectCommonSubsumer(OntClass clazz1, OntClass clazz2) {
        Set ancestors1 = this.reason.retrieveAllAncestorClasses(clazz1);
        Set ancestors2 = this.reason.retrieveAllAncestorClasses(clazz2);
        HashSet commonAncestors = new HashSet();
        for (Object ancestor : ancestors1) {
            if (!ancestors2.contains(ancestor)) continue;
            commonAncestors.add(ancestor);
        }
        int max = 0;
        OntClass dcs = this.localOntologyContainer.getOntClass("http://www.w3.org/2002/07/owl#Thing");
        for (Object ancestor : commonAncestors) {
            OntClass clazz = this.localOntologyContainer.getOntClass(((RDFNode)ancestor).asNode().getURI().toString());
            int depth = this.getDepth(clazz);
            if (depth <= max) continue;
            max = depth;
            dcs = clazz;
        }
        return dcs;
    }

    public SortedSet syntacticFilter(URI profileURI) throws TuBox.NotUnfoldableException, URISyntaxException, MatchingException {
        try {
            OWLOntology onto = this.base.read(profileURI);
            Service service = onto.getService();
            Vector queryInputs = MatchmakerUtils.getURIList((ParameterList)service.getProfile().getInputs());
            Vector queryOutputs = MatchmakerUtils.getURIList((ParameterList)service.getProfile().getOutputs());
            HashSet conceptsToAdd = new HashSet();
            conceptsToAdd.addAll(queryInputs);
            conceptsToAdd.addAll(queryOutputs);
            this.localOntologyContainer.processClasses(this.base, conceptsToAdd);
            this.updateReasoner();
            String input = this.reason.unfoldURIs(queryInputs);
            String output = this.reason.unfoldURIs(queryOutputs);
            Date date = new Date();
            this.inputIndex.addDocument(String.valueOf(service.getURI().toString()) + "_I", input);
            this.outputIndex.addDocument(String.valueOf(service.getURI().toString()) + "_O", output);
            Map in = this.registry.getAllServices(true);
            Map out = this.registry.getAllServices(false);
            HashMap services = new HashMap(in);
            services.putAll(out);
            TreeSet<MatchingResult> results = new TreeSet<MatchingResult>();
            Iterator iterator = services.entrySet().iterator();
            while (iterator.hasNext()) {
                double sim_output;
                double sim_input;
                Map.Entry obj;
                Map.Entry entry = obj = iterator.next();
                ExtendedServiceInformation extendedServiceInfo = (ExtendedServiceInformation)entry.getValue();
                Integer ID = (Integer)entry.getKey();
                String unfoldedIn = this.unfoldedInputs.get(ID);
                String unfoldedOut = this.unfoldedOutputs.get(ID);
                Vector<String> sInputs = this.inputConcepts.get(ID);
                Vector<String> sOutputs = this.outputConcepts.get(ID);
                MatchingResult matchingResult = new MatchingResult(extendedServiceInfo, unfoldedIn, unfoldedOut);
                matchingResult.setDegreeOfMatch(4);
                if (sInputs.size() == 0 && queryInputs.size() == 0) {
                    sim_input = 1.0;
                } else if (sInputs.size() == 0 || queryInputs.size() == 0) {
                    sim_input = 0.0;
                } else {
                    this.sim.setIndex(this.inputIndex);
                    sim_input = this.sim.computeSimilarity(profileURI.toString(), input, ID + "_I", unfoldedIn);
                }
                if (sOutputs.size() == 0 && queryOutputs.size() == 0) {
                    sim_output = 1.0;
                } else if (sOutputs.size() == 0 || queryOutputs.size() == 0) {
                    sim_output = 0.0;
                } else {
                    this.sim.setIndex(this.outputIndex);
                    sim_output = this.sim.computeSimilarity(profileURI.toString(), output, ID + "_O", unfoldedOut);
                }
                double simC = 0.5 * (sim_input + sim_output);
                double simSA = -1.0;
                String queryDescription = service.getProfile().getTextDescription();
                String offerDescription = this.offerDescriptions.get(ID);
                if (queryDescription != null && !queryDescription.equals("") && offerDescription != null && !offerDescription.equals("")) {
                    this.sim.setIndex(this.descIndex);
                    simSA = this.sim.computeSimilarity(profileURI.toString(), queryDescription, "" + ID, this.offerDescriptions.get(ID));
                }
                matchingResult.similarity = simSA >= 0.0 ? this.alpha * simC + (1.0 - this.alpha) * simSA : simC;
                results.add(matchingResult);
            }
            System.out.println("QRT: " + (new Date().getTime() - date.getTime()));
            this.base.unload(profileURI);
            return results;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MatchingException(e.toString());
        }
    }

    public SortedSet structuralFilter(URI profileURI) throws TuBox.NotUnfoldableException, URISyntaxException, MatchingException {
        try {
            OWLOntology onto = this.base.read(profileURI);
            Service service = onto.getService();
            Vector queryInputs = MatchmakerUtils.getURIList((ParameterList)service.getProfile().getInputs());
            Vector queryOutputs = MatchmakerUtils.getURIList((ParameterList)service.getProfile().getOutputs());
            HashSet conceptsToAdd = new HashSet();
            conceptsToAdd.addAll(queryInputs);
            conceptsToAdd.addAll(queryOutputs);
            this.localOntologyContainer.processClasses(this.base, conceptsToAdd);
            this.updateReasoner();
            this.base.unload(profileURI);
            Map in = this.registry.getAllServices(true);
            Map out = this.registry.getAllServices(false);
            HashMap services = new HashMap(in);
            services.putAll(out);
            TreeSet<MatchingResult> results = new TreeSet<MatchingResult>();
            Iterator iterator = services.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry obj;
                Map.Entry entry = obj = iterator.next();
                ExtendedServiceInformation extendedServiceInfo = (ExtendedServiceInformation)entry.getValue();
                Integer ID = (Integer)entry.getKey();
                Vector<String> sInputs = this.inputConcepts.get(ID);
                Vector<String> sOutputs = this.outputConcepts.get(ID);
                double inScore = 0.0;
                for (String sInput : sInputs) {
                    double maxScore = 0.0;
                    for (Object qInput : queryInputs) {
                        double score = this.compareStructure(qInput.toString(), sInput.toString());
                        maxScore = Math.max(maxScore, score);
                    }
                    inScore += maxScore;
                }
                if (!sInputs.isEmpty()) {
                    inScore /= (double)sInputs.size();
                }
                double outScore = 0.0;
                for (Object qOutput : queryOutputs) {
                    double maxScore = 0.0;
                    for (String sOutput : sOutputs) {
                        double score = this.compareStructure(qOutput.toString(), sOutput.toString());
                        maxScore = Math.max(maxScore, score);
                    }
                    outScore += maxScore;
                }
                if (!queryOutputs.isEmpty()) {
                    outScore /= (double)queryOutputs.size();
                }
                if (sInputs.size() == 0 && queryInputs.size() == 0) {
                    inScore = 1.0;
                }
                if (sOutputs.size() == 0 && queryOutputs.size() == 0) {
                    outScore = 1.0;
                }
                int maxInSize = Math.max(sInputs.size(), queryInputs.size());
                double inSigScore = 1.0;
                if (maxInSize != 0) {
                    inSigScore = 1.0 - (double)Math.abs(sInputs.size() - queryInputs.size()) / (double)maxInSize;
                }
                inScore = 0.5 * (inScore + inSigScore);
                int maxOutSize = Math.max(sOutputs.size(), queryOutputs.size());
                double outSigScore = 1.0;
                if (maxOutSize != 0) {
                    outSigScore = 1.0 - (double)Math.abs(sOutputs.size() - queryOutputs.size()) / (double)maxOutSize;
                }
                outScore = 0.5 * (outScore + outSigScore);
                double structScore = 0.5 * (inScore + outScore);
                MatchingResult matchingResult = new MatchingResult(extendedServiceInfo, "", "");
                matchingResult.structure = structScore;
                results.add(matchingResult);
            }
            return results;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MatchingException(e.toString());
        }
    }

    public SortedSet syntacticFilter(InputStream profileStream) throws MatchingException {
        try {
            OWLOntology onto = this.base.read(profileStream, URIUtils.createURI((String)""));
            Service service = onto.getService();
            this.base.unload(onto);
            return this.syntacticFilter(service.getURI());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MatchingException(e.toString());
        }
    }

    public SortedSet structuralFilter(InputStream profileStream) throws MatchingException {
        try {
            OWLOntology onto = this.base.read(profileStream, URIUtils.createURI((String)""));
            Service service = onto.getService();
            this.base.unload(onto);
            return this.structuralFilter(service.getURI());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MatchingException(e.toString());
        }
    }

    @Override
    public void addService(Integer integer, URI profileURI) {
        try {
            OWLOntology onto = this.base.read(profileURI);
            Service service = onto.getService();
            this.addService(integer, onto, MatchmakerUtils.getURIList((ParameterList)service.getProfile().getInputs()), MatchmakerUtils.getURIList((ParameterList)service.getProfile().getOutputs()));
        }
        catch (FileNotFoundException e) {
            ErrorLog.instanceOf().report(String.valueOf(this.getClass().toString()) + "|addService: Could not add service from this URI" + profileURI.toString());
            e.printStackTrace();
        }
        this.base.unload(profileURI);
    }

    @Override
    public void addService(Integer integer, InputStream profileStream, URI baseURI) {
        OWLOntology onto = this.base.read(profileStream, baseURI);
        if (onto == null) {
            ErrorLog.instanceOf().report(String.valueOf(this.getClass().toString()) + "|addService: Unable to add service from input stream");
            return;
        }
        Service service = onto.getService();
        this.addService(integer, onto, MatchmakerUtils.getURIList((ParameterList)service.getProfile().getInputs()), MatchmakerUtils.getURIList((ParameterList)service.getProfile().getOutputs()));
        this.base.unload(onto);
    }

    @Override
    public void addService(Integer integer, String profile, URI baseURI) {
        ByteArrayInputStream profileStream = new ByteArrayInputStream(profile.getBytes());
        this.addService(integer, profileStream, baseURI);
    }

    private void updateReasoner() {
        this.reason.clear();
        this.reason.load((Model)((OntModel)this.localOntologyContainer.getOntology().getImplementation()));
    }

    private void addService(Integer serviceID, OWLOntology onto, Vector inputurilist, Vector outputurilist) {
        try {
            HashSet conceptsToAdd = new HashSet();
            conceptsToAdd.addAll(inputurilist);
            conceptsToAdd.addAll(outputurilist);
            this.localOntologyContainer.processClasses(this.base, conceptsToAdd);
            this.updateReasoner();
            if (this.useSyntacticFilter()) {
                String unfoldedInput = this.reason.unfoldURIs(inputurilist);
                String unfoldedOutput = this.reason.unfoldURIs(outputurilist);
                this.inputIndex.addDocument(serviceID + "_I", unfoldedInput);
                this.outputIndex.addDocument(serviceID + "_O", unfoldedOutput);
                this.unfoldedInputs.put(serviceID, unfoldedInput);
                this.unfoldedOutputs.put(serviceID, unfoldedOutput);
                this.descIndex.addDocument("" + serviceID, onto.getService().getProfile().getTextDescription());
                this.offerDescriptions.put(serviceID, onto.getService().getProfile().getTextDescription());
            }
            this.inputConcepts.put(serviceID, inputurilist);
            this.outputConcepts.put(serviceID, outputurilist);
            this.registry.addConcepts(true, (int)serviceID, inputurilist);
            this.registry.addConcepts(false, (int)serviceID, outputurilist);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public SortedSet matchRequest(URI profileURI) throws MatchingException {
        try {
            OWLOntology onto = this.base.read(profileURI);
            Service service = onto.getService();
            Vector inputurilist = MatchmakerUtils.getURIList((ParameterList)service.getProfile().getInputs());
            Vector outputurilist = MatchmakerUtils.getURIList((ParameterList)service.getProfile().getOutputs());
            HashSet conceptsToAdd = new HashSet();
            conceptsToAdd.addAll(inputurilist);
            conceptsToAdd.addAll(outputurilist);
            this.localOntologyContainer.processClasses(this.base, conceptsToAdd);
            this.updateReasoner();
            SortedSet result = this.useSyntacticFilter() ? this.syntacticFilter(service, inputurilist, outputurilist, this.semanticMatch(inputurilist, outputurilist)) : this.semanticMatch(inputurilist, outputurilist);
            this.base.unload(profileURI);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MatchingException(e.toString());
        }
    }

    @Override
    public SortedSet matchRequest(InputStream profileStream) throws MatchingException {
        try {
            OWLOntology onto = this.base.read(profileStream, URIUtils.createURI((String)""));
            Service service = onto.getService();
            Vector inputurilist = MatchmakerUtils.getURIList((ParameterList)service.getProfile().getInputs());
            Vector outputurilist = MatchmakerUtils.getURIList((ParameterList)service.getProfile().getOutputs());
            HashSet conceptsToAdd = new HashSet();
            conceptsToAdd.addAll(inputurilist);
            conceptsToAdd.addAll(outputurilist);
            this.localOntologyContainer.processClasses(this.base, conceptsToAdd);
            this.updateReasoner();
            SortedSet result = this.useSyntacticFilter() ? this.syntacticFilter(service, inputurilist, outputurilist, this.semanticMatch(inputurilist, outputurilist)) : this.semanticMatch(inputurilist, outputurilist);
            this.base.unload(onto);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MatchingException(e.toString());
        }
    }

    @Override
    public SortedSet matchRequest(String profile) throws MatchingException {
        ByteArrayInputStream profileStream = new ByteArrayInputStream(profile.getBytes());
        return this.matchRequest(profileStream);
    }

    @Override
    public void removeService(Integer integer) {
        this.registry.removeService(integer);
    }

    @Override
    public boolean load() {
        boolean result;
        try {
            result = LocalOntologyContainer.load();
            File file = new File("registry.data");
            if (!file.exists()) {
                return false;
            }
            ObjectInputStream in = new ObjectInputStream(new FileInputStream(file));
            this.registry = (ConceptServiceRegistry)in.readObject();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            ErrorLog.instanceOf().report(e.toString());
            return false;
        }
        return result;
    }

    @Override
    public boolean save() {
        try {
            boolean result = this.localOntologyContainer.save();
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream("registry.data"));
            out.writeObject(this.registry);
            out.close();
            return result;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void clear() {
        ConceptServiceRegistry.instanceOf().clear();
        this.inputIndex.clear();
        this.outputIndex.clear();
        this.inputConcepts.clear();
        this.outputConcepts.clear();
    }

    public void enableProfileHierarchies(boolean speedyButProblematic) {
        if (speedyButProblematic) {
            OWLConfig.setStrictConversion((boolean)false);
        } else {
            this.base.setReasoner("RDFS");
        }
    }

    public void disableProfileHierarchies() {
        this.base.setReasoner(null);
        OWLConfig.setStrictConversion((boolean)true);
    }

    public boolean isIntegrative() {
        return this.integrative;
    }

    public void setIntegrative(boolean integrative) {
        this.integrative = integrative;
    }

    public void setStructural(boolean structural) {
        this.useStructuralFilter = structural;
    }
}

