/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.owlsmx;

import de.dfki.owlsmx.MatchingEngine;
import de.dfki.owlsmx.OWLSMXMatchmaker;
import de.dfki.owlsmx.data.MatchedService;
import de.dfki.owlsmx.data.MatchingResult;
import de.dfki.owlsmx.exceptions.MatchingException;
import de.dfki.owlsmx.io.ErrorLog;
import de.dfki.owlsmx.mxp.OWLSMXP;
import de.dfki.owlsmx.similaritymeasures.SimilarityMeasure;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLOntology;

public class SimilarityMatchingEngine
implements MatchingEngine {
    private Map advertisedServices = new HashMap();
    private Map serviceOntologies = new HashMap();
    private OWLSMXMatchmaker matcher = null;
    private LinkedList newKeys;
    public static final boolean debug = false;

    public String printServiceRegistry() {
        String result = "Local Services: \n";
        TreeSet keys = new TreeSet(this.advertisedServices.keySet());
        for (Integer me : keys) {
            result = String.valueOf(result) + " " + me + " - " + this.advertisedServices.get(me).toString();
            if (this.serviceOntologies.containsKey(me)) {
                result = String.valueOf(result) + " (local stored ontology)";
            }
            result = String.valueOf(result) + "\n";
        }
        return result;
    }

    private void init() {
        this.newKeys = new LinkedList();
        int i = 1;
        while (i < 6) {
            this.newKeys.addLast(new Integer(i));
            ++i;
        }
    }

    public SimilarityMatchingEngine() {
        this.matcher = new OWLSMXMatchmaker();
        this.init();
    }

    public SimilarityMatchingEngine(SimilarityMeasure sim) {
        this.matcher = new OWLSMXMatchmaker(sim);
        this.init();
    }

    public SimilarityMatchingEngine(short sim) throws MatchingException {
        this.matcher = new OWLSMXMatchmaker(sim);
        this.init();
    }

    public SimilarityMatchingEngine(SimilarityMeasure sim, boolean integrative) {
        this.matcher = new OWLSMXMatchmaker(sim, integrative);
        this.init();
    }

    public SimilarityMatchingEngine(SimilarityMeasure sim, boolean integrative, boolean structure) {
        this.matcher = new OWLSMXMatchmaker(sim, integrative, structure);
        this.init();
    }

    public SimilarityMatchingEngine(short sim, boolean integrative) throws MatchingException {
        this.matcher = new OWLSMXMatchmaker(sim, integrative);
        this.init();
    }

    private Integer getNewKey() {
        Integer integer = (Integer)this.newKeys.getFirst();
        this.newKeys.removeFirst();
        this.newKeys.addLast(new Integer((Integer)this.newKeys.getLast() + 1));
        return integer;
    }

    private void removeKey(Integer key) {
        this.newKeys.addFirst(key);
    }

    @Override
    public void addService(URI profileURI) {
        if (!this.advertisedServices.containsValue(profileURI)) {
            try {
                Integer ID = this.getNewKey();
                this.advertisedServices.put(ID, profileURI);
                this.matcher.addService(ID, profileURI);
            }
            catch (Exception e) {
                System.out.println("Service failed " + profileURI.toString());
                e.printStackTrace();
            }
        }
    }

    @Override
    public void addService(String profile, URI baseURI) {
        Integer ID = this.getNewKey();
        ByteArrayInputStream profileStream = new ByteArrayInputStream(profile.getBytes());
        OWLKnowledgeBase kb = OWLFactory.createKB();
        OWLOntology onto = kb.read((InputStream)profileStream, baseURI);
        this.advertisedServices.put(ID, baseURI);
        this.serviceOntologies.put(ID, onto);
        this.matcher.addService(ID, profile, baseURI);
    }

    @Override
    public void addService(InputStream profileStream, URI baseURI) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(profileStream));
            String profile = "";
            String line = bufferedReader.readLine();
            while (line != null) {
                profile = String.valueOf(profile) + line + "\n";
                line = bufferedReader.readLine();
            }
            bufferedReader.close();
            this.addService(profile, baseURI);
        }
        catch (IOException e) {
            System.out.println("Service failed " + baseURI.toString());
            e.printStackTrace();
        }
    }

    private void removeService(Integer ID) {
        if (this.advertisedServices.containsKey(ID)) {
            this.advertisedServices.remove(ID);
            this.serviceOntologies.remove(ID);
            this.removeKey(ID);
            this.matcher.removeService(ID);
        }
    }

    @Override
    public void removeService(URI uri) {
        for (Map.Entry me : this.advertisedServices.entrySet()) {
            if (!((URI)me.getValue()).equals(uri)) continue;
            this.removeService((Integer)me.getKey());
            return;
        }
    }

    private boolean shouldPruneService(MatchedService service, int minimumDegreeOfMatch, double treshold) {
        if (service.degreeOfMatch > minimumDegreeOfMatch) {
            ErrorLog.instanceOf().report("Had to skip (" + service.serviceURI + "/" + service.degreeOfMatch + "/" + service.similarity + ") Degree of service " + service.degreeOfMatch + ">" + minimumDegreeOfMatch);
            return true;
        }
        if (service.degreeOfMatch == 4 && service.similarity < treshold) {
            ErrorLog.instanceOf().report("Had to skip (" + service.serviceURI + "/" + service.degreeOfMatch + "/" + service.similarity + ") Sim of service " + service.similarity + "<" + treshold);
            return true;
        }
        return false;
    }

    public SortedSet matchRequest(URI profileURI, int minimumDegreeOfMatch, double treshold) throws MatchingException {
        double synTr = this.matcher.getSyntacticTreshold();
        double tresh = treshold;
        if (this.matcher.sim == null || this.matcher.sim.getSimilarityType() == -1) {
            ErrorLog.instanceOf().report("Reset treshold to 0.0 as syntactic matching is used");
            tresh = 0.0;
        }
        this.matcher.setSyntacticTreshold(tresh);
        TreeSet<MatchedService> result = new TreeSet<MatchedService>();
        SortedSet OWLSMXResult = this.matchRequest(profileURI);
        for (MatchedService entry : OWLSMXResult) {
            if (this.shouldPruneService(entry, minimumDegreeOfMatch, treshold)) continue;
            result.add(entry);
        }
        this.matcher.setSyntacticTreshold(synTr);
        return result;
    }

    public SortedSet matchRequest(URI profileURI, int minimumDegreeOfMatch, double treshold, int sortingType) throws MatchingException {
        if (sortingType != 1 && sortingType != 2 && sortingType != 0) {
            throw new MatchingException();
        }
        SortedSet matchingResult = this.matchRequest(profileURI, minimumDegreeOfMatch, treshold);
        if (sortingType == 0) {
            return matchingResult;
        }
        return SimilarityMatchingEngine.sortMatchingResult(matchingResult, sortingType);
    }

    @Override
    public SortedSet matchRequest(URI profileURI) throws MatchingException {
        try {
            OWLKnowledgeBase kb = OWLFactory.createKB();
            TreeSet<MatchedService> Matchingresult = new TreeSet<MatchedService>();
            SortedSet result = this.matcher.matchRequest(profileURI);
            for (MatchingResult entry : result) {
                Integer serviceID = new Integer(entry.serviceID);
                if (!this.advertisedServices.containsKey(serviceID)) continue;
                URI uri = new URI(((URI)this.advertisedServices.get(serviceID)).toString());
                OWLOntology onto = this.serviceOntologies.containsKey(serviceID) ? (OWLOntology)this.serviceOntologies.get(serviceID) : kb.read(uri);
                MatchedService matchedService = new MatchedService(entry, uri);
                matchedService.setOntology(onto);
                Matchingresult.add(matchedService);
            }
            return Matchingresult;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new TreeSet();
        }
    }

    public SortedSet matchRequest(InputStream profileStream, int minimumDegreeOfMatch, double treshold) throws MatchingException {
        double synTr = this.matcher.getSyntacticTreshold();
        double tresh = treshold;
        if (this.matcher.sim == null || this.matcher.sim.getSimilarityType() == -1) {
            ErrorLog.instanceOf().report("Reset treshold to 0.0 as syntactic matching is used");
            tresh = 0.0;
        }
        this.matcher.setSyntacticTreshold(tresh);
        TreeSet<MatchedService> result = new TreeSet<MatchedService>();
        SortedSet owlsmxResult = this.matchRequest(profileStream);
        for (MatchedService entry : owlsmxResult) {
            if (this.shouldPruneService(entry, minimumDegreeOfMatch, treshold)) continue;
            result.add(entry);
        }
        this.matcher.setSyntacticTreshold(synTr);
        return result;
    }

    public SortedSet matchRequest(InputStream profileStream, int minimumDegreeOfMatch, double treshold, int sortingType) throws MatchingException {
        if (sortingType != 1 && sortingType != 2 && sortingType != 0) {
            throw new MatchingException();
        }
        SortedSet matchingResult = this.matchRequest(profileStream, minimumDegreeOfMatch, treshold);
        if (sortingType == 0) {
            return matchingResult;
        }
        return SimilarityMatchingEngine.sortMatchingResult(matchingResult, sortingType);
    }

    public SortedSet matchRequest(String profile, int minimumDegreeOfMatch, double treshold) throws MatchingException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(profile.getBytes());
        return this.matchRequest(inputStream, minimumDegreeOfMatch, treshold);
    }

    public SortedSet matchRequest(String profile, int minimumDegreeOfMatch, double treshold, int sortingType) throws MatchingException {
        if (sortingType != 1 && sortingType != 2 && sortingType != 0) {
            throw new MatchingException();
        }
        SortedSet matchingResult = this.matchRequest(profile, minimumDegreeOfMatch, treshold);
        if (sortingType == 0) {
            return matchingResult;
        }
        return SimilarityMatchingEngine.sortMatchingResult(matchingResult, sortingType);
    }

    @Override
    public SortedSet matchRequest(InputStream profileStream) throws MatchingException {
        try {
            OWLKnowledgeBase kb = OWLFactory.createKB();
            TreeSet<MatchedService> matchingResult = new TreeSet<MatchedService>();
            SortedSet result = this.matcher.matchRequest(profileStream);
            for (MatchingResult entry : result) {
                Integer serviceID = new Integer(entry.serviceID);
                if (!this.advertisedServices.containsKey(serviceID)) continue;
                URI uri = new URI(((URI)this.advertisedServices.get(serviceID)).toString());
                OWLOntology onto = this.serviceOntologies.containsKey(serviceID) ? (OWLOntology)this.serviceOntologies.get(serviceID) : kb.read(uri);
                MatchedService matchedService = new MatchedService(entry, uri);
                matchedService.setOntology(onto);
                matchingResult.add(matchedService);
            }
            return matchingResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new TreeSet();
        }
    }

    @Override
    public SortedSet matchRequest(String profile) throws MatchingException {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(profile.getBytes());
        return this.matchRequest(inputStream);
    }

    public static SortedSet sortMatchingResult(SortedSet matchingResult, int sortingType) {
        TreeSet result;
        switch (sortingType) {
            case 1: {
                result = new TreeSet(new Comparator(){

                    public int compare(Object o1, Object o2) {
                        int domS2;
                        int domS1 = ((MatchedService)o1).getDegreeOfMatch();
                        if (domS1 < (domS2 = ((MatchedService)o2).getDegreeOfMatch())) {
                            return -1;
                        }
                        return 1;
                    }
                });
                break;
            }
            case 2: {
                result = new TreeSet(new Comparator(){

                    public int compare(Object o1, Object o2) {
                        double simS2;
                        double simS1 = ((MatchedService)o1).getSyntacticSimilarity();
                        if (simS1 > (simS2 = ((MatchedService)o2).getSyntacticSimilarity())) {
                            return -1;
                        }
                        return 1;
                    }
                });
                break;
            }
            case 4: {
                result = new TreeSet(new Comparator(){

                    public int compare(Object o1, Object o2) {
                        double simS1 = ((MatchedService)o1).structure;
                        double simS2 = ((MatchedService)o2).structure;
                        if (simS1 > simS2) {
                            return -1;
                        }
                        return 1;
                    }
                });
                break;
            }
            case 0: {
                result = new TreeSet(new Comparator(){

                    public int compare(Object o1, Object o2) {
                        int domS1 = ((MatchedService)o1).getDegreeOfMatch();
                        int domS2 = ((MatchedService)o2).getDegreeOfMatch();
                        double simS1 = ((MatchedService)o1).getSyntacticSimilarity();
                        double simS2 = ((MatchedService)o2).getSyntacticSimilarity();
                        if (domS1 < domS2) {
                            return -1;
                        }
                        if (domS1 > domS2) {
                            return 1;
                        }
                        if (simS1 > simS2) {
                            return -1;
                        }
                        return 1;
                    }
                });
                break;
            }
            case 3: {
                result = new TreeSet(new Comparator(){

                    public int compare(Object o1, Object o2) {
                        int domS1 = ((MatchedService)o1).getDegreeOfMatch();
                        int domS2 = ((MatchedService)o2).getDegreeOfMatch();
                        double simS1 = ((MatchedService)o1).getSyntacticSimilarity();
                        double simS2 = ((MatchedService)o2).getSyntacticSimilarity();
                        double structS1 = ((MatchedService)o1).structure;
                        double structS2 = ((MatchedService)o2).structure;
                        double gamma = 4.8828125E-4;
                        double bias = 10.280981;
                        double obj = 1202826.056833;
                        double[] alpha = new double[]{70589.83, 70589.83, 70589.83, 70589.83, 70589.83, 70589.83, 70589.83, 70589.83, 70589.83, 70589.83, 70589.83, 70589.83, 70589.83, 70589.83, 70589.83, 70589.83, 70589.83, 70589.83, 70589.83, 70589.83, 70589.83, 70589.83, 70589.83, 70589.83, 70589.83, 70589.83, 70589.83, 70589.83, 70589.83, 70589.83, 70589.83, 70589.83, 70589.83, 70589.83, 70589.83, 70589.83, 70589.83, 70589.83, 70589.83, 70589.83, 70589.83, 49081.99, 70589.83, 70589.83, 70589.83, 70589.83, 70589.83, 70589.83, 70589.83, 70589.83, 70589.83, 70589.83, 70589.83, 70589.83, 70589.83, -70589.83, -70589.83, -70589.83, -70589.83, -70589.83, -70589.83, -70589.83, -70589.83, -70589.83, -70589.83, -70589.83, -70589.83, -70589.83, -70589.83, -70589.83, -70589.83, -70589.83, -70589.83, -70589.83, -70589.83, -70589.83, -70589.83, -70589.83, -70589.83, -70589.83, -70589.83, -70589.83, -70589.83, -70589.83, -70589.83, -70589.83, -70589.83, -70589.83, -70589.83, -70589.83, -70589.83, -49081.99, -70589.83, -70589.83, -70589.83, -70589.83, -70589.83, -70589.83, -70589.83, -70589.83, -70589.83, -70589.83, -70589.83, -70589.83, -70589.83, -70589.83, -70589.83, -70589.83, -70589.83, -70589.83};
                        double sumAlpha = 109.375;
                        double[][] SVs = new double[][]{{0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.375}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.351692, 0.6727892}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.042704176, 0.375}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.08045834, 0.375}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.24190427, 0.41064656}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.5}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.18310674, 0.4490693}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0055581676, 0.5}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.018615784, 0.375}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.050418306, 0.375}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.23355705, 0.375}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.375}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.375}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.15541212, 0.40069708}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0051642447, 0.5}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.036256418, 0.5}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0894758, 0.083333336}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.044986285, 0.39390686}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.3307599, 0.625}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.12023567, 0.5}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.5}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.42384964, 0.5121412}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.03626313, 0.5}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.3326132, 0.7891265}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.27062505, 0.5540762}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.5}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.03351581, 0.1875}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.1626317, 0.29778922}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.05586604, 0.375}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.30612922, 0.22033153}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.32090944, 0.5616483}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.1264338, 0.44868475}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.07944927, 0.33333334}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.5}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.2037391, 0.6586658}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0771529, 0.44629312}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.5}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.2367783, 0.5119982}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.033170044, 0.25}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.12253029, 0.44868475}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.24111384, 0.6753658}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.08140335, 0.44629312}, {0.0, 0.0, 1.0, 0.0, 0.0, 0.73150635, 0.82003486}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.82313573, 0.875}, {0.0, 1.0, 0.0, 0.0, 0.0, 0.7511586, 0.7621412}, {1.0, 0.0, 0.0, 0.0, 0.0, 0.4965928, 0.875}, {0.0, 1.0, 0.0, 0.0, 0.0, 0.45604208, 0.75996304}, {0.0, 1.0, 0.0, 0.0, 0.0, 0.46752173, 0.9543329}, {0.0, 1.0, 0.0, 0.0, 0.0, 0.6832971, 0.7719613}, {0.0, 0.0, 1.0, 0.0, 0.0, 0.61079973, 0.57368475}, {1.0, 0.0, 0.0, 0.0, 0.0, 0.36719576, 0.33333334}, {0.0, 0.0, 0.0, 1.0, 0.0, 0.8324571, 0.75}, {1.0, 0.0, 0.0, 0.0, 0.0, 0.49999988, 0.5}, {0.0, 1.0, 0.0, 0.0, 0.0, 0.40099996, 0.6491394}, {0.0, 1.0, 0.0, 0.0, 0.0, 0.4239054, 0.7621412}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.53368425, 0.875}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.13791789, 0.2820181}, {0.0, 0.0, 0.0, 1.0, 0.0, 0.61183035, 0.5833333}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.32798517, 0.5856829}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.7223193, 0.6638199}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.3110125, 0.5856829}, {0.0, 1.0, 0.0, 0.0, 0.0, 0.43835318, 0.81032884}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.30442256, 0.375}, {0.0, 0.0, 1.0, 0.0, 0.0, 0.46396986, 0.685328}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.31422007, 0.570498}, {0.0, 1.0, 0.0, 0.0, 0.0, 0.41413596, 0.7393798}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.08095793, 0.625}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.19964816, 0.5899988}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.47913265, 0.7868424}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.14396143, 0.25}, {1.0, 0.0, 0.0, 0.0, 0.0, 0.3114224, 0.41666666}, {0.0, 1.0, 0.0, 0.0, 0.0, 0.5133438, 0.5858691}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.12630352, 0.42278922}, {0.0, 1.0, 0.0, 0.0, 0.0, 0.45062435, 0.8293773}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.10364323, 0.41368353}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.3829628, 0.91713166}, {0.0, 1.0, 0.0, 0.0, 0.0, 0.36461616, 0.5836478}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.44149497, 0.88970387}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.43558598, 0.79250467}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.3573497, 0.5167886}, {0.0, 0.0, 1.0, 0.0, 0.0, 0.6326241, 0.44868475}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.4579412, 0.7615244}, {0.0, 1.0, 0.0, 0.0, 0.0, 0.47998866, 0.75}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.42674989, 0.7868424}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.083333336}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.25}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.04779959, 0.375}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.11090545, 0.41368353}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.10430035, 0.2820181}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.33483592, 0.6371412}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.14212213, 0.25}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0877367, 0.625}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.10286707, 0.2820181}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.11017484, 0.44868475}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.07045831, 0.45833334}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.20833333}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.04573367, 0.375}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.12732598, 0.2820181}, {1.0, 0.0, 0.0, 0.0, 0.0, 0.2504192, 0.6666667}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.041129287, 0.375}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.375}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.11505081, 0.2820181}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.053102355, 0.375}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.057941884, 0.375}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.088388346, 0.375}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.057941884, 0.375}, {1.0, 0.0, 0.0, 0.0, 0.0, 0.29863998, 0.875}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.10370816, 0.41368353}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.044252712, 0.375}, {0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.375}};
                        double dvS1 = 0.0;
                        double[] xS1 = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, simS1, structS1};
                        if (domS1 == 0) {
                            xS1[0] = 1.0;
                        } else if (domS1 == 1) {
                            xS1[1] = 1.0;
                        } else if (domS1 == 2) {
                            xS1[2] = 1.0;
                        } else if (domS1 == 3) {
                            xS1[3] = 1.0;
                        } else {
                            xS1[4] = 1.0;
                        }
                        int i = 0;
                        while (i < SVs.length) {
                            double[] SV = SVs[i];
                            dvS1 += alpha[i] * SimilarityMatchingEngine.rbfKernel(SV, xS1, gamma);
                            ++i;
                        }
                        dvS1 += bias;
                        double dvS2 = 0.0;
                        double[] xS2 = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, simS2, structS2};
                        if (domS2 == 0) {
                            xS2[0] = 1.0;
                        } else if (domS2 == 1) {
                            xS2[1] = 1.0;
                        } else if (domS2 == 2) {
                            xS2[2] = 1.0;
                        } else if (domS2 == 3) {
                            xS2[3] = 1.0;
                        } else {
                            xS2[4] = 1.0;
                        }
                        int i2 = 0;
                        while (i2 < SVs.length) {
                            double[] SV = SVs[i2];
                            dvS2 += alpha[i2] * SimilarityMatchingEngine.rbfKernel(SV, xS2, gamma);
                            ++i2;
                        }
                        double magW = Math.sqrt(2.0 * (obj + 109.375));
                        double aggS1 = dvS1 / magW;
                        double aggS2 = (dvS2 += bias) / magW;
                        ((MatchedService)o1).svm = aggS1;
                        ((MatchedService)o2).svm = aggS2;
                        if (aggS1 < aggS2) {
                            return -1;
                        }
                        return 1;
                    }
                });
                break;
            }
            default: {
                return null;
            }
        }
        result.addAll(matchingResult);
        return result;
    }

    private static double rbfKernel(double[] xi, double[] xj, double gamma) {
        double squaredNorm = 0.0;
        int i = 0;
        while (i < xi.length) {
            squaredNorm += (xi[i] - xj[i]) * (xi[i] - xj[i]);
            ++i;
        }
        return Math.exp(-gamma * squaredNorm);
    }

    public static SortedSet useOWLSMXPFilter(SortedSet matchingResult, OWLOntology request) {
        TreeSet<MatchedService> newResult = new TreeSet<MatchedService>(matchingResult.comparator());
        for (MatchedService candidate : matchingResult) {
            try {
                if (!OWLSMXP.matchTypes(request, candidate.getOntology())) continue;
                newResult.add(candidate);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return newResult;
    }

    @Override
    public boolean save() {
        boolean result = this.save("");
        return result;
    }

    public boolean save(String targetpath) {
        File dirToCreate;
        block7: {
            dirToCreate = new File(String.valueOf(targetpath) + "state");
            if (!dirToCreate.exists()) {
                dirToCreate.mkdir();
            }
            if (dirToCreate.isDirectory()) break block7;
            return false;
        }
        try {
            File[] filesInDir = dirToCreate.listFiles();
            int i = 0;
            while (i < filesInDir.length) {
                String filename = filesInDir[i].getName();
                if (filename.startsWith("Service_") && filename.endsWith(".owls")) {
                    filesInDir[i].delete();
                }
                ++i;
            }
            FileWriter writer = new FileWriter(String.valueOf(targetpath) + "state\\Services.map", false);
            for (Map.Entry me : this.advertisedServices.entrySet()) {
                writer.write("(" + me.getKey() + ";" + me.getValue() + ")\n");
                if (!this.serviceOntologies.containsKey(me.getKey())) continue;
                FileWriter ontologyWriter = new FileWriter(String.valueOf(targetpath) + "state\\Service_" + me.getKey() + ".owls", false);
                ((OWLOntology)this.serviceOntologies.get(me.getKey())).write((Writer)ontologyWriter);
                ontologyWriter.close();
            }
            writer.close();
            return this.matcher.save();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean load() {
        boolean result = this.load("");
        return result;
    }

    private boolean load(String path) {
        try {
            String line;
            this.clear();
            BufferedReader reader = new BufferedReader(new FileReader(String.valueOf(path) + "state\\Services.map"));
            while ((line = reader.readLine()) != null) {
                line = line.trim();
                String[] tokens = (line = line.substring(line.indexOf("(") + 1, line.lastIndexOf(")"))).split(";");
                if (tokens.length < 2) continue;
                this.advertisedServices.put(new Integer(tokens[0]), new URI(tokens[1]));
            }
            reader.close();
            File[] filesInDir = new File(String.valueOf(path) + "state").listFiles();
            OWLKnowledgeBase kb = OWLFactory.createKB();
            int i = 0;
            while (i < filesInDir.length) {
                String filename = filesInDir[i].getName();
                if (filename.startsWith("Service_") && filename.endsWith(".owls")) {
                    Integer ID = new Integer(filename.substring(8, filename.indexOf(".")));
                    OWLOntology ontology = kb.read((InputStream)new FileInputStream(filesInDir[i]), (URI)this.advertisedServices.get(ID));
                    this.serviceOntologies.put(ID, ontology);
                }
                ++i;
            }
            return this.matcher.load();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void setSimilarityMeasure(SimilarityMeasure sim) {
        this.matcher.setSimilarityMeasure(sim);
    }

    public void setSimilarityMeasure(short sim) {
        this.matcher.setSimilarityMeasure(sim);
    }

    public void setIntegrative(boolean integrative) {
        this.matcher.setIntegrative(integrative);
    }

    public void setStructural(boolean structural) {
        this.matcher.setStructural(structural);
    }

    @Override
    public void clear() {
        this.advertisedServices.clear();
        this.serviceOntologies.clear();
        this.matcher.clear();
    }

    public void print() {
        System.out.println(this.getClass().toString());
        this.printServiceRegistry();
        this.matcher.print();
    }

    public void enableProfileHierarchies(boolean speedyButProblematic) {
        this.matcher.enableProfileHierarchies(speedyButProblematic);
    }

    public void disableProfileHierarchies() {
        this.matcher.disableProfileHierarchies();
    }

    public String toString() {
        return String.valueOf(this.printServiceRegistry()) + "\n" + this.matcher.toString();
    }

    public int getNumberOfRegisteredServices() {
        return this.advertisedServices.size();
    }

    public SortedSet irBasedMatchRequest(URI profileURI, double threshold) throws MatchingException {
        try {
            if (this.matcher.sim == null || this.matcher.sim.getSimilarityType() == -1) {
                throw new MatchingException("IR based approximate matching can only be applied if a similarity measure is given!");
            }
            double oldThreshold = this.matcher.getSyntacticTreshold();
            this.matcher.setSyntacticTreshold(threshold);
            TreeSet<MatchedService> result = new TreeSet<MatchedService>();
            SortedSet OWLSMXResult = this.matcher.syntacticFilter(profileURI);
            for (MatchedService entry : OWLSMXResult) {
                if (this.shouldPruneService(entry, 4, threshold)) continue;
                result.add(entry);
            }
            this.matcher.setSyntacticTreshold(oldThreshold);
            return result;
        }
        catch (Exception e) {
            throw new MatchingException("Could not match " + profileURI + "!", e);
        }
    }

    public SortedSet irBasedMatchRequest(InputStream profileStream, double threshold) throws MatchingException {
        try {
            if (this.matcher.sim == null || this.matcher.sim.getSimilarityType() == -1) {
                throw new MatchingException("IR based approximate matching can only be applied if a similarity measure is given!");
            }
            double oldThreshold = this.matcher.getSyntacticTreshold();
            this.matcher.setSyntacticTreshold(threshold);
            OWLKnowledgeBase kb = OWLFactory.createKB();
            TreeSet<MatchedService> matchingResult = new TreeSet<MatchedService>();
            SortedSet result = this.matcher.syntacticFilter(profileStream);
            for (MatchingResult entry : result) {
                Integer serviceID = new Integer(entry.serviceID);
                if (!this.advertisedServices.containsKey(serviceID)) continue;
                URI uri = new URI(((URI)this.advertisedServices.get(serviceID)).toString());
                OWLOntology onto = this.serviceOntologies.containsKey(serviceID) ? (OWLOntology)this.serviceOntologies.get(serviceID) : kb.read(uri);
                MatchedService matchedService = new MatchedService(entry, uri);
                matchedService.setOntology(onto);
                matchingResult.add(matchedService);
            }
            this.matcher.setSyntacticTreshold(oldThreshold);
            return matchingResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new TreeSet();
        }
    }

    public SortedSet structureBasedMatchRequest(InputStream profileStream, double threshold) throws MatchingException {
        try {
            double oldThreshold = this.matcher.getSyntacticTreshold();
            this.matcher.setSyntacticTreshold(threshold);
            OWLKnowledgeBase kb = OWLFactory.createKB();
            TreeSet<MatchedService> matchingResult = new TreeSet<MatchedService>();
            SortedSet result = this.matcher.structuralFilter(profileStream);
            for (MatchingResult entry : result) {
                Integer serviceID = new Integer(entry.serviceID);
                if (!this.advertisedServices.containsKey(serviceID)) continue;
                URI uri = new URI(((URI)this.advertisedServices.get(serviceID)).toString());
                OWLOntology onto = this.serviceOntologies.containsKey(serviceID) ? (OWLOntology)this.serviceOntologies.get(serviceID) : kb.read(uri);
                MatchedService matchedService = new MatchedService(entry, uri);
                matchedService.setOntology(onto);
                matchingResult.add(matchedService);
            }
            this.matcher.setSyntacticTreshold(oldThreshold);
            return matchingResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new TreeSet();
        }
    }
}

