/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.owlsmx;

import de.dfki.owlsmx.Indexer.SimpleIndex;
import de.dfki.owlsmx.Matchmaker;
import de.dfki.owlsmx.exceptions.MatchingException;
import de.dfki.owlsmx.similaritymeasures.ConstraintSimilarity;
import de.dfki.owlsmx.similaritymeasures.CosineSimilarity;
import de.dfki.owlsmx.similaritymeasures.ExtendedJaccardMeasure;
import de.dfki.owlsmx.similaritymeasures.JensenShannonMeasure;
import de.dfki.owlsmx.similaritymeasures.SimilarityMeasure;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.SortedSet;

public abstract class SimilarityMatchmaker
implements Matchmaker {
    public static final short EXACT = 0;
    public static final short PLUGIN = 1;
    public static final short SUBSUMES = 2;
    public static final short SUBSUMED_BY = 3;
    public static final short NEAREST_NEIGHBOUR = 4;
    public static final short FAIL = 5;
    protected double similarityTreshold = 0.001;
    protected SimilarityMeasure sim;
    protected boolean useStructuralFilter = false;

    @Override
    public abstract void addService(Integer var1, URI var2);

    @Override
    public abstract void addService(Integer var1, String var2, URI var3);

    @Override
    public abstract void addService(Integer var1, InputStream var2, URI var3);

    @Override
    public abstract void removeService(Integer var1);

    @Override
    public abstract SortedSet matchRequest(URI var1) throws URISyntaxException, MatchingException;

    @Override
    public abstract SortedSet matchRequest(String var1) throws MatchingException;

    @Override
    public abstract SortedSet matchRequest(InputStream var1) throws MatchingException;

    @Override
    public abstract boolean load();

    @Override
    public abstract boolean save();

    @Override
    public abstract void clear();

    public void setSyntacticTreshold(double treshold) {
        this.similarityTreshold = treshold;
    }

    public double getSyntacticTreshold() {
        return this.similarityTreshold;
    }

    protected SimilarityMeasure getSimilarityMeasure() {
        return this.sim;
    }

    public int getSimilarityMeasureType() {
        if (this.sim != null) {
            return this.sim.getSimilarityType();
        }
        return -1;
    }

    public void setSimilarityMeasure(short similarity) {
        this.sim = this.switchSimilarityMeasure(similarity);
    }

    public void setSimilarityMeasure(SimilarityMeasure sim) {
        this.sim = this.switchSimilarityMeasure(sim.getSimilarityType());
    }

    protected SimilarityMeasure switchSimilarityMeasure(short similarity) {
        if (similarity == -1) {
            SimpleIndex.instanceOf().clear();
            return null;
        }
        if (similarity == 3) {
            return new JensenShannonMeasure(this.sim);
        }
        if (similarity == 2) {
            return new CosineSimilarity(this.sim);
        }
        if (similarity == 1) {
            return new ExtendedJaccardMeasure(this.sim);
        }
        return new ConstraintSimilarity(this.sim);
    }

    protected boolean useSyntacticFilter() {
        return this.sim != null && this.sim.getSimilarityType() != -1;
    }

    protected boolean useStructuralFilter() {
        return this.useStructuralFilter;
    }
}

