/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.owlsmx.analysis;

import de.dfki.owlsmx.analysis.DataStorage;
import de.dfki.owlsmx.utils.MatchmakerUtils;

public class MemoryContainer
extends DataStorage {
    private static MemoryContainer _instance = null;
    private final double waiting = 1.5;
    private final boolean debug = true;

    public static MemoryContainer getInstance() {
        if (_instance == null) {
            _instance = new MemoryContainer();
        }
        return _instance;
    }

    private MemoryContainer() {
        this.baseValue = 0L;
    }

    private long getCurrentMemory() {
        System.err.print("Memory: " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()));
        MatchmakerUtils.wait(1.5);
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    public long getCurrentMatchmakerMemory() {
        return this.getCurrentMemory() - this.baseValue;
    }

    public void setGUIMemory() {
    }

    @Override
    public void addState(int serviceCount) {
        MatchmakerUtils.wait(3);
        this.storage.put(new Integer(serviceCount), new Long(this.getCurrentMatchmakerMemory() / 1024L));
    }
}

