/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.owlsmx.analysis;

import de.dfki.owlsmx.analysis.DataStorage;

public class PassedTimeContainer
extends DataStorage {
    private static PassedTimeContainer _instance = new PassedTimeContainer();
    private final boolean debug = true;

    public static PassedTimeContainer getInstance() {
        if (_instance == null) {
            _instance = new PassedTimeContainer();
        }
        return _instance;
    }

    protected PassedTimeContainer() {
        this.baseValue = this.getCurrentTime();
    }

    private long getCurrentTime() {
        return System.currentTimeMillis();
    }

    public long getCurrentProcessingTime() {
        return this.getCurrentTime() - this.baseValue;
    }

    public void setStartTime() {
        this.baseValue = this.getCurrentTime();
    }

    @Override
    public void addState(int serviceCount) {
        System.err.print("Time: " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()));
        if (serviceCount == 0) {
            this.storage.put(new Integer(0), new Long(0L));
        }
        this.storage.put(new Integer(serviceCount), new Long(this.getCurrentProcessingTime() / (long)serviceCount));
    }
}

