/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.owlsmx.data;

import de.dfki.owlsmx.data.ExtendedServiceInformation;
import de.dfki.owlsmx.data.ServiceInformation;
import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class ConceptServiceRegistry
implements Serializable {
    private static final long serialVersionUID = -2157801882458901868L;
    Map outputs = new HashMap();
    Map inputs = new HashMap();
    private static ConceptServiceRegistry registry = new ConceptServiceRegistry();

    private ConceptServiceRegistry() {
    }

    public static ConceptServiceRegistry instanceOf() {
        return registry;
    }

    public void updateOutputMap(boolean isInput, String concept, int ServiceID, int conceptID, int noConcepts) {
        if (this.outputs.containsKey(concept)) {
            ((HashSet)this.outputs.get(concept)).add(new ServiceInformation(ServiceID, isInput, conceptID, noConcepts));
        } else {
            HashSet<ServiceInformation> concepts = new HashSet<ServiceInformation>();
            concepts.add(new ServiceInformation(ServiceID, isInput, conceptID, noConcepts));
            this.outputs.put(concept, concepts);
        }
    }

    public void updateInputMap(boolean isInput, String concept, int ServiceID, int conceptID, int noConcepts) {
        if (this.inputs.containsKey(concept)) {
            ((HashSet)this.inputs.get(concept)).add(new ServiceInformation(ServiceID, isInput, conceptID, noConcepts));
        } else {
            HashSet<ServiceInformation> concepts = new HashSet<ServiceInformation>();
            concepts.add(new ServiceInformation(ServiceID, isInput, conceptID, noConcepts));
            this.inputs.put(concept, concepts);
        }
    }

    public boolean addService(String concept, boolean isInput, int ServiceID, int conceptNumber, int totalNumberOfConcepts) {
        if (isInput) {
            this.updateInputMap(isInput, concept, ServiceID, conceptNumber, totalNumberOfConcepts);
        } else {
            this.updateOutputMap(isInput, concept, ServiceID, conceptNumber, totalNumberOfConcepts);
        }
        return true;
    }

    public void addConcepts(boolean isInput, int ServiceID, Set concepts) {
        Iterator iter = concepts.iterator();
        String current_concept = "";
        int conceptNumber = 0;
        while (iter.hasNext()) {
            current_concept = (String)iter.next();
            this.addService(current_concept, isInput, ServiceID, conceptNumber, concepts.size());
            ++conceptNumber;
        }
    }

    public void addConcepts(boolean isInput, int ServiceID, Vector conceptURIs) {
        String current_concept = "";
        int conceptNumber = 0;
        while (conceptNumber < conceptURIs.size()) {
            current_concept = ((URI)conceptURIs.get(conceptNumber)).toString();
            this.addService(current_concept, isInput, ServiceID, conceptNumber, conceptURIs.size());
            ++conceptNumber;
        }
    }

    private Set getOutputs(String concept) {
        if (this.outputs.containsKey(concept)) {
            return (HashSet)this.outputs.get(concept);
        }
        return new HashSet();
    }

    private Set getInputs(String concept) {
        if (this.inputs.containsKey(concept)) {
            return (HashSet)this.inputs.get(concept);
        }
        return new HashSet();
    }

    public Set getServices(boolean isInput, String concept) {
        if (isInput) {
            if (this.inputs.containsKey(concept)) {
                return (HashSet)this.inputs.get(concept);
            }
        } else if (this.outputs.containsKey(concept)) {
            return (HashSet)this.outputs.get(concept);
        }
        return new HashSet();
    }

    public Set getServices(boolean isInput, Set concepts) {
        HashSet result = new HashSet();
        Iterator iter = concepts.iterator();
        while (iter.hasNext()) {
            if (isInput) {
                result.addAll(this.getInputs((String)iter.next()));
                continue;
            }
            result.addAll(this.getOutputs((String)iter.next()));
        }
        return result;
    }

    public Set getConcepts() {
        HashSet result = new HashSet();
        result.addAll(this.outputs.keySet());
        result.addAll(this.inputs.keySet());
        return result;
    }

    public String toString() {
        Iterator iter2;
        String result = "ConceptServiceRegistry \n";
        HashSet concepts = new HashSet();
        result = String.valueOf(result) + "Outputs (" + this.outputs.size() + " Concepts):\n";
        for (Map.Entry me : this.outputs.entrySet()) {
            concepts = (HashSet)me.getValue();
            result = String.valueOf(result) + "- " + (String)me.getKey() + "\n";
            iter2 = concepts.iterator();
            while (iter2.hasNext()) {
                result = String.valueOf(result) + "    " + ((ServiceInformation)iter2.next()).toString() + " (" + concepts.size() + " Items)" + "\n";
            }
        }
        result = String.valueOf(result) + "\n";
        result = String.valueOf(result) + "Inputs (" + this.inputs.size() + " Concepts):\n";
        for (Map.Entry me : this.inputs.entrySet()) {
            concepts = (HashSet)me.getValue();
            result = String.valueOf(result) + "- " + (String)me.getKey() + " (" + concepts.size() + " Items)" + "\n";
            iter2 = concepts.iterator();
            while (iter2.hasNext()) {
                result = String.valueOf(result) + "    " + ((ServiceInformation)iter2.next()).toString() + "\n";
            }
        }
        return result;
    }

    private void removeServiceFromMap(int ServiceID, Map map) {
        HashSet concepts = new HashSet();
        Vector<ServiceInformation> toRemove = new Vector<ServiceInformation>();
        for (Map.Entry me : map.entrySet()) {
            concepts = (HashSet)me.getValue();
            for (ServiceInformation service : concepts) {
                if (service.serviceID != ServiceID) continue;
                toRemove.add(service);
            }
            int i = 0;
            while (i < toRemove.size()) {
                ((HashSet)me.getValue()).remove((ServiceInformation)toRemove.get(i));
                ++i;
            }
        }
    }

    public void removeService(int ServiceID) {
        this.removeServiceFromMap(ServiceID, this.inputs);
        this.removeServiceFromMap(ServiceID, this.outputs);
    }

    public Map getAllServicesWithoutInput() {
        Map in = this.getAllServices(true);
        Map out = this.getAllServices(false);
        for (Map.Entry me : in.entrySet()) {
            Integer ID = (Integer)me.getKey();
            if (!out.containsKey(ID)) continue;
            out.remove(ID);
        }
        return out;
    }

    public Map getAllServices(boolean isInput) {
        HashMap<Integer, ExtendedServiceInformation> result = new HashMap<Integer, ExtendedServiceInformation>();
        Map current = isInput ? this.inputs : this.outputs;
        for (Map.Entry me : current.entrySet()) {
            HashSet set = (HashSet)me.getValue();
            for (ServiceInformation info : set) {
                Integer ID = new Integer(info.serviceID);
                if (result.containsKey(ID)) continue;
                result.put(ID, new ExtendedServiceInformation(info, 0, 1.0));
            }
        }
        return result;
    }

    public boolean containsConcept(String uri) {
        return this.inputs.containsKey(uri) || this.outputs.containsKey(uri);
    }

    public void clear() {
        this.outputs = new HashMap();
        this.inputs = new HashMap();
    }
}

