/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.owlsmx.data;

import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.Restriction;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import de.dfki.owlsmx.io.ErrorLog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.Set;
import org.mindswap.owl.OWLClass;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLOntology;

public class LocalOntologyContainer {
    private static OWLKnowledgeBase base = OWLFactory.createKB();
    private static OWLOntology localOntology = base.createOntology();
    static final String localOntologyName = "localOntology.owl";
    private static final boolean debug = false;
    private boolean ontologyHasChanged = false;

    public LocalOntologyContainer() {
        localOntology.setReasoner("Pellet");
    }

    private void debugDisplay(String string) {
    }

    public boolean save() {
        try {
            localOntology.write((OutputStream)new FileOutputStream(new File(localOntologyName)));
            this.debugDisplay("Stored localOntology.");
            return true;
        }
        catch (FileNotFoundException e) {
            ErrorLog.instanceOf().report(String.valueOf(this.getClass().toString()) + "|save(): Could not save local ontology " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public static boolean load() {
        try {
            File file = new File(localOntologyName);
            if (file.isFile()) {
                localOntology = base.read(file.toURI());
            }
            return true;
        }
        catch (FileNotFoundException e) {
            ErrorLog.instanceOf().report("LocalOntologyContainer|load(): Couldn load local ontology " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private boolean contains(Restriction r) {
        if (r.getURI() == null) {
            return ((OntModel)localOntology.getImplementation()).containsResource((RDFNode)r);
        }
        return ((OntModel)localOntology.getImplementation()).getRestriction(r.getURI()) != null;
    }

    private OntProperty createProperty(OntProperty prop) {
        return this.createProperty(prop.getURI());
    }

    private OntProperty createProperty(String uri) {
        OntModel local = (OntModel)localOntology.getImplementation();
        try {
            if (localOntology.getProperty(new URI(uri)) != null) {
                return local.getOntProperty(uri);
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return local.createOntProperty(uri);
    }

    private OntProperty createOnProperty(Restriction r) {
        try {
            return r.getOnProperty();
        }
        catch (Exception e) {
            ErrorLog.instanceOf().report(String.valueOf(this.getClass().toString()) + "|createOnProperty: Couldn't create onProperty for restriction " + r.toString());
            ErrorLog.instanceOf().report("                    returned null instead");
            return null;
        }
    }

    private Resource addResourceIfNecessary(Resource r, OWLKnowledgeBase kbase) {
        try {
            URI uri = new URI(r.toString());
            if (localOntology.getClass(uri) != null) {
                return (Resource)localOntology.getClass(uri).getImplementation();
            }
            if (kbase.getClass(uri) != null) {
                return (Resource)this.createClass(kbase, kbase.getClass(uri)).getImplementation();
            }
            return r;
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                return (Resource)this.createClass(kbase, localOntology.createClass(new URI(r.getURI()))).getImplementation();
            }
            catch (URISyntaxException e2) {
                e2.printStackTrace();
                return r;
            }
        }
    }

    private Resource createRestriction(OWLKnowledgeBase base, Restriction r) {
        if (r == null) {
            return null;
        }
        OntModel local = (OntModel)localOntology.getImplementation();
        if (this.contains(r)) {
            return r;
        }
        Resource restrict = null;
        OntProperty ont = null;
        if (r.isAllDifferent()) {
            this.debugDisplay("  asAllDifferent              ");
            return local.createAllDifferent(r.asAllDifferent().getDistinctMembers());
        }
        if (r.isAllValuesFromRestriction()) {
            this.debugDisplay("  isAllValuesFromRestriction  ");
            ont = this.createOnProperty(r);
            if (ont == null) {
                return null;
            }
            return local.createAllValuesFromRestriction(r.getURI(), (Property)this.createProperty(ont), this.addResourceIfNecessary(r.asAllValuesFromRestriction().getAllValuesFrom(), base));
        }
        if (r.isDataRange()) {
            this.debugDisplay("  asDataRange  \t\t\t\t");
        } else {
            if (r.isHasValueRestriction()) {
                this.debugDisplay("  asHasValueRestriction\t\t");
                ont = this.createOnProperty(r);
                if (ont == null) {
                    return null;
                }
                return local.createHasValueRestriction(r.getURI(), (Property)this.createProperty(ont), r.asHasValueRestriction().getHasValue());
            }
            if (r.isMaxCardinalityRestriction()) {
                this.debugDisplay("  asMaxCardinalityRestriction\t");
                ont = this.createOnProperty(r);
                if (ont == null) {
                    return null;
                }
                return local.createMaxCardinalityRestriction(r.getURI(), (Property)this.createProperty(ont), r.asMaxCardinalityRestriction().getMaxCardinality());
            }
            if (r.isMinCardinalityRestriction()) {
                this.debugDisplay("  asMinCardinalityRestriction\t");
                ont = this.createOnProperty(r);
                if (ont == null) {
                    return null;
                }
                return local.createMinCardinalityRestriction(r.getURI(), (Property)this.createProperty(ont), r.asMinCardinalityRestriction().getMinCardinality());
            }
            if (r.isCardinalityRestriction()) {
                this.debugDisplay("  asCardinalityRestriction    ");
                ont = this.createOnProperty(r);
                if (ont == null) {
                    return null;
                }
                return local.createCardinalityRestriction(r.getURI(), (Property)this.createProperty(ont), r.asCardinalityRestriction().getCardinality());
            }
            if (r.isSomeValuesFromRestriction()) {
                this.debugDisplay("  asSomeValuesFromRestriction\t");
                ont = this.createOnProperty(r);
                if (ont == null) {
                    return null;
                }
                return local.createSomeValuesFromRestriction(r.getURI(), (Property)this.createProperty(ont), this.addResourceIfNecessary(r.asSomeValuesFromRestriction().getSomeValuesFrom(), base));
            }
            if (r.isDatatypeProperty()) {
                this.debugDisplay("  asDatatypeProperty\t\t\t");
                return local.createDatatypeProperty(r.getURI());
            }
            if (r.isObjectProperty()) {
                this.debugDisplay("  asObjectProperty\t\t\t");
                return local.createObjectProperty(r.getURI());
            }
            if (r.isAnnotationProperty()) {
                this.debugDisplay("  isAnnotationProperty        ");
                local.createAnnotationProperty(r.getURI());
            } else {
                this.debugDisplay("  unknown\t\t\t\t\t\t");
            }
        }
        return restrict;
    }

    private void addSuperClass(OWLClass subclass, Resource superClass) {
        OntClass subClass = (OntClass)((Resource)subclass.getImplementation()).as(OntClass.class);
        if (superClass.getURI() != null) {
            subClass.addSuperClass(superClass);
            this.debugDisplay("Superclass of " + subclass.toPrettyString() + " is " + superClass.getURI());
        }
    }

    private OWLClass addClass(OWLClass clazz) {
        return localOntology.createClass(clazz.getURI());
    }

    private boolean contains(OWLClass clazz) {
        if (clazz == null) {
            return true;
        }
        OWLClass clazz1 = localOntology.getClass(clazz.getURI());
        if (clazz1 != null) {
            return clazz1.isClass();
        }
        return false;
    }

    private OWLClass createClass(OWLKnowledgeBase kbase, OWLClass clazz) {
        if (clazz != null && clazz.getURI() != null && this.contains(clazz)) {
            return localOntology.getClass(clazz.getURI());
        }
        OntModel local = (OntModel)localOntology.getImplementation();
        this.ontologyHasChanged = true;
        OWLClass currentClazz = this.addClass(clazz);
        Set set = kbase.getSuperClasses(clazz, true);
        set.remove(clazz);
        this.debugDisplay("Superclasses of " + clazz.getURI().toString());
        this.debugDisplay(set.toString());
        Resource res = null;
        for (OWLClass c_owl : set) {
            OntClass c_ont = (OntClass)((Resource)c_owl.getImplementation()).as(OntClass.class);
            if (c_ont.toString().indexOf("http://www.w3.org/2000/01/rdf-schema") >= 0) {
                this.debugDisplay(" - Skipped - " + c_ont);
            } else if (c_ont.isRestriction()) {
                res = this.createRestriction(base, c_ont.asRestriction());
            } else if (c_ont.isIndividual()) {
                this.debugDisplay("  asIndividual\t  \t\t\t");
                res = local.createIndividual((Resource)c_ont);
            } else if (c_ont.isIntersectionClass()) {
                this.debugDisplay("  asIntersectionClass " + c_ont.asIntersectionClass().toString());
                res = local.createIntersectionClass(c_ont.getURI(), c_ont.asIntersectionClass().getOperands());
            } else if (c_ont.isComplementClass() && !c_ont.toString().contains("http://www.w3.org/2002/07/owl")) {
                this.debugDisplay("  asComplementClass   " + c_ont.asComplementClass().toString());
                res = local.createComplementClass(c_ont.getURI(), (Resource)c_ont.asComplementClass().getOperands());
            } else if (c_ont.isEnumeratedClass() && !c_ont.toString().contains("http://www.w3.org/2002/07/owl")) {
                this.debugDisplay("  asEnumeratedClass   " + c_ont.asEnumeratedClass().toString());
                res = local.createEnumeratedClass(c_ont.getURI(), c_ont.asEnumeratedClass().getOneOf());
            } else if (c_ont.isUnionClass() && !c_ont.toString().contains("http://www.w3.org/2002/07/owl")) {
                this.debugDisplay("  asUnionClass        " + c_ont.asUnionClass().toString());
                res = local.createUnionClass(c_ont.getURI(), c_ont.asUnionClass().getOperands());
            } else {
                this.debugDisplay("  OntClass            " + c_ont.toString());
                res = (Resource)this.createClass(kbase, c_owl).getImplementation();
            }
            if (res != null) {
                this.addSuperClass(currentClazz, res);
                continue;
            }
            this.debugDisplay("Problems with " + currentClazz.toPrettyString() + " couldn add superclass " + c_owl.toPrettyString());
        }
        return currentClazz;
    }

    boolean processClass(OWLKnowledgeBase kbase, URI clazzURI) {
        OWLClass clazz = kbase.getClass(clazzURI);
        if (clazz == null) {
            ErrorLog.instanceOf().report("Couldn't find the clazz " + clazzURI + " in base " + kbase);
            return false;
        }
        this.debugDisplay("Processing            " + clazz.getURI().toString());
        this.createClass(kbase, clazz);
        return this.ontologyHasChanged;
    }

    public boolean processClasses(OWLKnowledgeBase kbase, Set classURIs) {
        kbase.setReasoner("RDFS");
        boolean hasChanged = false;
        this.ontologyHasChanged = false;
        Iterator iter = classURIs.iterator();
        while (iter.hasNext()) {
            if (!this.processClass(kbase, (URI)iter.next())) continue;
            hasChanged = true;
        }
        kbase.setReasoner(null);
        this.ontologyHasChanged = hasChanged;
        return hasChanged;
    }

    public boolean hasOntologyChanged() {
        return this.ontologyHasChanged;
    }

    public OWLOntology getOntology() {
        return localOntology;
    }

    public OWLClass getClass(String uri) throws URISyntaxException {
        return this.getClass(new URI(uri));
    }

    public OWLClass getClass(URI uri) {
        return localOntology.getClass(uri);
    }

    public OntClass getOntClass(String uri) {
        return ((OntModel)localOntology.getImplementation()).getOntClass(uri);
    }

    public OntClass getOntClass(URI uri) {
        return this.getOntClass(uri.toString());
    }
}

