/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.owlsmx.data;

import de.dfki.owlsmx.data.DOM;
import de.dfki.owlsmx.data.ExtendedServiceInformation;
import de.dfki.owlsmx.exceptions.MatchingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;

public class OutputServiceContainer {
    Map services = new HashMap();

    void addService(ExtendedServiceInformation exInfo) {
        Integer ID = new Integer(exInfo.serviceID);
        if (this.services.containsKey(ID)) {
            ((DOM)this.services.get(ID)).mergeService(exInfo);
        } else {
            this.services.put(ID, new DOM(exInfo));
        }
    }

    public void addServices(SortedSet set) {
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            this.addService((ExtendedServiceInformation)iter.next());
        }
    }

    boolean existService(Integer ServiceID) {
        return this.services.containsKey(ServiceID);
    }

    DOM getService(Integer ServiceID) {
        if (this.existService(ServiceID)) {
            return (DOM)this.services.get(ServiceID);
        }
        return null;
    }

    public void merge(OutputServiceContainer output) throws MatchingException {
        Iterator iter = this.services.entrySet().iterator();
        Vector<Integer> remove = new Vector<Integer>();
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            Integer ID = (Integer)me.getKey();
            if (!output.existService(ID)) {
                remove.add(ID);
                continue;
            }
            ((DOM)me.getValue()).mergeDOM(output.getService(ID));
        }
        int i = 0;
        while (i < remove.size()) {
            this.services.remove((Integer)remove.get(i));
            ++i;
        }
    }

    SortedSet getServicesSet() {
        return new TreeSet(this.services.values());
    }

    public Map getServiceMap() {
        return this.services;
    }
}

