/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.owlsmx.data;

import de.dfki.owlsmx.data.ServiceEntry;
import de.dfki.owlsmx.utils.MatchmakerUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public class ServiceConcept {
    private Map outputservices = new HashMap();
    private Map inputservices = new HashMap();

    public void add(boolean input, ServiceEntry service) {
        if (input) {
            this.addInput(service);
        } else {
            this.addOutput(service);
        }
    }

    public void forceAdd(boolean input, ServiceEntry service) {
        Integer id = new Integer(service.ID);
        if (input) {
            this.inputservices.put(id, service);
        } else {
            this.outputservices.put(id, service);
        }
    }

    public void addInput(ServiceEntry service) {
        Integer id = new Integer(service.ID);
        if (this.inputservices.containsKey(id) && service.smallerThan(this.inputservices.get(id))) {
            return;
        }
        this.inputservices.put(id, service);
    }

    public void addOutput(ServiceEntry service) {
        Integer id = new Integer(service.ID);
        if (this.outputservices.containsKey(id) && service.smallerThan(this.outputservices.get(id))) {
            return;
        }
        this.outputservices.put(id, service);
    }

    public TreeSet getOutputs() {
        return new TreeSet(MatchmakerUtils.mapToSortedSet(this.outputservices));
    }

    public TreeSet getInputs() {
        return new TreeSet(MatchmakerUtils.mapToSortedSet(this.inputservices));
    }

    public void removeService(int id) {
        Integer Id = new Integer(id);
        this.outputservices.remove(Id);
        this.inputservices.remove(Id);
    }

    public void resetSimilarity() {
        ServiceEntry entry;
        for (Map.Entry me : this.outputservices.entrySet()) {
            entry = (ServiceEntry)me.getValue();
            entry.resetSimilarity();
        }
        for (Map.Entry me : this.inputservices.entrySet()) {
            entry = (ServiceEntry)me.getValue();
            entry.resetSimilarity();
        }
    }
}

