/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.owlsmx.data;

import de.dfki.owlsmx.utils.MatchmakerUtils;
import java.net.URI;
import java.net.URISyntaxException;

public class ServiceEntry
implements Comparable {
    boolean debug = false;
    public int ID;
    public int degreeOfMatch;
    public double similarity;
    public URI uri;
    public String dominantConcept;

    public ServiceEntry() {
    }

    public ServiceEntry(int id, int degree, double sim, String concept) {
        this.degreeOfMatch = degree;
        this.ID = id;
        this.similarity = sim;
        this.dominantConcept = concept;
    }

    public ServiceEntry(int id, int degree, double sim) {
        this.degreeOfMatch = degree;
        this.ID = id;
        this.similarity = sim;
    }

    public ServiceEntry(URI uri, int degree, double sim) {
        this.uri = uri;
        this.degreeOfMatch = degree;
        this.similarity = sim;
    }

    public ServiceEntry(String uri, int degree, double sim) throws URISyntaxException {
        this.uri = new URI(uri);
        this.degreeOfMatch = degree;
        this.similarity = sim;
    }

    public ServiceEntry(int id, URI uris, int degree, double sim) {
        this.degreeOfMatch = degree;
        this.ID = id;
        this.similarity = sim;
        this.uri = uris;
    }

    public void resetSimilarity() {
        this.similarity = 0.0;
    }

    public int compareTo(Object obj2) {
        int BEFORE = -1;
        boolean EQUAL = false;
        boolean AFTER = true;
        if (this == obj2) {
            return 0;
        }
        ServiceEntry service2 = (ServiceEntry)obj2;
        if (this.debug) {
            System.out.println("Comparing " + this.ID + "(" + this.degreeOfMatch + "," + this.similarity + ") with " + service2.ID + "(" + service2.degreeOfMatch + "," + service2.similarity + ")");
        }
        if (this.degreeOfMatch == service2.degreeOfMatch && this.similarity == service2.similarity) {
            if (this.ID == service2.ID) {
                return 0;
            }
            return -1;
        }
        if (this.degreeOfMatch < service2.degreeOfMatch || this.degreeOfMatch == service2.degreeOfMatch && this.similarity > service2.similarity || this.degreeOfMatch == service2.degreeOfMatch && this.similarity == service2.similarity && this.ID < service2.ID) {
            return -1;
        }
        if (this.debug) {
            System.out.println("AFTER");
        }
        return 1;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ServiceEntry)) {
            return false;
        }
        ServiceEntry service2 = (ServiceEntry)obj;
        return this.degreeOfMatch == service2.degreeOfMatch && this.similarity == service2.similarity && this.ID == service2.ID;
    }

    public boolean smallerThan(Object obj) {
        if (this == obj) {
            return false;
        }
        if (!(obj instanceof ServiceEntry)) {
            return false;
        }
        ServiceEntry service2 = (ServiceEntry)obj;
        return this.degreeOfMatch <= service2.degreeOfMatch || this.similarity <= service2.similarity && this.degreeOfMatch == service2.degreeOfMatch;
    }

    public String toString() {
        if (this.uri == null) {
            return "(" + this.ID + "/" + MatchmakerUtils.degreeOfMatchIntToString(this.degreeOfMatch) + "/" + this.similarity + ")";
        }
        return "(" + this.uri + "/" + this.ID + "/" + MatchmakerUtils.degreeOfMatchIntToString(this.degreeOfMatch) + "/" + this.similarity + ")";
    }
}

