/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.owlsmx.gui;

import de.dfki.owlsmx.gui.data.ServiceItem;
import de.dfki.owlsmx.mxp.OWLSMXPServiceInformation;
import de.dfki.wsdlanalyzer.parser.SimpleTypeLookupTable;
import de.dfki.wsdlanalyzer.types.Attribute;
import de.dfki.wsdlanalyzer.types.ComplexType;
import de.dfki.wsdlanalyzer.types.Element;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Iterator;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owls.process.Input;
import org.mindswap.owls.process.Output;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class DisplayGrounding
extends JPanel {
    private static final long serialVersionUID = -183893492834L;
    private JScrollPane scrollPane;
    private DefaultTreeModel groundingTreeModel;
    private JTree groundingTree;

    public DisplayGrounding(ServiceItem service) {
        this.initComponents();
        this.buildTree(service);
        this.groundingTree.setModel(this.groundingTreeModel);
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.groundingTree = new JTree();
        this.setLayout((LayoutManager)new AbsoluteLayout());
        this.scrollPane.setViewportView(this.groundingTree);
        this.add((Component)this.scrollPane, new AbsoluteConstraints(10, 10, 310, 350));
    }

    private void buildTree(ServiceItem service) {
        DefaultMutableTreeNode subNode;
        DefaultMutableTreeNode node;
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(service.getName());
        this.groundingTreeModel = new DefaultTreeModel(root);
        OWLSMXPServiceInformation serviceInfo = null;
        OWLOntology serviceOnto = null;
        try {
            serviceOnto = OWLFactory.createKB().read(service.getURI());
            serviceInfo = new OWLSMXPServiceInformation(serviceOnto, new SimpleTypeLookupTable());
        }
        catch (Exception e) {
            return;
        }
        DefaultMutableTreeNode inputs = new DefaultMutableTreeNode("inputs");
        root.add(inputs);
        for (Input input : serviceOnto.getService().getProcess().getInputs()) {
            String inputType = input.getParamType().getURI().getFragment();
            String inputName = input.getLocalName();
            node = new DefaultMutableTreeNode(String.valueOf(inputName) + ":" + inputType);
            inputs.add(node);
            try {
                if (serviceInfo.hasSimpleType(inputName)) {
                    String simpleType = serviceInfo.getSimpleType(inputName);
                    subNode = new DefaultMutableTreeNode(simpleType);
                    node.add(subNode);
                    continue;
                }
                this.addComplexTypeNode(node, serviceInfo.getComplexType(inputName), serviceInfo);
            }
            catch (Exception simpleType) {
                // empty catch block
            }
        }
        DefaultMutableTreeNode outputs = new DefaultMutableTreeNode("outputs");
        root.add(outputs);
        for (Output output : serviceOnto.getService().getProcess().getOutputs()) {
            String outputType = output.getParamType().getURI().getFragment();
            String outputName = output.getLocalName();
            node = new DefaultMutableTreeNode(String.valueOf(outputName) + ":" + outputType);
            outputs.add(node);
            try {
                if (serviceInfo.hasSimpleType(outputName)) {
                    String simpleType = serviceInfo.getSimpleType(outputName);
                    subNode = new DefaultMutableTreeNode(simpleType);
                    node.add(subNode);
                    continue;
                }
                this.addComplexTypeNode(node, serviceInfo.getComplexType(outputName), serviceInfo);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void addComplexTypeNode(DefaultMutableTreeNode node, ComplexType complexType, OWLSMXPServiceInformation serviceInfo) {
        DefaultMutableTreeNode groupingNode = null;
        if (complexType.getGrouping() == 1) {
            groupingNode = new DefaultMutableTreeNode("sequence");
        }
        if (complexType.getGrouping() == 2) {
            groupingNode = new DefaultMutableTreeNode("all");
        }
        if (complexType.getGrouping() == 3) {
            groupingNode = new DefaultMutableTreeNode("choice");
        }
        node.add(groupingNode);
        for (Element element : complexType.getElementList()) {
            DefaultMutableTreeNode elementNode = new DefaultMutableTreeNode(String.valueOf(element.getName()) + ":" + element.getType());
            groupingNode.add(elementNode);
            if (element.isSimple()) continue;
            ComplexType subType = serviceInfo.getWsdlFile().getTypeList().getType(element.getType());
            this.addComplexTypeNode(elementNode, subType, serviceInfo);
        }
        Iterator<Attribute> iter = complexType.attributeIterator();
        while (iter.hasNext()) {
            Attribute attribute = iter.next();
            DefaultMutableTreeNode attributeNode = new DefaultMutableTreeNode(String.valueOf(attribute.getName()) + ":" + attribute.getType());
            node.add(attributeNode);
        }
    }
}

