/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.owlsmx.gui;

import de.dfki.owlsmx.gui.data.ServiceItem;
import de.dfki.owlsmx.gui.util.Utils;
import java.awt.Component;
import java.awt.LayoutManager;
import java.net.URI;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class DisplayService
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JList inputs;
    private JLabel inputsLabel;
    private JScrollPane inputsScrollPane;
    private JTextField name;
    private JLabel nameLabel;
    private JList outputs;
    private JLabel outputsLabel;
    private JScrollPane outputsScrollPane;
    private JTextField uri;
    private JLabel uriLabel;
    private DefaultListModel inputsDataModel = new DefaultListModel();
    private DefaultListModel outputsDataModel = new DefaultListModel();

    public DisplayService(ServiceItem service) {
        this.initComponents();
        this.name.setText(service.getName());
        this.uri.setText(service.getURI().toString());
        Iterator iter = service.getInputs().iterator();
        this.inputs.removeAll();
        while (iter.hasNext()) {
            URI tmpURI = (URI)iter.next();
            this.inputsDataModel.addElement(Utils.getConcept(tmpURI.toString(), true));
        }
        this.inputs.setModel(this.inputsDataModel);
        this.outputsDataModel.removeAllElements();
        for (URI tmpURI : service.getOutputs()) {
            this.outputsDataModel.addElement(Utils.getConcept(tmpURI.toString(), true));
        }
        this.outputs.setModel(this.outputsDataModel);
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.name = new JTextField();
        this.uriLabel = new JLabel();
        this.uri = new JTextField();
        this.inputsLabel = new JLabel();
        this.inputsScrollPane = new JScrollPane();
        this.inputs = new JList();
        this.outputsLabel = new JLabel();
        this.outputsScrollPane = new JScrollPane();
        this.outputs = new JList();
        this.setLayout((LayoutManager)new AbsoluteLayout());
        this.nameLabel.setText("Name");
        this.add((Component)this.nameLabel, new AbsoluteConstraints(10, 10, 320, -1));
        this.add((Component)this.name, new AbsoluteConstraints(10, 30, 320, -1));
        this.uriLabel.setText("URI");
        this.add((Component)this.uriLabel, new AbsoluteConstraints(10, 60, 320, -1));
        this.add((Component)this.uri, new AbsoluteConstraints(10, 80, 320, -1));
        this.inputsLabel.setText("Inputs");
        this.add((Component)this.inputsLabel, new AbsoluteConstraints(10, 120, 230, 20));
        this.inputsScrollPane.setViewportView(this.inputs);
        this.add((Component)this.inputsScrollPane, new AbsoluteConstraints(10, 140, 320, 170));
        this.outputsLabel.setText("Outputs");
        this.add((Component)this.outputsLabel, new AbsoluteConstraints(10, 320, 230, 20));
        this.outputsScrollPane.setViewportView(this.outputs);
        this.add((Component)this.outputsScrollPane, new AbsoluteConstraints(10, 340, 320, 170));
    }
}

