/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.owlsmx.gui;

import de.dfki.owlsmx.gui.data.TestCollection;
import de.dfki.owlsmx.gui.util.GUIState;
import de.dfki.owlsmx.gui.util.UpdateDataListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.UIManager;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class MatchmakerGUI
extends JPanel
implements ActionListener,
UpdateDataListener {
    private JButton apply;
    private JRadioButton exact;
    private JLabel l_treshold;
    private JLabel l_variant;
    private JLabel ll_mindom;
    private JLabel logo;
    private JLabel settingsHeadline;
    private ButtonGroup mindom;
    private JRadioButton nearestneighbour;
    private JRadioButton owlsm0;
    private JRadioButton owlsm1;
    private JRadioButton owlsm2;
    private JRadioButton owlsm3;
    private JRadioButton owlsm4;
    private JRadioButton plugin;
    private JSlider similaritytreshold;
    private JRadioButton subsumedby;
    private JRadioButton subsumes;
    private ButtonGroup variant;
    private JCheckBox owlsmxp;
    private JCheckBox integrative;
    private static final long serialVersionUID = 1L;

    public MatchmakerGUI() {
        try {
            UIManager.setLookAndFeel("Classic com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initComponents();
        this.updateData();
    }

    private void initComponents() {
        this.variant = new ButtonGroup();
        this.mindom = new ButtonGroup();
        this.l_treshold = new JLabel();
        this.l_variant = new JLabel();
        this.ll_mindom = new JLabel();
        this.settingsHeadline = new JLabel();
        this.similaritytreshold = new JSlider();
        this.apply = new JButton();
        this.owlsm0 = new JRadioButton();
        this.owlsm1 = new JRadioButton();
        this.owlsm2 = new JRadioButton();
        this.owlsm3 = new JRadioButton();
        this.owlsm4 = new JRadioButton();
        this.owlsmxp = new JCheckBox();
        this.integrative = new JCheckBox();
        this.exact = new JRadioButton();
        this.plugin = new JRadioButton();
        this.subsumes = new JRadioButton();
        this.subsumedby = new JRadioButton();
        this.nearestneighbour = new JRadioButton();
        this.logo = new JLabel();
        this.variant.add(this.owlsm0);
        this.variant.add(this.owlsm1);
        this.variant.add(this.owlsm2);
        this.variant.add(this.owlsm3);
        this.variant.add(this.owlsm4);
        this.mindom.add(this.exact);
        this.mindom.add(this.plugin);
        this.mindom.add(this.subsumes);
        this.mindom.add(this.subsumedby);
        this.mindom.add(this.nearestneighbour);
        this.setLayout((LayoutManager)new AbsoluteLayout());
        this.setMinimumSize(new Dimension(800, 400));
        this.setPreferredSize(new Dimension(800, 400));
        this.l_treshold.setLabelFor(this.similaritytreshold);
        this.l_treshold.setText("Hybrid filters: syntactic similarity treshold");
        this.add((Component)this.l_treshold, new AbsoluteConstraints(310, 210, 260, 20));
        this.l_variant.setText("Please select a variant of the matchmaker");
        this.add((Component)this.l_variant, new AbsoluteConstraints(110, 10, 260, -1));
        this.ll_mindom.setText("Minimum degree of match");
        this.add((Component)this.ll_mindom, new AbsoluteConstraints(110, 210, 200, -1));
        this.similaritytreshold.setMajorTickSpacing(25);
        this.similaritytreshold.setMinorTickSpacing(5);
        this.similaritytreshold.setPaintLabels(true);
        this.similaritytreshold.setPaintTicks(true);
        this.similaritytreshold.setValue(80);
        this.add((Component)this.similaritytreshold, new AbsoluteConstraints(300, 230, 280, 50));
        this.settingsHeadline.setText("Please specify the minimum requirements of relevance for the selected matchmaker variant");
        this.add((Component)this.settingsHeadline, new AbsoluteConstraints(110, 190, 540, -1));
        this.apply.setText("Apply settings to matchmaker");
        this.apply.addActionListener(this);
        this.add((Component)this.apply, new AbsoluteConstraints(110, 360, 540, -1));
        this.owlsm0.setText("OWLS-M0 - Logic based semantic filters only");
        this.add((Component)this.owlsm0, new AbsoluteConstraints(110, 30, -1, -1));
        this.owlsm1.setSelected(true);
        this.owlsm1.setText("OWLS-M1 - Hybrid filters using loss of information based similarity measure");
        this.add((Component)this.owlsm1, new AbsoluteConstraints(110, 50, -1, -1));
        this.owlsm2.setText("OWLS-M2 - Hybrid filters using extended Jaccard similarity measure");
        this.add((Component)this.owlsm2, new AbsoluteConstraints(110, 70, -1, -1));
        this.owlsm3.setText("OWLS-M3 - Hybrid filters using cosine similarity measure");
        this.add((Component)this.owlsm3, new AbsoluteConstraints(110, 90, -1, -1));
        this.owlsm4.setText("OWLS-M4 - Hybrid filters using Jensen-shannon divergence based similarity measure");
        this.add((Component)this.owlsm4, new AbsoluteConstraints(110, 110, -1, -1));
        this.owlsmxp.setText("OWLS-MXP - Datatype compatibility check for composition planning");
        this.add((Component)this.owlsmxp, new AbsoluteConstraints(110, 130, -1, -1));
        this.integrative.setText("OWLS-MX2 - Integrative hybrid matching");
        this.add((Component)this.integrative, new AbsoluteConstraints(110, 150, -1, -1));
        this.exact.setText("exact");
        this.add((Component)this.exact, new AbsoluteConstraints(110, 230, -1, -1));
        this.plugin.setText("plug-in");
        this.add((Component)this.plugin, new AbsoluteConstraints(110, 250, -1, -1));
        this.subsumes.setText("subsumes");
        this.add((Component)this.subsumes, new AbsoluteConstraints(110, 270, -1, -1));
        this.subsumedby.setText("subsumed-by");
        this.add((Component)this.subsumedby, new AbsoluteConstraints(110, 290, -1, -1));
        this.nearestneighbour.setSelected(true);
        this.nearestneighbour.setText("nearest-neighbour");
        this.add((Component)this.nearestneighbour, new AbsoluteConstraints(110, 310, -1, -1));
        this.logo.setIcon(new ImageIcon(this.getClass().getResource("/images/owlsMX1_small_rectangle.jpg")));
        this.add((Component)this.logo, new AbsoluteConstraints(0, 10, -1, -1));
    }

    private short getMinimumDegree() {
        if (this.exact.isSelected()) {
            return 0;
        }
        if (this.plugin.isSelected()) {
            return 1;
        }
        if (this.subsumes.isSelected()) {
            return 2;
        }
        if (this.subsumedby.isSelected()) {
            return 3;
        }
        if (this.nearestneighbour.isSelected()) {
            return 4;
        }
        return 5;
    }

    private short getMatchmakerVariant() {
        if (this.owlsm0.isSelected()) {
            return -1;
        }
        if (this.owlsm1.isSelected()) {
            return 0;
        }
        if (this.owlsm2.isSelected()) {
            return 1;
        }
        if (this.owlsm3.isSelected()) {
            return 2;
        }
        if (this.owlsm4.isSelected()) {
            return 3;
        }
        return -1;
    }

    private void setMinimumDegree(int degree) {
        this.exact.setSelected(false);
        this.plugin.setSelected(false);
        this.subsumes.setSelected(false);
        this.subsumedby.setSelected(false);
        this.nearestneighbour.setSelected(false);
        switch (degree) {
            case 0: {
                this.exact.setSelected(true);
                break;
            }
            case 1: {
                this.plugin.setSelected(true);
                break;
            }
            case 2: {
                this.subsumes.setSelected(true);
                break;
            }
            case 3: {
                this.subsumedby.setSelected(true);
                break;
            }
            case 4: {
                this.nearestneighbour.setSelected(true);
            }
        }
    }

    private void setMatchmakerVariant(int variant) {
        this.owlsm0.setSelected(false);
        this.owlsm1.setSelected(false);
        this.owlsm2.setSelected(false);
        this.owlsm3.setSelected(false);
        this.owlsm4.setSelected(false);
        switch (variant) {
            case -1: {
                this.owlsm0.setSelected(true);
                break;
            }
            case 0: {
                this.owlsm1.setSelected(true);
                break;
            }
            case 1: {
                this.owlsm2.setSelected(true);
                break;
            }
            case 2: {
                this.owlsm3.setSelected(true);
                break;
            }
            case 3: {
                this.owlsm4.setSelected(true);
                break;
            }
            default: {
                this.owlsm0.setSelected(true);
            }
        }
    }

    private void setTreshold(double treshold) {
        Long value = new Long(Math.round(treshold * 100.0));
        this.similaritytreshold.setValue(value.intValue());
    }

    private double getTreshold() {
        double tresh = (double)this.similaritytreshold.getValue() / 100.0;
        return tresh;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.apply)) {
            GUIState.getInstance().setMeasures(this.getMinimumDegree(), this.getMatchmakerVariant(), this.getTreshold());
            GUIState.getInstance().setOWLSMXP(this.owlsmxp.isSelected());
            GUIState.getInstance().setIntegrative(this.integrative.isSelected());
            if (!TestCollection.getInstance().checkQueriesAndServicesSets(this) || !TestCollection.getInstance().checkRelevanceSets(this)) {
                return;
            }
        }
    }

    @Override
    public void updateData() {
        this.setMinimumDegree(GUIState.getInstance().getMinDegree());
        this.setMatchmakerVariant(GUIState.getInstance().getSimilarityMeasure());
        this.setTreshold(GUIState.getInstance().getTreshold());
    }
}

