/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.owlsmx.gui;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;

public class Point {
    public int X;
    public int Y;
    public int drawX;
    public int drawY;
    private int pointsize = 5;
    private int border = 50;
    private Font font;
    private String cords;
    private boolean drawCoordinates = false;

    public int getBorder() {
        return this.border;
    }

    public void setBorder(int border) {
        this.border = border;
    }

    public int getPointsize() {
        return this.pointsize;
    }

    public void setPointsize(int pointsize) {
        this.pointsize = pointsize;
    }

    public void draw(Graphics g, float basicX, float basicY, float reduceHeight) {
        Graphics2D g2 = (Graphics2D)g;
        this.font = g2.getFont();
        this.drawX = Math.round((float)this.X * basicX + (float)this.border);
        this.drawY = Math.round((float)this.Y * basicY + reduceHeight - (float)this.border);
        this.cords = "(" + this.X + "/" + this.Y + ")";
        FontRenderContext frc = g2.getFontRenderContext();
        Rectangle2D bounds = this.font.getStringBounds(this.cords, frc);
        float width = (float)bounds.getWidth();
        if (this.drawCoordinates) {
            g2.drawString(this.cords, (float)this.drawX - width / 2.0f, (float)(this.drawY - this.font.getSize() + 5));
        }
        g2.drawOval(this.drawX - 2 * this.pointsize / 3, this.drawY - this.pointsize / 2, this.pointsize, this.pointsize);
    }

    public Point(int x, int y) {
        this.X = x;
        this.Y = y;
    }

    public Point(int x, int y, int border) {
        this.X = x;
        this.Y = y;
        this.border = border;
    }

    public int compareTo(Object obj2) {
        int BEFORE = -1;
        boolean EQUAL = false;
        boolean AFTER = true;
        if (this == obj2) {
            return 0;
        }
        Point p2 = (Point)obj2;
        if (this.X < p2.X) {
            return -1;
        }
        if (this.X == p2.X) {
            return 0;
        }
        return 1;
    }

    public boolean isDrawCoordinates() {
        return this.drawCoordinates;
    }

    public void setDrawCoordinates(boolean drawCoordinates) {
        this.drawCoordinates = drawCoordinates;
    }
}

