/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.owlsmx.gui;

import de.dfki.owlsmx.gui.DisplayGrounding;
import de.dfki.owlsmx.gui.DisplayService;
import de.dfki.owlsmx.gui.ServiceCellRenderer;
import de.dfki.owlsmx.gui.ShowPanelFrame;
import de.dfki.owlsmx.gui.data.Query;
import de.dfki.owlsmx.gui.data.ServiceItem;
import de.dfki.owlsmx.gui.data.TestCollection;
import de.dfki.owlsmx.gui.util.GUIState;
import de.dfki.owlsmx.gui.util.UpdateDataListener;
import de.dfki.owlsmx.gui.util.Utils;
import de.dfki.owlsmx.gui.util.filefilter.ServiceFilter;
import de.dfki.owlsmx.gui.util.tasks.AddServicesToCollectionTask;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ProgressMonitor;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class Requests
extends JPanel
implements ListSelectionListener,
ActionListener,
UpdateDataListener {
    private JButton addEntireDirectory;
    private JButton addQuery;
    private JList inputs;
    private JLabel inputsLabel;
    private JScrollPane inputsScrollpane;
    private JLabel logo;
    private JButton moreInfo;
    private JTextField name;
    private JLabel nameLabel;
    private JList outputs;
    private JLabel outputsLabel;
    private JScrollPane outputsScrollpane;
    private JList queries;
    private JScrollPane queriesScrollpane;
    private JLabel queryLabel;
    private JButton removeQuery;
    private JTextField uri;
    private JLabel uriLabel;
    private DefaultListModel inputsDataModel = new DefaultListModel();
    private DefaultListModel outputsDataModel = new DefaultListModel();
    public Query currentQuery;
    private JFileChooser fc_open;
    private Timer timer;
    private ProgressMonitor progressMonitor;
    private AddServicesToCollectionTask task;
    private JCheckBox markAll;
    private JButton seeGrounding;
    private static final long serialVersionUID = 1L;

    public Requests() {
        try {
            UIManager.setLookAndFeel("Classic com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initComponents();
    }

    private void initComponents() {
        this.queriesScrollpane = new JScrollPane();
        this.queries = new JList(TestCollection.getInstance().getQueryDataModel());
        this.queries.addListSelectionListener(this);
        this.queries.setCellRenderer(new ServiceCellRenderer());
        this.addQuery = new JButton();
        this.removeQuery = new JButton();
        this.moreInfo = new JButton();
        this.queryLabel = new JLabel();
        this.name = new JTextField();
        this.nameLabel = new JLabel();
        this.inputsLabel = new JLabel();
        this.outputsLabel = new JLabel();
        this.inputsScrollpane = new JScrollPane();
        this.inputs = new JList();
        this.outputsScrollpane = new JScrollPane();
        this.outputs = new JList();
        this.logo = new JLabel();
        this.uri = new JTextField();
        this.uriLabel = new JLabel();
        this.addEntireDirectory = new JButton();
        this.seeGrounding = new JButton();
        this.setLayout((LayoutManager)new AbsoluteLayout());
        this.setMinimumSize(new Dimension(800, 400));
        this.setPreferredSize(new Dimension(800, 400));
        this.queriesScrollpane.setViewportView(this.queries);
        this.add((Component)this.queriesScrollpane, new AbsoluteConstraints(110, 30, 300, 290));
        this.addQuery.setText("Add request (file)");
        this.addQuery.addActionListener(this);
        this.add((Component)this.addQuery, new AbsoluteConstraints(110, 330, 300, -1));
        this.removeQuery.setText("Remove selected requests");
        this.removeQuery.addActionListener(this);
        this.add((Component)this.removeQuery, new AbsoluteConstraints(110, 390, 300, -1));
        this.seeGrounding.setText("Show grounding");
        this.seeGrounding.addActionListener(this);
        this.add((Component)this.seeGrounding, new AbsoluteConstraints(470, 360, 300, -1));
        this.moreInfo.setText("More information");
        this.moreInfo.addActionListener(this);
        this.add((Component)this.moreInfo, new AbsoluteConstraints(470, 330, 300, -1));
        this.queryLabel.setText("Service requests");
        this.add((Component)this.queryLabel, new AbsoluteConstraints(110, 10, 300, -1));
        this.add((Component)this.name, new AbsoluteConstraints(470, 30, 300, -1));
        this.nameLabel.setText("Name");
        this.add((Component)this.nameLabel, new AbsoluteConstraints(470, 10, 300, -1));
        this.inputsLabel.setText("Inputs");
        this.add((Component)this.inputsLabel, new AbsoluteConstraints(470, 100, 300, 20));
        this.outputsLabel.setText("Outputs");
        this.add((Component)this.outputsLabel, new AbsoluteConstraints(470, 210, 300, 20));
        this.inputsScrollpane.setViewportView(this.inputs);
        this.add((Component)this.inputsScrollpane, new AbsoluteConstraints(470, 120, 300, 90));
        this.outputsScrollpane.setViewportView(this.outputs);
        this.add((Component)this.outputsScrollpane, new AbsoluteConstraints(470, 230, 300, 90));
        this.logo.setIcon(new ImageIcon(this.getClass().getResource("/images/owlsMX1_small_rectangle.jpg")));
        this.add((Component)this.logo, new AbsoluteConstraints(0, 10, -1, -1));
        this.add((Component)this.uri, new AbsoluteConstraints(470, 80, 300, -1));
        this.uriLabel.setText("URI");
        this.add((Component)this.uriLabel, new AbsoluteConstraints(470, 60, 300, -1));
        this.addEntireDirectory.setText("Add requests (filefolder)");
        this.addEntireDirectory.addActionListener(this);
        this.add((Component)this.addEntireDirectory, new AbsoluteConstraints(110, 360, 300, -1));
        this.fc_open = new JFileChooser();
        this.fc_open.addChoosableFileFilter(new ServiceFilter());
        this.markAll = new JCheckBox();
        this.markAll.setText("Select all");
        this.markAll.addActionListener(this);
        this.add((Component)this.markAll, new AbsoluteConstraints(330, 5, 80, -1));
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        if (event.getSource().equals(this.queries)) {
            Query tmp = (Query)this.queries.getSelectedValue();
            if (this.currentQuery != null && this.currentQuery.equals(tmp) || tmp == null) {
                return;
            }
            this.currentQuery = tmp;
            this.name.setText(this.currentQuery.getName());
            this.uri.setText(this.currentQuery.getURI().toString());
            this.inputsDataModel.removeAllElements();
            Iterator iter = this.currentQuery.getInputs().iterator();
            while (iter.hasNext()) {
                this.inputsDataModel.addElement(Utils.getConcept((URI)iter.next(), true));
            }
            this.inputs.setModel(this.inputsDataModel);
            this.outputsDataModel.removeAllElements();
            iter = this.currentQuery.getOutputs().iterator();
            while (iter.hasNext()) {
                this.outputsDataModel.addElement(Utils.getConcept((URI)iter.next(), true));
            }
            this.outputs.setModel(this.outputsDataModel);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object[] values;
        if (event.getSource().equals(this.addEntireDirectory)) {
            this.fc_open.setFileSelectionMode(1);
            if (this.fc_open.showOpenDialog(this) == 0) {
                File[] files = this.fc_open.getSelectedFile().listFiles();
                this.progressMonitor = new ProgressMonitor(this, "Testcollection", "Adding queries to testcollection", 0, files.length - 1);
                this.progressMonitor.setProgress(0);
                this.progressMonitor.setMillisToDecideToPopup(0);
                this.progressMonitor.setMillisToPopup(0);
                this.timer = new Timer(1000, this);
                this.timer.start();
                this.timer.addActionListener(this);
                this.task = new AddServicesToCollectionTask(this, files, true);
                this.task.go();
            }
        } else if (event.getSource().equals(this.timer)) {
            this.progressMonitor.setProgress(this.task.getCurrent());
            if (this.progressMonitor.isCanceled() || this.task.isDone()) {
                this.progressMonitor.close();
                this.task.stop();
                this.timer.stop();
                if (!this.task.isDone()) {
                    GUIState.displayWarning(this.getClass().toString(), "Added only " + this.task.getCurrent() + " of " + this.task.getLengthOfTask() + " queries");
                }
            }
        } else if (event.getSource().equals(this.addQuery)) {
            this.fc_open.setFileSelectionMode(0);
            if (this.fc_open.showOpenDialog(this) == 0) {
                TestCollection.getInstance().addQuery(this.fc_open.getSelectedFile().toURI());
            }
        } else if (event.getSource().equals(this.moreInfo)) {
            Object[] values2 = this.queries.getSelectedValues();
            int i = 0;
            while (i < values2.length) {
                ServiceItem tmpService = (ServiceItem)values2[i];
                DisplayService dService = new DisplayService(tmpService);
                EventQueue.invokeLater(new ShowPanelFrame(dService, false));
                ++i;
            }
        } else if (event.getSource().equals(this.removeQuery)) {
            TestCollection.getInstance().removeQueries(this.queries.getSelectedValues());
        } else if (event.getSource().equals(this.markAll)) {
            if (this.markAll.isSelected()) {
                this.queries.addSelectionInterval(0, this.queries.getModel().getSize() - 1);
            } else {
                this.queries.removeSelectionInterval(0, this.queries.getModel().getSize() - 1);
            }
        } else if (event.getSource().equals(this.seeGrounding) && (values = this.queries.getSelectedValues()).length == 1) {
            ServiceItem serviceItem = (ServiceItem)values[0];
            if (serviceItem.hasWSDLGrounding()) {
                EventQueue.invokeLater(new ShowPanelFrame(new DisplayGrounding(serviceItem), false));
            } else {
                JOptionPane.showMessageDialog(null, "The service \"" + serviceItem.getName() + "\" has no WSDL Grounding!", "No Grounding!", 2);
            }
        }
        this.updateData();
    }

    @Override
    public void updateData() {
        int[] selected = this.queries.getSelectedIndices();
        this.queries.setModel(TestCollection.getInstance().getQueryDataModel());
        this.queries.setSelectedIndices(selected);
    }
}

