/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.owlsmx.gui;

import de.dfki.owlsmx.analysis.MacroAvgRecallPrecision;
import de.dfki.owlsmx.analysis.MemoryContainer;
import de.dfki.owlsmx.analysis.PassedTimeContainer;
import de.dfki.owlsmx.analysis.RecallPrecisionPair;
import de.dfki.owlsmx.gui.ShowResultVisualization;
import de.dfki.owlsmx.gui.data.HybridServiceItem;
import de.dfki.owlsmx.gui.data.Query;
import de.dfki.owlsmx.gui.data.TestCollection;
import de.dfki.owlsmx.gui.util.Converter;
import de.dfki.owlsmx.gui.util.GUIState;
import de.dfki.owlsmx.gui.util.GUIUtils;
import de.dfki.owlsmx.gui.util.MatchmakerInterface;
import de.dfki.owlsmx.gui.util.UpdateDataListener;
import de.dfki.owlsmx.gui.util.filefilter.EPSFilter;
import de.dfki.owlsmx.gui.util.filefilter.JPGFilter;
import de.dfki.owlsmx.gui.util.filefilter.PDFFilter;
import de.dfki.owlsmx.gui.util.filefilter.PNGFilter;
import de.dfki.owlsmx.gui.util.print2DtoPS;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jibble.epsgraphics.EpsGraphics2D;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class ResultVisualization
extends JPanel
implements UpdateDataListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private JButton save;
    private JLabel graphLabel;
    private JLabel logo;
    private JFileChooser fc;
    private JFreeChart chart;
    public static final int graphWidth = 400;
    public static final int graphHeight = 400;
    public static final int graphPrintWidth = 600;
    public static final int graphPrintHeight = 600;
    private JPanel chartPanel = this.createRPPanel();
    private JButton launch;
    private JButton show;
    private JRadioButton showAQRT;
    private JRadioButton showRP;
    private JRadioButton showMemory;
    private ButtonGroup showGraph;

    public ResultVisualization() {
        this.initComponents();
        this.chartPanel = new JPanel();
        this.add((Component)this.chartPanel, new AbsoluteConstraints(250, 5, 400, 400));
        this.showRP.setSelected(true);
    }

    public JPanel createRPPanel() {
        if (!GUIState.getInstance().getPrecisionRecall()) {
            return new JPanel();
        }
        this.chart = this.createRPChart();
        ChartPanel panel = new ChartPanel(this.chart);
        GUIUtils.makeTransparent((JComponent)panel);
        return panel;
    }

    public JPanel createAQRTPanel() {
        if (!GUIState.getInstance().getDisplayAQR()) {
            return new JPanel();
        }
        this.chart = this.createAQRTChart();
        ChartPanel panel = new ChartPanel(this.chart);
        GUIUtils.makeTransparent((JComponent)panel);
        return panel;
    }

    public JPanel createMemoryPanel() {
        if (!GUIState.getInstance().getMemoryConsumption()) {
            return new JPanel();
        }
        this.chart = this.createMemoryChart();
        ChartPanel panel = new ChartPanel(this.chart);
        GUIUtils.makeTransparent((JComponent)panel);
        return panel;
    }

    private XYSeries createSeriesFromDataMap(Map datamap) {
        XYSeries ser = new XYSeries((Comparable)((Object)"OWLS-MX"));
        if (datamap.size() <= 0) {
            return ser;
        }
        for (Map.Entry entry : datamap.entrySet()) {
            ser.add(((Integer)entry.getKey()).doubleValue(), ((Long)entry.getValue()).doubleValue());
        }
        return ser;
    }

    private JFreeChart createMemoryChart() {
        XYSeriesCollection data = new XYSeriesCollection();
        Map memory = MemoryContainer.getInstance().getStoredValues();
        data.addSeries(this.createSeriesFromDataMap(memory));
        JFreeChart chart = ChartFactory.createXYLineChart((String)"Memoryconsumption", (String)"Services", (String)"Memory (KByte)", (XYDataset)data, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        XYPlot plot = chart.getXYPlot();
        XYItemRenderer renderer = plot.getRenderer();
        renderer.setSeriesPaint(0, (Paint)Color.red);
        chart.removeLegend();
        return chart;
    }

    private JFreeChart createAQRTChart() {
        XYSeriesCollection data = new XYSeriesCollection();
        Map passedTime = PassedTimeContainer.getInstance().getStoredValues();
        passedTime.put(new Integer(0), new Long(0L));
        data.addSeries(this.createSeriesFromDataMap(passedTime));
        JFreeChart chart = ChartFactory.createXYLineChart((String)"Average query response time", (String)"Services", (String)"Time (ms)", (XYDataset)data, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        XYPlot plot = chart.getXYPlot();
        XYItemRenderer renderer = plot.getRenderer();
        renderer.setSeriesPaint(0, (Paint)Color.red);
        chart.removeLegend();
        return chart;
    }

    private String getFileName(String uri) {
        return uri.substring(uri.lastIndexOf("/"));
    }

    private ArrayList getURIasStringFromServiceSet(SortedSet services) {
        ArrayList<String> result = new ArrayList<String>();
        for (HybridServiceItem item : services) {
            result.add(this.getFileName(item.getURI().toString()));
        }
        return result;
    }

    private ArrayList getURIasStringFromURISet(SortedSet services) {
        ArrayList<String> result = new ArrayList<String>();
        Iterator iter = services.iterator();
        while (iter.hasNext()) {
            String uri = ((URI)iter.next()).toString();
            result.add(this.getFileName(uri.toString()));
        }
        return result;
    }

    private XYSeries createRPSeries(MacroAvgRecallPrecision recall, boolean exists) {
        XYSeries ser = new XYSeries((Comparable)((Object)"OWLS-MX Matchmaker"));
        if (exists) {
            return ser;
        }
        ArrayList<RecallPrecisionPair> resultValues = recall.getMacroAveragePrecisions();
        boolean begins = false;
        int i = 0;
        while (i < resultValues.size()) {
            RecallPrecisionPair pair = resultValues.get(i);
            if (pair.precision > 0.0) {
                begins = true;
            }
            if (begins && !new Double(pair.precision).isNaN()) {
                ser.add(pair.recall, pair.precision);
            }
            ++i;
        }
        return ser;
    }

    public JFreeChart createRPChart() {
        MacroAvgRecallPrecision recall = new MacroAvgRecallPrecision(20);
        ArrayList retrievedServices = new ArrayList();
        ArrayList relevantServices = new ArrayList();
        for (Map.Entry me : TestCollection.getInstance().getMatchmakerAnswerset(GUIState.getInstance().getSorting()).entrySet()) {
            Query query = (Query)me.getKey();
            retrievedServices = this.getURIasStringFromServiceSet((SortedSet)me.getValue());
            relevantServices = this.getURIasStringFromURISet(TestCollection.getInstance().getAnswerset(query.getURI()));
            if (relevantServices.size() <= 0) {
                GUIState.displayWarning(this, "Error when computing recall/precision graph", "Relevance set is empty. Maybe forgotten to define?");
            }
            recall.processRecallPrecision(retrievedServices, relevantServices);
        }
        XYSeriesCollection data = new XYSeriesCollection();
        data.addSeries(this.createRPSeries(recall, retrievedServices.size() <= 0));
        JFreeChart chart = ChartFactory.createXYLineChart((String)"Recall/Precision", (String)"Recall", (String)"Precision", (XYDataset)data, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.removeLegend();
        XYPlot plot = chart.getXYPlot();
        XYItemRenderer renderer = plot.getRenderer();
        renderer.setSeriesPaint(0, (Paint)Color.red);
        return chart;
    }

    private void initComponents() {
        this.graphLabel = new JLabel();
        this.save = new JButton();
        this.logo = new JLabel();
        this.showAQRT = new JRadioButton();
        this.showRP = new JRadioButton();
        this.showMemory = new JRadioButton();
        this.launch = new JButton();
        this.show = new JButton();
        this.showGraph = new ButtonGroup();
        this.showGraph.add(this.showAQRT);
        this.showGraph.add(this.showRP);
        this.showGraph.add(this.showMemory);
        this.setLayout((LayoutManager)new AbsoluteLayout());
        this.graphLabel.setText("Show graph");
        this.add((Component)this.graphLabel, new AbsoluteConstraints(5, 160, 170, -1));
        this.logo.setIcon(new ImageIcon(this.getClass().getResource("/images/owlsMX1_small_rectangle.jpg")));
        this.add((Component)this.logo, new AbsoluteConstraints(5, 10, -1, -1));
        this.fc = new JFileChooser();
        this.fc.addChoosableFileFilter(new PNGFilter());
        this.fc.addChoosableFileFilter(new JPGFilter());
        this.fc.addChoosableFileFilter(new PDFFilter());
        this.fc.addChoosableFileFilter(new EPSFilter());
        this.showAQRT.setText("Average query response time");
        this.add((Component)this.showAQRT, new AbsoluteConstraints(10, 180, -1, -1));
        this.showRP.setText("Recall/Precision");
        this.add((Component)this.showRP, new AbsoluteConstraints(10, 200, -1, -1));
        this.showMemory.setText("Memory consumption");
        this.add((Component)this.showMemory, new AbsoluteConstraints(10, 220, -1, -1));
        this.save.setText("Save displayed graph");
        this.save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ResultVisualization.this.saveActionPerformed(evt);
            }
        });
        this.add((Component)this.save, new AbsoluteConstraints(5, 280, 245, -1));
        this.show.setText("Show");
        this.add((Component)this.show, new AbsoluteConstraints(5, 250, 120, -1));
        this.show.addActionListener(this);
        this.launch.setText("New window");
        this.add((Component)this.launch, new AbsoluteConstraints(130, 250, 120, -1));
        this.launch.addActionListener(this);
        this.setMinimumSize(new Dimension(800, 400));
        this.setPreferredSize(new Dimension(800, 400));
    }

    private void saveActionPerformed(ActionEvent event) {
        try {
            if (event.getSource().equals(this.save) && this.fc.showSaveDialog(this) == 0) {
                if (this.fc.getFileFilter().getClass().equals(new PNGFilter().getClass())) {
                    if (this.fc.getSelectedFile().getAbsolutePath().toLowerCase().endsWith(".png")) {
                        ChartUtilities.saveChartAsPNG((File)this.fc.getSelectedFile(), (JFreeChart)this.chart, (int)600, (int)600);
                    } else {
                        ChartUtilities.saveChartAsPNG((File)new File(String.valueOf(this.fc.getSelectedFile().getAbsolutePath()) + ".png"), (JFreeChart)this.chart, (int)600, (int)600);
                    }
                } else if (this.fc.getFileFilter().getClass().equals(new JPGFilter().getClass())) {
                    if (this.fc.getSelectedFile().getAbsolutePath().toLowerCase().endsWith(".png")) {
                        ChartUtilities.saveChartAsJPEG((File)this.fc.getSelectedFile(), (JFreeChart)this.chart, (int)600, (int)600);
                    } else {
                        ChartUtilities.saveChartAsJPEG((File)new File(String.valueOf(this.fc.getSelectedFile().getAbsolutePath()) + ".png"), (JFreeChart)this.chart, (int)600, (int)600);
                    }
                } else if (this.fc.getFileFilter().getClass().equals(new PDFFilter().getClass())) {
                    if (this.fc.getSelectedFile().getAbsolutePath().toLowerCase().endsWith(".pdf")) {
                        Converter.convertToPdf(this.chart, 600, 600, this.fc.getSelectedFile().getAbsolutePath());
                    } else {
                        Converter.convertToPdf(this.chart, 600, 600, String.valueOf(this.fc.getSelectedFile().getAbsolutePath()) + ".pdf");
                    }
                } else if (this.fc.getFileFilter().getClass().equals(new EPSFilter().getClass())) {
                    this.printGraphics2DtoEPS(this.fc.getSelectedFile().getAbsolutePath());
                }
            }
        }
        catch (Exception e) {
            GUIState.displayWarning(e.getClass().toString(), "Couldn't save file " + this.fc.getSelectedFile().getAbsolutePath());
            e.printStackTrace();
        }
    }

    public void PrintGraphics2DToPS(String path) throws IOException {
        try {
            GUIState.displayWarning("Incomplete feature", "This feature is still under heavy development and can not yet be used");
            print2DtoPS printer = new print2DtoPS(path, this.chartPanel, 600, 600);
            printer.print(this.createRPPanel().getGraphics(), new PageFormat(), 0);
        }
        catch (PrinterException pe) {
            GUIState.displayWarning(pe.getClass().toString(), "Couldn't create PS file!\n" + pe.getMessage());
        }
    }

    public void printGraphics2DtoEPS(String path) {
        try {
            if (!path.toLowerCase().endsWith(".eps")) {
                path = String.valueOf(path) + ".eps";
            }
            FileOutputStream outputStream = new FileOutputStream(path);
            EpsGraphics2D g = new EpsGraphics2D("", (OutputStream)outputStream, 0, 0, 400, 400);
            g.flush();
            g.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updateData() {
        if (GUIState.getInstance().getDisplayAQR() || GUIState.getInstance().getPrecisionRecall() || GUIState.getInstance().getMemoryConsumption()) {
            this.showPanel();
        }
        this.updateUI();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource().equals(this.launch)) {
            if (this.showAQRT.isSelected()) {
                if (GUIState.getInstance().getDisplayAQR()) {
                    this.showGraphWindow(this.createAQRTChart());
                } else {
                    GUIState.displayWarning(this, "Graph not available", "Average query response time is not available, as the necessary measurement were not executed during the matching process");
                }
            } else if (this.showMemory.isSelected()) {
                if (GUIState.getInstance().getMemoryConsumption()) {
                    this.showGraphWindow(this.createMemoryChart());
                } else {
                    GUIState.displayWarning(this, "Graph not available", "Memory consumption is not available, as the necessary measurement were not executed during the matching process");
                }
            } else if (this.showRP.isSelected()) {
                if (GUIState.getInstance().getPrecisionRecall()) {
                    this.showGraphWindow(this.createRPChart());
                } else {
                    GUIState.displayWarning(this, "Graph not available", "Recall/Precision is not available, as the necessary measurement were not executed during the matching process");
                }
            }
        } else if (evt.getSource().equals(this.show)) {
            this.showPanel();
        }
        this.updateUI();
    }

    private void showPanel() {
        this.remove(this.chartPanel);
        if (this.showAQRT.isSelected()) {
            if (!GUIState.getInstance().getDisplayAQR() && MatchmakerInterface.getInstance().didRun()) {
                if (GUIState.getInstance().getDisplayAQR()) {
                    GUIState.displayWarning(this, "Graph not available", "Average query response time is not available, as the necessary measurement were not executed during the matching process");
                } else {
                    this.chartPanel = new JPanel();
                }
                return;
            }
            this.chartPanel = this.createAQRTPanel();
        } else if (this.showMemory.isSelected()) {
            if (!GUIState.getInstance().getMemoryConsumption() && MatchmakerInterface.getInstance().didRun()) {
                if (GUIState.getInstance().getMemoryConsumption()) {
                    GUIState.displayWarning(this, "Graph not available", "Memory consumption is not available, as the necessary measurement were not executed during the matching process");
                } else {
                    this.chartPanel = new JPanel();
                }
                return;
            }
            this.chartPanel = this.createMemoryPanel();
        } else if (this.showRP.isSelected()) {
            if (!GUIState.getInstance().getPrecisionRecall() && MatchmakerInterface.getInstance().didRun()) {
                if (GUIState.getInstance().getPrecisionRecall()) {
                    GUIState.displayWarning(this, "Graph not available", "Recall/Precision is not available, as the necessary measurement were not executed during the matching process");
                } else {
                    this.chartPanel = new JPanel();
                }
                return;
            }
            this.chartPanel = this.createRPPanel();
        }
        this.add((Component)this.chartPanel, new AbsoluteConstraints(250, 5, 400, 400));
    }

    private void showGraphWindow(JFreeChart Thischart) {
        ShowResultVisualization result = new ShowResultVisualization(Thischart);
        result.run();
    }
}

