/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.owlsmx.gui;

import de.dfki.owlsmx.gui.data.TestCollection;
import de.dfki.owlsmx.gui.util.UpdateDataListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class TestCollectionGUI
extends JPanel
implements ActionListener,
UpdateDataListener {
    private JTextArea comment;
    private JLabel comment_label;
    private JScrollPane comment_scroll;
    private JButton loadTC;
    private JButton clearTC;
    private JLabel logo;
    private JTextField name;
    private JLabel name_label;
    private JButton saveTC;
    private JTextField version;
    private JLabel version_label;
    private JFileChooser fc_open = new JFileChooser();
    private JFileChooser fc_close = new JFileChooser();
    private static final long serialVersionUID = 1L;

    public TestCollectionGUI() {
        this.initComponents();
        this.fc_close.setDialogTitle("Save Testcollection");
        this.fc_close.setFileSelectionMode(0);
        this.fc_open.setDialogTitle("Load Testcollection");
        this.fc_open.setDialogType(0);
        this.fc_open.setFileSelectionMode(0);
    }

    private void initComponents() {
        this.saveTC = new JButton();
        this.clearTC = new JButton();
        this.name = new JTextField();
        this.name.addActionListener(this);
        this.name_label = new JLabel();
        this.version_label = new JLabel();
        this.version = new JTextField();
        this.version.addActionListener(this);
        this.loadTC = new JButton();
        this.comment_label = new JLabel();
        this.comment_scroll = new JScrollPane();
        this.comment = new JTextArea();
        this.logo = new JLabel();
        this.setLayout((LayoutManager)new AbsoluteLayout());
        this.setMinimumSize(new Dimension(800, 400));
        this.setPreferredSize(new Dimension(800, 450));
        this.saveTC.setText("Save test collection");
        this.saveTC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestCollectionGUI.this.saveTCActionPerformed(evt);
            }
        });
        this.add((Component)this.saveTC, new AbsoluteConstraints(540, 40, 250, -1));
        this.clearTC.setText("Clear current test collection");
        this.clearTC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestCollectionGUI.this.clearTC();
            }
        });
        this.add((Component)this.clearTC, new AbsoluteConstraints(540, 70, 250, -1));
        this.add((Component)this.name, new AbsoluteConstraints(110, 30, 410, -1));
        this.name_label.setText("Name");
        this.add((Component)this.name_label, new AbsoluteConstraints(110, 10, 410, -1));
        this.version_label.setText("Version");
        this.add((Component)this.version_label, new AbsoluteConstraints(110, 60, 410, -1));
        this.add((Component)this.version, new AbsoluteConstraints(110, 80, 410, -1));
        this.loadTC.setText("Load test collection");
        this.loadTC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TestCollectionGUI.this.loadTCActionPerformed(evt);
            }
        });
        this.add((Component)this.loadTC, new AbsoluteConstraints(540, 10, 250, -1));
        this.comment_label.setText("Comments");
        this.add((Component)this.comment_label, new AbsoluteConstraints(110, 110, 400, -1));
        this.comment_scroll.setViewportView(this.comment);
        this.add((Component)this.comment_scroll, new AbsoluteConstraints(110, 130, 410, 250));
        this.logo.setIcon(new ImageIcon(this.getClass().getResource("/images/owlsMX1_small_rectangle.jpg")));
        this.add((Component)this.logo, new AbsoluteConstraints(0, 10, -1, -1));
    }

    private void updateTCDetails() {
        TestCollection.getInstance().setName(this.name.getText());
        TestCollection.getInstance().setVersion(this.version.getText());
        TestCollection.getInstance().setComment(this.comment.getText());
    }

    private void loadTCDetails() {
        this.name.setText(TestCollection.getInstance().getName());
        this.version.setText(TestCollection.getInstance().getVersion());
        this.comment.setText(TestCollection.getInstance().getComment());
    }

    private void loadTCActionPerformed(ActionEvent evt) {
        if (this.fc_open.showOpenDialog(this) == 0) {
            TestCollection.getInstance().load(this.fc_open.getSelectedFile().getAbsolutePath(), this);
            this.loadTCDetails();
            TestCollection.getInstance().updateData();
        }
    }

    private void saveTCActionPerformed(ActionEvent evt) {
        this.updateTCDetails();
        if (this.fc_close.showSaveDialog(this) == 0) {
            TestCollection.getInstance().save(this.fc_close.getSelectedFile().getAbsolutePath());
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.updateTCDetails();
    }

    public void clearTC() {
        if (JOptionPane.showConfirmDialog(this, "Should the current test collection really be cleared ?", "Clear test collection", 0) != 0) {
            return;
        }
        TestCollection.getInstance().clearTC();
        this.comment.setText("");
        this.name.setText("");
        this.version.setText("");
        this.updateTCDetails();
    }

    @Override
    public void updateData() {
        this.updateTCDetails();
    }
}

