/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.owlsmx.gui;

import de.dfki.owlsmx.gui.data.TestCollection;
import de.dfki.owlsmx.gui.util.GUIState;
import de.dfki.owlsmx.gui.util.UpdateDataListener;
import de.dfki.owlsmx.gui.util.tasks.AddServicesToMatchmakerTask;
import de.dfki.owlsmx.gui.util.tasks.RunQueriesTask;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ProgressMonitor;
import javax.swing.Timer;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public class Testing
extends JPanel
implements ActionListener,
UpdateDataListener {
    private JCheckBox answerSet;
    private JButton apply;
    private JLabel logo;
    private JCheckBox memoryConsumption;
    private JCheckBox queryResponseTime;
    private JCheckBox recallPrecision;
    private JButton runAllQueries;
    private JLabel testLabel;
    private static final long serialVersionUID = 1L;
    private Timer timer;
    private ProgressMonitor progressMonitor;
    private AddServicesToMatchmakerTask addServicesTask;
    private RunQueriesTask runQueriesTask;
    private int length = 0;

    public Testing() {
        this.initComponents();
        this.updateButtons();
    }

    private void initComponents() {
        this.recallPrecision = new JCheckBox();
        this.queryResponseTime = new JCheckBox();
        this.memoryConsumption = new JCheckBox();
        this.testLabel = new JLabel();
        this.runAllQueries = new JButton();
        this.logo = new JLabel();
        this.answerSet = new JCheckBox();
        this.apply = new JButton();
        this.apply.addActionListener(this);
        this.setLayout((LayoutManager)new AbsoluteLayout());
        this.setMinimumSize(new Dimension(800, 400));
        this.setPreferredSize(new Dimension(800, 400));
        this.recallPrecision.setText("Recall/Precision");
        this.recallPrecision.addActionListener(this);
        this.add((Component)this.recallPrecision, new AbsoluteConstraints(360, 40, -1, -1));
        this.queryResponseTime.setText("Average query response time");
        this.queryResponseTime.addActionListener(this);
        this.add((Component)this.queryResponseTime, new AbsoluteConstraints(160, 80, -1, -1));
        this.memoryConsumption.setText("Memory consumption");
        this.memoryConsumption.addActionListener(this);
        this.add((Component)this.memoryConsumption, new AbsoluteConstraints(360, 80, -1, -1));
        this.testLabel.setText("Tests to perform");
        this.add((Component)this.testLabel, new AbsoluteConstraints(160, 10, -1, -1));
        this.runAllQueries.setText("Apply");
        this.runAllQueries.addActionListener(this);
        this.add((Component)this.runAllQueries, new AbsoluteConstraints(160, 140, 350, -1));
        this.logo.setIcon(new ImageIcon(this.getClass().getResource("/images/owlsMX1_small_rectangle.jpg")));
        this.add((Component)this.logo, new AbsoluteConstraints(0, 10, -1, -1));
        this.answerSet.setText("Answer set");
        this.answerSet.addActionListener(this);
        this.add((Component)this.answerSet, new AbsoluteConstraints(160, 40, -1, -1));
    }

    public void updateButtons() {
        this.answerSet.setSelected(GUIState.getInstance().getDisplayAnswerSet());
        this.memoryConsumption.setSelected(GUIState.getInstance().getMemoryConsumption());
        this.queryResponseTime.setSelected(GUIState.getInstance().getDisplayAQR());
        this.recallPrecision.setSelected(GUIState.getInstance().getPrecisionRecall());
    }

    public void processButtonState() {
        GUIState.getInstance().setDisplayAnswerSet(this.answerSet.isSelected());
        GUIState.getInstance().setMemoryConsumption(this.memoryConsumption.isSelected());
        GUIState.getInstance().setDisplayAQR(this.queryResponseTime.isSelected());
        GUIState.getInstance().setPrecisionRecall(this.recallPrecision.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.runAllQueries)) {
            this.processButtonState();
            if (!TestCollection.getInstance().checkQueriesAndServicesSets(this)) {
                return;
            }
            this.addServicesTask = new AddServicesToMatchmakerTask();
            this.runQueriesTask = new RunQueriesTask();
            this.length = this.runQueriesTask.getLengthOfTask() + this.addServicesTask.getLengthOfTask();
            this.progressMonitor = new ProgressMonitor(this, "Matchmaking", "Loading services into matchmaker", 0, this.length);
            this.progressMonitor.setProgress(this.addServicesTask.getCurrent());
            this.progressMonitor.setMillisToDecideToPopup(0);
            this.progressMonitor.setMillisToPopup(0);
            this.timer = new Timer(500, this);
            this.timer.start();
            this.timer.addActionListener(this);
            this.addServicesTask.go();
        } else if (event.getSource().equals(this.timer)) {
            this.progressMonitor.setProgress(this.addServicesTask.getCurrent() + this.runQueriesTask.getCurrent());
            if (!this.addServicesTask.isDone()) {
                this.progressMonitor.setNote(this.addServicesTask.getMessage());
            } else {
                this.progressMonitor.setNote(this.runQueriesTask.getMessage());
            }
            if (this.progressMonitor.isCanceled()) {
                this.timer.stop();
                if (!this.addServicesTask.isDone()) {
                    GUIState.displayWarning(this.getClass().toString(), "Added only " + this.addServicesTask.getCurrent() + " of " + this.addServicesTask.getLengthOfTask() + " services");
                } else if (!this.runQueriesTask.isDone()) {
                    GUIState.displayWarning(this.getClass().toString(), "Applied only " + this.runQueriesTask.getCurrent() + " of " + this.runQueriesTask.getLengthOfTask() + " queries");
                }
                this.addServicesTask.stop();
                this.runQueriesTask.stop();
                this.progressMonitor.close();
                TestCollection.getInstance().updateData();
            } else if (this.addServicesTask.isDone() && !this.runQueriesTask.isRunning()) {
                this.addServicesTask.stop();
                this.progressMonitor.setNote("Running queries");
                this.runQueriesTask.go();
            } else if (this.runQueriesTask.isDone()) {
                this.progressMonitor.close();
                this.runQueriesTask.stop();
                this.timer.stop();
                TestCollection.getInstance().updateData();
            }
        }
    }

    @Override
    public void updateData() {
    }
}

