/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.owlsmx.gui.data;

import de.dfki.owlsmx.gui.data.ServiceItem;
import java.io.Serializable;
import java.net.URI;

public class HybridServiceItem
extends ServiceItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected int dom = -1;
    protected double similarity = -1.0;
    protected boolean datatypeCompatible = true;

    public HybridServiceItem(URI uri) {
        super(uri);
    }

    @Override
    public String toString() {
        String result = "(" + this.dom + ", " + (double)Math.round(this.similarity * 100.0) / 100.0 + ") " + this.name;
        result = result.replaceAll("[\\r\\f]", "");
        return result;
    }

    public HybridServiceItem(ServiceItem item) {
        this.uri = item.getURI();
        this.fileURI = item.fileURI;
        this.processed = item.processed;
        this.inputs = item.getInputs();
        this.outputs = item.getOutputs();
        this.name = item.name;
        this.hasWSDLGrounding = item.hasWSDLGrounding;
        this.name = this.name.replaceAll("[\\r\\f]", "");
    }

    public HybridServiceItem(HybridServiceItem item) {
        this.uri = item.getURI();
        this.fileURI = item.fileURI;
        this.processed = item.processed;
        this.inputs = item.getInputs();
        this.outputs = item.getOutputs();
        this.name = item.name;
        this.name = this.name.replaceAll("[\\r\\f]", "");
        this.dom = item.getDegreeOfMatch();
        this.similarity = item.getSyntacticSimilarity();
        this.datatypeCompatible = item.datatypeCompatible;
    }

    public int getDegreeOfMatch() {
        return this.dom;
    }

    public void setDegreeOfMatch(int dom) {
        this.dom = dom;
    }

    public double getSyntacticSimilarity() {
        return this.similarity;
    }

    public void setSyntacticSimilarity(double similarity) {
        this.similarity = similarity;
    }

    public boolean isDataTypeCompatible() {
        return this.datatypeCompatible;
    }

    public void setDataTypeCompatible(boolean compatible) {
        this.datatypeCompatible = compatible;
    }

    @Override
    public int compareTo(Object obj) {
        if (!this.getClass().equals(obj.getClass())) {
            return 1;
        }
        HybridServiceItem item = (HybridServiceItem)obj;
        if (this.dom < item.dom || this.dom == item.dom && this.similarity < item.similarity) {
            return -1;
        }
        if (this.dom == item.dom && this.similarity == item.similarity && this.uri.equals(item.uri) && this.uri.equals(item.uri) && this.fileURI.equals(item.fileURI)) {
            return 0;
        }
        return -1;
    }
}

