/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.owlsmx.gui.data;

import java.io.Serializable;
import java.util.regex.Pattern;

public class TaskContent
implements Serializable {
    private static final long serialVersionUID = 1L;
    public Integer task;
    public int step;
    public int totalSteps;
    public int screen;
    public String taskTitle;
    public String screenTitle;
    public String screenText;

    public TaskContent(String content) {
        Pattern p = Pattern.compile(";");
        String[] items = p.split(content);
        if (items.length != 7) {
            return;
        }
        this.task = this.switchTask(items[0]);
        this.taskTitle = items[1];
        this.totalSteps = Integer.parseInt(items[2]);
        this.step = Integer.parseInt(items[3]);
        this.screen = this.switchTab(items[4]);
        this.screenTitle = items[5];
        this.screenText = items[6];
    }

    private Integer switchTask(String task) {
        if (task.toUpperCase().equals("NO_TASK")) {
            return new Integer(-1);
        }
        if (task.toUpperCase().equals("QUERY_TASK")) {
            return new Integer(0);
        }
        if (task.toUpperCase().equals("CREATE_TC_TASK")) {
            return new Integer(1);
        }
        if (task.toUpperCase().equals("RUN_TEST_TASK")) {
            return new Integer(2);
        }
        return new Integer(4);
    }

    private int switchTab(String tab) {
        if (tab.toUpperCase().equals("TASK")) {
            return 0;
        }
        if (tab.toUpperCase().equals("SERVICES")) {
            return 1;
        }
        if (tab.toUpperCase().equals("QUERIES")) {
            return 2;
        }
        if (tab.toUpperCase().equals("ANSWERSET")) {
            return 3;
        }
        if (tab.toUpperCase().equals("TESTCOLLECTION")) {
            return 4;
        }
        if (tab.toUpperCase().equals("MATCHMAKER")) {
            return 5;
        }
        if (tab.toUpperCase().equals("EVALUATION")) {
            return 6;
        }
        if (tab.toUpperCase().equals("RESULT")) {
            return 7;
        }
        if (tab.toUpperCase().equals("PERFORMANCE")) {
            return 8;
        }
        return -1;
    }

    public String toString() {
        return String.valueOf(this.task.toString()) + ". " + this.taskTitle + " Step " + this.step + "/" + this.totalSteps + ": " + this.screenTitle;
    }
}

