/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.owlsmx.gui.data;

import de.dfki.owlsmx.gui.data.HybridServiceItem;
import de.dfki.owlsmx.gui.data.Query;
import de.dfki.owlsmx.gui.data.SemanticServiceItem;
import de.dfki.owlsmx.gui.data.ServiceItem;
import de.dfki.owlsmx.gui.data.SyntacticServiceItem;
import de.dfki.owlsmx.gui.util.GUIState;
import de.dfki.owlsmx.gui.util.MatchmakerInterface;
import de.dfki.owlsmx.gui.util.UpdateDataListener;
import de.dfki.owlsmx.gui.util.UpdateDataListenerRegistry;
import de.dfki.owlsmx.io.ErrorLog;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.DefaultListModel;

public class TestCollection
implements Serializable,
UpdateDataListenerRegistry,
UpdateDataListener {
    private static final long serialVersionUID = -6345043491596293272L;
    private Map services = new HashMap();
    private Map queries = new HashMap();
    private Map answerset = new HashMap();
    private Map matchmakerAnswerset = new HashMap();
    private Map result = new HashMap();
    private String name = "";
    private String version = "";
    private String comment = "";
    private DefaultListModel serviceDataModel = new DefaultListModel();
    private DefaultListModel queryDataModel = new DefaultListModel();
    private DefaultListModel answersDataModel = new DefaultListModel();
    private Query activeQuery;
    private Set registry = new HashSet();
    private static TestCollection instance = new TestCollection();

    private TestCollection() {
    }

    public static TestCollection getInstance() {
        return instance;
    }

    public void clearTC() {
        this.services = new HashMap();
        this.queries = new HashMap();
        this.answerset = new HashMap();
        this.matchmakerAnswerset = new HashMap();
        this.result = new HashMap();
        this.name = "";
        this.version = "";
        this.comment = "";
        this.serviceDataModel = new DefaultListModel();
        this.queryDataModel = new DefaultListModel();
        this.answersDataModel = new DefaultListModel();
        this.updateData();
    }

    public ServiceItem addService(URI uri) throws FileNotFoundException {
        uri = GUIState.getInstance().replaceString(uri);
        if (this.services.containsKey(uri)) {
            ErrorLog.instanceOf().report("Service " + uri + " is already in the set of registered services");
            return (ServiceItem)this.services.get(uri);
        }
        ServiceItem item = new ServiceItem(uri);
        if (this.services.containsKey(uri = item.getURI())) {
            ErrorLog.instanceOf().report("Service with real URI " + uri + " is already in the set of registered services");
            return (ServiceItem)this.services.get(uri);
        }
        this.services.put(uri, item);
        this.serviceDataModel.addElement(item);
        return item;
    }

    private void removeService(URI uri, boolean update) {
        if (!this.services.containsKey(uri)) {
            ServiceItem item = new ServiceItem(uri);
            uri = item.getURI();
        }
        this.services.remove(uri);
        Iterator iter = this.answerset.keySet().iterator();
        while (iter.hasNext()) {
            this.removeServiceFromAnswerset((URI)iter.next(), uri);
        }
        if (update) {
            this.updateDataModels();
        }
        if (this.activeQuery != null) {
            this.updateAnswerset(this.activeQuery);
        }
    }

    public void removeService(URI uri) {
        this.removeService(uri, true);
    }

    public void removeServices(Object[] services) {
        int i = 0;
        while (i < services.length) {
            this.removeService(((ServiceItem)services[i]).getURI(), false);
            ++i;
        }
        this.updateDataModels();
        if (this.activeQuery != null) {
            this.updateAnswerset(this.activeQuery);
        }
    }

    public void removeServices(Set services) {
        this.removeServices(services.toArray());
    }

    public ServiceItem getService(URI uri) {
        if (!this.services.containsKey(uri)) {
            ServiceItem item = new ServiceItem(uri);
            uri = item.getURI();
        }
        return (ServiceItem)this.services.get(uri);
    }

    public Set getServices() {
        return new HashSet(this.services.values());
    }

    public Query addQuery(URI uri) {
        try {
            uri = GUIState.getInstance().replaceString(uri);
            if (this.queries.containsKey(uri)) {
                return (Query)this.queries.get(uri);
            }
            Query item = new Query(uri);
            if (this.queries.containsKey(item.getURI())) {
                return (Query)this.queries.get(uri);
            }
            this.queries.put(item.getURI(), item);
            this.queryDataModel.addElement(item);
            this.answerset.put(item.getURI(), new TreeSet());
            this.matchmakerAnswerset.put(item.getURI(), new TreeSet());
            return item;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Query(null);
        }
    }

    public void removeQuery(URI uri, boolean update) {
        this.answerset.remove(uri);
        this.matchmakerAnswerset.remove(uri);
        if (!this.queries.containsKey(uri)) {
            Query item = new Query(uri);
            uri = item.getURI();
        }
        this.queries.remove(uri);
        this.answerset.remove(uri);
        this.matchmakerAnswerset.remove(uri);
        if (update) {
            this.updateDataModels();
        }
        if (this.activeQuery != null && this.activeQuery.getURI().equals(uri)) {
            this.updateAnswerset(this.activeQuery);
        }
    }

    public void removeQuery(URI uri) {
        this.removeQuery(uri, true);
    }

    public void removeQueries(Object[] queries) {
        int i = 0;
        while (i < queries.length) {
            this.removeQuery(((Query)queries[i]).getURI(), false);
            ++i;
        }
        this.updateDataModels();
        if (this.activeQuery != null) {
            this.updateAnswerset(this.activeQuery);
        }
    }

    public void removeQueries(Set queries) {
        this.removeQueries(queries.toArray());
    }

    public SortedSet getQueries() {
        return new TreeSet(this.queries.values());
    }

    public void addServiceToAnswerset(URI query, URI service) {
        try {
            URI localQuery = GUIState.getInstance().replaceString(query);
            URI localService = GUIState.getInstance().replaceString(service);
            if (!this.services.containsKey(localService)) {
                ServiceItem item = new ServiceItem(localService);
                GUIState.displayWarning(this.getClass().toString(), "Tried " + item.getURI().toString() + "\n instead of " + localService.toString());
                if (this.services.containsKey(item.getURI())) {
                    localService = item.getURI();
                }
            }
            if (!this.queries.containsKey(localQuery)) {
                Query queryItem = new Query(localQuery);
                GUIState.displayWarning(this.getClass().toString(), "Tried " + queryItem.getURI().toString() + "\n instead of " + localQuery.toString());
                if (this.queries.containsKey(queryItem.getURI())) {
                    localQuery = queryItem.getURI();
                }
            }
            if (!(this.queries.containsKey(localQuery) && this.services.containsKey(localService) && this.answerset.containsKey(localQuery))) {
                GUIState.displayWarning(String.valueOf(this.getClass().toString()) + "-addServiceToAnswerset:", "Didn't add " + localService.toString() + "\n to Answerset of query " + localQuery.toString() + "\n" + "(Query " + this.queries.containsKey(localQuery) + ")" + "(Service " + this.services.containsKey(localQuery) + ")" + "(AnswerQuery " + this.answerset.containsKey(localQuery) + ")");
                return;
            }
            if (((TreeSet)this.answerset.get(query)).contains(service)) {
                return;
            }
            ((TreeSet)this.answerset.get(query)).add(service);
            if (this.activeQuery != null && this.activeQuery.getURI().equals(query)) {
                this.updateAnswerset(this.activeQuery);
            }
        }
        catch (Exception e) {
            GUIState.displayWarning(String.valueOf(this.getClass().toString()) + ": ", e.getMessage());
        }
    }

    public void addServicesToAnswerset(URI query, Object[] services) {
        int i = 0;
        while (i < services.length) {
            try {
                this.addServiceToAnswerset(query, ((ServiceItem)services[i]).getURI());
            }
            catch (Exception e) {
                GUIState.displayWarning(String.valueOf(this.getClass().toString()) + ": " + e.getMessage(), "Didn't add " + services[i].toString() + " to Answerset of query " + query.toString());
            }
            ++i;
        }
    }

    public void addServicesToAnswerset(URI query, Set services) {
        this.addServicesToAnswerset(query, services.toArray());
    }

    public void removeServiceFromAnswerset(URI query, URI service) {
        if (!this.queries.containsKey(query) || !this.answerset.containsKey(query)) {
            return;
        }
        ((TreeSet)this.answerset.get(query)).remove(service);
        if (this.activeQuery != null && this.activeQuery.getURI().equals(query)) {
            this.updateAnswerset(this.activeQuery);
        }
    }

    public void removeServicesFromAnswerset(URI query, Object[] services) {
        int i = 0;
        while (i < services.length) {
            try {
                this.removeServiceFromAnswerset(query, ((ServiceItem)services[i]).getURI());
            }
            catch (Exception e) {
                GUIState.displayWarning(String.valueOf(this.getClass().toString()) + ": " + e.getMessage(), "Didn't add " + services[i].toString() + " to Answerset of query " + query.toString());
            }
            ++i;
        }
    }

    public void removeServicesFromAnswerset(URI query, Set services) {
        this.removeServicesFromAnswerset(query, services.toArray());
    }

    public SortedSet getAnswerset(URI query) {
        URI localQuery = query;
        if (!this.answerset.containsKey(query)) {
            Query item = new Query(localQuery);
            if (this.answerset.containsKey(item.getURI())) {
                localQuery = item.getURI();
            } else {
                return new TreeSet();
            }
        }
        return (TreeSet)this.answerset.get(localQuery);
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public DefaultListModel getServiceDataModel() {
        return this.serviceDataModel;
    }

    public DefaultListModel getQueryDataModel() {
        return this.queryDataModel;
    }

    public DefaultListModel getAnswerSetDataModel() {
        return this.answersDataModel;
    }

    private void updateDataModels() {
        this.serviceDataModel.removeAllElements();
        TreeSet sortedServices = new TreeSet();
        sortedServices.addAll(this.services.values());
        Iterator iter = sortedServices.iterator();
        while (iter.hasNext()) {
            this.serviceDataModel.addElement((ServiceItem)iter.next());
        }
        TreeSet sortedQueries = new TreeSet();
        sortedQueries.addAll(this.queries.values());
        this.queryDataModel.removeAllElements();
        iter = sortedQueries.iterator();
        while (iter.hasNext()) {
            this.queryDataModel.addElement((Query)iter.next());
        }
    }

    public void updateAnswerset(Query query) {
        try {
            this.activeQuery = query;
            SortedSet set = this.getAnswerset(query.getURI());
            Iterator iter = set.iterator();
            this.answersDataModel.removeAllElements();
            while (iter.hasNext()) {
                this.answersDataModel.addElement(TestCollection.getInstance().getService((URI)iter.next()));
            }
        }
        catch (Exception e) {
            GUIState.displayWarning(String.valueOf(this.getClass().toString()) + " | " + "updateAnswerset" + ": ", String.valueOf(e.getClass().toString()) + "\n" + "Problem computing answerset for " + query + "\n" + e.getMessage());
        }
    }

    public void load(String path) throws FileNotFoundException, IOException, ClassNotFoundException {
        ObjectInputStream s = new ObjectInputStream(new FileInputStream(path));
        this.services = (HashMap)s.readObject();
        this.queries = (HashMap)s.readObject();
        this.answerset = (HashMap)s.readObject();
        this.matchmakerAnswerset = (HashMap)s.readObject();
        this.name = (String)s.readObject();
        this.version = (String)s.readObject();
        this.comment = (String)s.readObject();
        TestCollection.getInstance().setName(this.name);
        TestCollection.getInstance().setVersion(this.version);
        TestCollection.getInstance().setComment(this.comment);
        s.close();
        this.updateDataModels();
    }

    public void load(String path, Component comp) {
        try {
            this.load(path);
            GUIState.displayWarning(comp, "Loaded test collection " + this.name, "Loaded " + this.services.size() + " Services\n" + "Loaded " + this.queries.size() + " Requests\n");
        }
        catch (Exception e) {
            GUIState.displayWarning(comp, "Attempted to load test collection", "Couldn't load test collection from path\n" + path + "\n" + e.getMessage());
            e.printStackTrace();
        }
    }

    public void save(String path) {
        try {
            ObjectOutputStream s = new ObjectOutputStream(new FileOutputStream(path));
            s.writeObject(this.services);
            s.writeObject(this.queries);
            s.writeObject(this.answerset);
            s.writeObject(this.matchmakerAnswerset);
            s.writeObject(this.name);
            s.writeObject(this.version);
            s.writeObject(this.comment);
            s.flush();
            s.close();
        }
        catch (Exception e) {
            GUIState.displayWarning(String.valueOf(this.getClass().toString()) + "|save:", String.valueOf(e.getClass().toString()) + "\n" + "Couldn't save file " + path + "\n" + e.getMessage());
            e.printStackTrace();
        }
    }

    public void load() {
        try {
            this.load("testcollection.dat");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void save() {
        this.save("testcollection.dat");
    }

    public boolean runQuery(Query query) {
        return this.runQuery(query, true);
    }

    public boolean runQuery(Query query, boolean updateDatamodel) {
        SortedSet set = new TreeSet();
        if (GUIState.getInstance().getOWLSMXP()) {
            MatchmakerInterface.getInstance().setOWLSMXP(true);
        } else {
            MatchmakerInterface.getInstance().setOWLSMXP(false);
        }
        if (GUIState.getInstance().isIntegrative()) {
            MatchmakerInterface.getInstance().setIntegrative(true);
        } else {
            MatchmakerInterface.getInstance().setIntegrative(false);
        }
        set = MatchmakerInterface.getInstance().matchRequest(query.getURI(), GUIState.getInstance().getMinDegree(), GUIState.getInstance().getTreshold());
        this.result.put(query, set);
        if (updateDatamodel) {
            this.updateData();
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public SortedSet getMatchmakerAnswerset(Query query, int sorting) {
        block4: {
            block3: {
                set = new TreeSet<HybridServiceItem>();
                iter = ((TreeSet)this.result.get(query)).iterator();
                if (sorting != 1) break block3;
                while (iter.hasNext()) {
                    set.add(new SemanticServiceItem((HybridServiceItem)iter.next()));
                }
                break block4;
            }
            if (sorting != 2) ** GOTO lbl18
            while (iter.hasNext()) {
                set.add(new SyntacticServiceItem((HybridServiceItem)iter.next()));
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                set.add((HybridServiceItem)iter.next());
lbl18:
                // 2 sources

                ** while (iter.hasNext())
            }
        }
        return set;
    }

    public Map getMatchmakerAnswerset(int sorting) {
        HashMap<Query, SortedSet> map = new HashMap<Query, SortedSet>();
        Iterator iter = this.result.entrySet().iterator();
        while (iter.hasNext()) {
            Query currentQuery = (Query)iter.next().getKey();
            map.put(currentQuery, this.getMatchmakerAnswerset(currentQuery, sorting));
        }
        return map;
    }

    @Override
    public void registerUpdateDataListener(UpdateDataListener listener) {
        this.registry.add(listener);
    }

    @Override
    public void updateData() {
        this.updateDataModels();
        Iterator iter = this.registry.iterator();
        while (iter.hasNext()) {
            ((UpdateDataListener)iter.next()).updateData();
        }
    }

    public void setServiceProcessed(ServiceItem service, boolean processed) {
        ((ServiceItem)this.services.get(service.getURI())).setProcessed(processed);
    }

    public boolean checkRelevanceSets(Component parent) {
        if (!GUIState.getInstance().getPrecisionRecall()) {
            return true;
        }
        for (Query check : this.queries.values()) {
            if (this.getAnswerset(check.getURI()).size() > 0) continue;
            GUIState.displayWarning(parent, "Empty Answerset", "The relevance set of service request " + check.getName() + " is empty.\n" + "Please define a relevance set for recall/precision measurement.");
            return false;
        }
        return true;
    }

    public boolean checkQueriesAndServicesSets(Component parent) {
        if (this.services.isEmpty() || this.services.size() <= 0) {
            GUIState.displayWarning(parent, "Test collection incomplete", "There were no services found in the test collection. Please add some.");
            return false;
        }
        if (this.queries.isEmpty() || this.queries.size() <= 0) {
            GUIState.displayWarning(parent, "Test collection incomplete", "There were no service requests found in the test collection. Please add some.");
            return false;
        }
        return this.checkRelevanceSets(parent);
    }

    public static void main(String[] args) {
        TestCollection tc = TestCollection.getInstance();
        String servicesPath = String.valueOf(args[0]) + File.separator + "services" + File.separator + "1.1";
        String queriesPath = String.valueOf(args[0]) + File.separator + "queries" + File.separator + "1.1";
        String rsPath = String.valueOf(args[0]) + File.separator + "relevance_sets";
        File services = new File(servicesPath);
        HashMap<String, URI> localServiceNames = new HashMap<String, URI>();
        File[] fileArray = services.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File service = fileArray[n2];
            if (service.isFile()) {
                try {
                    tc.addService(service.toURI());
                    localServiceNames.put(service.getName(), service.toURI());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        File queries = new File(queriesPath);
        HashMap<String, URI> localQueryNames = new HashMap<String, URI>();
        File[] fileArray2 = queries.listFiles();
        int n3 = fileArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            File query = fileArray2[n4];
            if (query.isFile()) {
                try {
                    tc.addQuery(query.toURI());
                    localQueryNames.put(query.getName(), query.toURI());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++n4;
        }
        File rSets = new File(rsPath);
        File[] fileArray3 = rSets.listFiles();
        int n5 = fileArray3.length;
        n3 = 0;
        while (n3 < n5) {
            File rs = fileArray3[n3];
            if (rs.isDirectory()) {
                String localName = rs.getName().split("-")[1];
                File[] fileArray4 = rs.listFiles();
                int n6 = fileArray4.length;
                int n7 = 0;
                while (n7 < n6) {
                    File rFile = fileArray4[n7];
                    tc.addServiceToAnswerset((URI)localQueryNames.get(localName), (URI)localServiceNames.get(rFile.getName()));
                    ++n7;
                }
            }
            ++n3;
        }
        tc.save(args[1]);
    }
}

