/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.owlsmx.gui.util;

import de.dfki.owlsmx.gui.data.TaskContent;
import de.dfki.owlsmx.gui.data.TestCollection;
import de.dfki.owlsmx.io.ErrorLog;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;

public class GUIState
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static GUIState instance = new GUIState();
    private String pathToServices = "";
    private String pathToQueries = "";
    private String pathToTestCollection = "";
    private double treshold = 0.8;
    private int minDegree = 4;
    private short simMeasure = 1;
    private boolean displayAnswerset = true;
    private boolean getAQR = false;
    private boolean getMemoryConsumption = false;
    private boolean getPrecisionRecall = false;
    private Map wizardContent = new HashMap();
    private int currentTask = -1;
    private int currentStep = 1;
    private boolean addImmediately = false;
    private String replaceWith = "";
    private String replaceFrom = "";
    private boolean useReplaceWith = false;
    public static boolean debug = false;
    public static final String logoPath = "/images/owlsMX1_small_rectangle.jpg";
    public static final String version = "2.0";
    private boolean owlsmxp = false;
    private boolean integrative = false;
    public static final int SORT_HYBRID = 0;
    public static final int SORT_SEMANTIC = 1;
    public static final int SORT_SYNTACTIC = 2;
    public static final int NO_TASK = -1;
    public static final int QUERY_TASK = 0;
    public static final int CREATE_TC_TASK = 1;
    public static final int RUN_TEST_TASK = 2;
    public static final int OTHER_TASK = 4;
    private int sorting = 0;

    public static GUIState getInstance() {
        if (instance != null) {
            return instance;
        }
        return new GUIState();
    }

    private GUIState() {
        this.loadWizardContent();
    }

    public int setCurrentStep() {
        return this.currentStep;
    }

    public void setCurrentStep(int step) {
        this.currentStep = step;
    }

    public int getCurrentTask() {
        return this.currentTask;
    }

    public void setCurrentTask(int task) {
        this.currentTask = task;
    }

    public boolean getDisplayAnswerSet() {
        return this.displayAnswerset;
    }

    public void setDisplayAnswerSet(boolean state) {
        this.displayAnswerset = state;
    }

    public boolean getDisplayAQR() {
        return this.getAQR;
    }

    public void setDisplayAQR(boolean state) {
        this.getAQR = state;
    }

    public boolean getMemoryConsumption() {
        return this.getMemoryConsumption;
    }

    public void setMemoryConsumption(boolean state) {
        this.getMemoryConsumption = state;
    }

    public boolean getPrecisionRecall() {
        return this.getPrecisionRecall;
    }

    public void setPrecisionRecall(boolean state) {
        this.getPrecisionRecall = state;
    }

    public void setMeasures(int minDegree, short simMeasure, double treshold) {
        this.minDegree = minDegree;
        this.simMeasure = simMeasure;
        this.treshold = treshold;
    }

    public double getTreshold() {
        return this.treshold;
    }

    public int getMinDegree() {
        return this.minDegree;
    }

    public short getSimilarityMeasure() {
        return this.simMeasure;
    }

    public void setPathToServices(String pathToServices) {
        this.pathToServices = pathToServices;
    }

    public String getPathToServices() {
        return this.pathToServices;
    }

    public void setPathToQueries(String pathToQueries) {
        this.pathToQueries = pathToQueries;
    }

    public String getPathToQueries() {
        return this.pathToQueries;
    }

    public void setPathToTestCollection(String pathToTestCollection) {
        this.pathToTestCollection = pathToTestCollection;
    }

    public String getPathToTestCollection() {
        return this.pathToTestCollection;
    }

    public static void load(String path) {
        try {
            ObjectInputStream s = new ObjectInputStream(new FileInputStream(path));
            GUIState state = (GUIState)s.readObject();
        }
        catch (FileNotFoundException e) {
            GUIState.displayWarning("TestCollection: " + e.getClass().toString(), e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            GUIState.displayWarning("TestCollection: " + e.getClass().toString(), e.getMessage());
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            GUIState.displayWarning("TestCollection: " + e.getClass().toString(), e.getMessage());
            e.printStackTrace();
        }
    }

    public static void save(String path) {
        try {
            ObjectOutputStream s = new ObjectOutputStream(new FileOutputStream(path));
            s.writeObject(GUIState.getInstance());
            s.flush();
        }
        catch (Exception e) {
            GUIState.displayWarning("GUIState|save:", String.valueOf(e.getClass().toString()) + "\n" + "Couldn't save file " + path + "\n" + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void load() {
        GUIState.load("guistate.conf");
    }

    public static void save() {
        GUIState.save("guistate.conf");
    }

    public static void main(String[] args) throws FileNotFoundException, IOException, ClassNotFoundException, URISyntaxException {
        GUIState.generateDummyData();
    }

    public static void displayWarning(String headline, String message) {
        JOptionPane.showMessageDialog(null, message, headline, 2);
    }

    public static void displayWarning(Component comp, String headline, String message) {
        JOptionPane.showMessageDialog(comp, message, headline, 2);
    }

    public static void generateDummyData() {
        try {
            System.out.println("Loading dummy data to TestCollection:");
            URI query1 = new URI("http://127.0.0.1/queries/1.1/1personbicyclecar_price_service.owls");
            URI query2 = new URI("http://127.0.0.1/queries/1.1/book_price_service.owls");
            TestCollection.getInstance().addQuery(query1);
            System.out.println("--------------------------------------");
            TestCollection.getInstance().addQuery(query2);
            TestCollection.getInstance().addService(new URI("http://127.0.0.1/services/1.1/_3WheeledAudiCarprice_service.owls"));
            TestCollection.getInstance().addService(new URI("http://127.0.0.1/services/1.1/__destination_MyOfficeservice.owls"));
            TestCollection.getInstance().addService(new URI("http://127.0.0.1/services/1.1/__luxuryhotel_Heidelburgservice.owls"));
            TestCollection.getInstance().addService(new URI("http://127.0.0.1/services/1.1/_aps-slrpricereport_Musuemservice.owls"));
            TestCollection.getInstance().addService(new URI("http://127.0.0.1/services/1.1/_author_CompJservice.owls"));
            TestCollection.getInstance().addService(new URI("http://127.0.0.1/services/1.1/_author_DMservice.owls"));
            TestCollection.getInstance().addServiceToAnswerset(query1, new URI("http://127.0.0.1/services/1.1/_3WheeledAudiCarprice_service.owls"));
            TestCollection.getInstance().addServiceToAnswerset(query1, new URI("http://127.0.0.1/services/1.1/__destination_MyOfficeservice.owls"));
            TestCollection.getInstance().addServiceToAnswerset(query1, new URI("http://127.0.0.1/services/1.1/__luxuryhotel_Heidelburgservice.owls"));
            TestCollection.getInstance().addServiceToAnswerset(query2, new URI("http://127.0.0.1/services/1.1/_aps-slrpricereport_Musuemservice.owls"));
            TestCollection.getInstance().addServiceToAnswerset(query2, new URI("http://127.0.0.1/services/1.1/_author_CompJservice.owls"));
            TestCollection.getInstance().addServiceToAnswerset(query2, new URI("http://127.0.0.1/services/1.1/_author_DMservice.owls"));
            System.out.println("Before:");
            System.out.println("Services     : " + TestCollection.getInstance().getServices().size());
            System.out.println("Requests      : " + TestCollection.getInstance().getQueries().size());
            System.out.println("Answerset 1  : " + TestCollection.getInstance().getAnswerset(query1).size());
            System.out.println("Answerset 2  : " + TestCollection.getInstance().getAnswerset(query2).size());
            System.out.println("--------------------------------------");
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public TaskContent getStepContent(int task, int step) throws Exception {
        TaskContent[] content = (TaskContent[])this.wizardContent.get(new Integer(task));
        if (content == null) {
            throw new Exception("No content loaded for wizard");
        }
        if (content[step - 1] == null) {
            throw new Exception("No content for step " + (step - 1) + ", is there is content for  step+1 " + (content[step] == null));
        }
        if (step > content.length || step - 1 < 0) {
            throw new Exception("Wizard step " + step + " of task " + task + " does not exist.\n");
        }
        return content[step - 1];
    }

    public TaskContent getCurrentStepContent() throws Exception {
        return this.getStepContent(this.currentTask, this.currentStep);
    }

    private void processLine(String line, Map wizardContent) {
        TaskContent contentItem = new TaskContent(line);
        TaskContent[] tasks = wizardContent.containsKey(contentItem.task) ? (TaskContent[])wizardContent.get(contentItem.task) : new TaskContent[contentItem.totalSteps];
        if (contentItem.step - 1 < tasks.length && contentItem.step - 1 >= 0) {
            tasks[contentItem.step - 1] = contentItem;
        } else {
            GUIState.displayWarning(String.valueOf(this.getClass().toString()) + "|processLine", "Current step does not fit in range: 0 > " + (contentItem.step - 1) + " >" + tasks.length);
        }
        wizardContent.put(contentItem.task, tasks);
    }

    public boolean hasNextStep() {
        try {
            TaskContent[] taskContent = (TaskContent[])this.wizardContent.get(new Integer(this.currentTask));
            TaskContent content = this.getStepContent(this.currentTask, this.currentStep);
            return this.currentStep < taskContent.length && this.currentStep < content.totalSteps && taskContent[this.currentStep] != null;
        }
        catch (Exception e) {
            GUIState.displayWarning(String.valueOf(this.getClass().toString()) + "|setNextStep:", String.valueOf(e.getClass().toString()) + "\n" + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public void setNextStep() {
        try {
            TaskContent content = this.getStepContent(this.currentTask, this.currentStep);
            if (this.hasNextStep()) {
                ++this.currentStep;
            } else {
                GUIState.displayWarning(String.valueOf(this.getClass().toString()) + "|setNextStep:", "No next step: " + this.currentStep + "<" + content.totalSteps);
            }
            TestCollection.getInstance().updateData();
        }
        catch (Exception e) {
            GUIState.displayWarning(String.valueOf(this.getClass().toString()) + "|setNextStep:", String.valueOf(e.getClass().toString()) + "\n" + e.getMessage());
            e.printStackTrace();
        }
    }

    public boolean hasLastStep() {
        TaskContent[] taskContent = (TaskContent[])this.wizardContent.get(new Integer(this.currentTask));
        return this.currentStep > 1 && taskContent[this.currentStep - 2] != null;
    }

    public void setLastStep() {
        try {
            if (this.hasLastStep()) {
                --this.currentStep;
            } else {
                GUIState.displayWarning(String.valueOf(this.getClass().toString()) + "|setLastStep:", "No last step current step is " + this.currentStep);
            }
            TestCollection.getInstance().updateData();
        }
        catch (Exception e) {
            GUIState.displayWarning(String.valueOf(this.getClass().toString()) + "|setNextStep:", String.valueOf(e.getClass().toString()) + "\n" + e.getMessage());
            e.printStackTrace();
        }
    }

    private void loadWizardContent() {
        try {
            String line;
            HashMap wizardContent = new HashMap();
            BufferedReader reader = new BufferedReader(new FileReader(new File(this.getClass().getResource("/data/wizard.dat").getFile())));
            while ((line = reader.readLine()) != null) {
                this.processLine(line, wizardContent);
            }
            this.wizardContent = wizardContent;
            this.setCurrentTask(-1);
            this.setCurrentStep(1);
        }
        catch (FileNotFoundException wizardContent) {
        }
        catch (IOException e) {
            ErrorLog.instanceOf().report(String.valueOf(this.getClass().toString()) + e.getMessage());
        }
        catch (Exception e) {
            ErrorLog.instanceOf().report(String.valueOf(this.getClass().toString()) + e.getMessage());
        }
    }

    public boolean isAddImmediately() {
        return this.addImmediately;
    }

    public void setAddImmediately(boolean addImmediately) {
        this.addImmediately = addImmediately;
    }

    public String getReplaceFrom() {
        return this.replaceFrom;
    }

    public void setReplaceFrom(String replaceFrom, String replaceWith) {
        if (!this.useReplaceWith) {
            return;
        }
        this.replaceFrom = replaceFrom;
        this.replaceWith = replaceWith;
    }

    public String getReplaceWith() {
        return this.replaceWith;
    }

    public boolean isUseReplaceWith() {
        return this.replaceFrom != null && this.replaceWith != null && this.useReplaceWith && !this.replaceFrom.equals("") && !this.replaceWith.equals("");
    }

    public void setUseReplaceWith(boolean useReplaceWith) {
        this.useReplaceWith = useReplaceWith;
    }

    public URI replaceString(URI uri) {
        if (!this.isUseReplaceWith()) {
            return uri;
        }
        try {
            URI testURI = new URI(uri.toString().replaceAll(GUIState.getInstance().getReplaceFrom(), GUIState.getInstance().getReplaceWith()));
            return testURI;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return uri;
        }
    }

    public void setSorting(int sort) {
        this.sorting = sort;
    }

    public int getSorting() {
        return this.sorting;
    }

    public void setOWLSMXP(boolean value) {
        this.owlsmxp = value;
    }

    public boolean getOWLSMXP() {
        return this.owlsmxp;
    }

    public boolean isIntegrative() {
        return this.integrative;
    }

    public void setIntegrative(boolean integrative) {
        this.integrative = integrative;
    }
}

