/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.owlsmx.gui.util;

import de.dfki.owlsmx.SimilarityMatchingEngine;
import de.dfki.owlsmx.data.MatchedService;
import de.dfki.owlsmx.exceptions.MatchingException;
import de.dfki.owlsmx.gui.data.HybridServiceItem;
import de.dfki.owlsmx.gui.data.ServiceItem;
import de.dfki.owlsmx.gui.data.TestCollection;
import de.dfki.owlsmx.gui.util.GUIState;
import de.dfki.owlsmx.io.ErrorLog;
import de.dfki.owlsmx.similaritymeasures.ConstraintSimilarity;
import de.dfki.owlsmx.similaritymeasures.CosineSimilarity;
import de.dfki.owlsmx.similaritymeasures.ExtendedJaccardMeasure;
import de.dfki.owlsmx.similaritymeasures.JensenShannonMeasure;
import java.net.URI;
import java.util.SortedSet;
import java.util.TreeSet;
import org.mindswap.owl.OWLFactory;
import org.mindswap.owl.OWLKnowledgeBase;
import org.mindswap.owl.OWLOntology;

public class MatchmakerInterface {
    private boolean owlsmxp = false;
    private boolean integrative = false;
    private SimilarityMatchingEngine matcher = null;
    private static MatchmakerInterface _instance = new MatchmakerInterface();
    private boolean ranMatchmaker = false;

    private String getSimType(int type) {
        switch (type) {
            case 2: {
                return "OWLS M3: Cosine";
            }
            case 1: {
                return "OWLS M3: exJ";
            }
            case 3: {
                return "OWLS M3: Jensen Shannon";
            }
            case 0: {
                return "OWLS M3: LOI";
            }
        }
        return "OWLS M0: Semantic";
    }

    public static MatchmakerInterface getInstance() {
        return _instance;
    }

    public void createMatchmaker() {
        short type = GUIState.getInstance().getSimilarityMeasure();
        ErrorLog.debug("Similarity measure: " + this.getSimType(type));
        switch (type) {
            case 2: {
                this.matcher = new SimilarityMatchingEngine(new CosineSimilarity());
                break;
            }
            case 1: {
                this.matcher = new SimilarityMatchingEngine(new ExtendedJaccardMeasure());
                break;
            }
            case 3: {
                this.matcher = new SimilarityMatchingEngine(new JensenShannonMeasure());
                break;
            }
            case 0: {
                this.matcher = new SimilarityMatchingEngine(new ConstraintSimilarity());
                break;
            }
            default: {
                this.matcher = new SimilarityMatchingEngine(null);
            }
        }
        this.matcher.clear();
    }

    public SortedSet matchRequest(URI profileURI, int minimumDegreeOfMatch, double treshold) {
        try {
            SortedSet result;
            ErrorLog.debug("Matching request: " + profileURI);
            ErrorLog.debug("Minimum DOM: " + minimumDegreeOfMatch);
            ErrorLog.debug("Similarity treshold: " + treshold);
            this.matcher.setIntegrative(this.integrative);
            this.ranMatchmaker = true;
            SortedSet tmpResult = this.matcher.matchRequest(profileURI, GUIState.getInstance().getMinDegree(), GUIState.getInstance().getTreshold());
            if (this.owlsmxp) {
                try {
                    OWLKnowledgeBase kb = OWLFactory.createKB();
                    OWLOntology request = kb.read(profileURI);
                    SortedSet filteredResult = SimilarityMatchingEngine.useOWLSMXPFilter(tmpResult, request);
                    for (MatchedService matchedService : filteredResult) {
                    }
                    result = this.MatchmakerToGUISet(tmpResult, filteredResult);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.matcher = null;
                    return new TreeSet();
                }
            } else {
                result = this.MatchmakerToGUISet(tmpResult);
            }
            ErrorLog.debug("Resultat:\n   " + tmpResult);
            return result;
        }
        catch (MatchingException e) {
            e.printStackTrace();
            this.matcher = null;
            return new TreeSet();
        }
    }

    public void addService(URI profileURI) {
        try {
            if (this.matcher == null) {
                ErrorLog.debug(String.valueOf(this.getClass().toString()) + ": Reset machmaker");
                this.createMatchmaker();
            }
            ErrorLog.debug(String.valueOf(this.getClass().toString()) + ": Adding service: " + profileURI.toString());
            this.matcher.addService(profileURI);
        }
        catch (Exception e) {
            GUIState.displayWarning("Matchmaker", "Couldn't add service " + profileURI + " either file not found or not an valid OWL-S 1.1 file.");
        }
    }

    private SortedSet MatchmakerToGUISet(SortedSet result) {
        TreeSet<HybridServiceItem> hybrid = new TreeSet<HybridServiceItem>();
        if (result == null) {
            GUIState.displayWarning("Matchmaker", "Result set is empty");
            return hybrid;
        }
        for (MatchedService m_result : result) {
            ServiceItem s_item = TestCollection.getInstance().getService(m_result.serviceURI);
            HybridServiceItem h_result = new HybridServiceItem(s_item);
            h_result.setDegreeOfMatch(m_result.degreeOfMatch);
            h_result.setSyntacticSimilarity(m_result.similarity);
            hybrid.add(h_result);
        }
        return hybrid;
    }

    private SortedSet MatchmakerToGUISet(SortedSet results, SortedSet compatibleResults) {
        TreeSet<HybridServiceItem> hybrid = new TreeSet<HybridServiceItem>();
        if (results == null) {
            GUIState.displayWarning("Matchmaker", "Result set is empty");
            return hybrid;
        }
        for (MatchedService m_result : results) {
            ServiceItem s_item = TestCollection.getInstance().getService(m_result.serviceURI);
            HybridServiceItem h_result = new HybridServiceItem(s_item);
            h_result.setDegreeOfMatch(m_result.degreeOfMatch);
            h_result.setSyntacticSimilarity(m_result.similarity);
            h_result.setDataTypeCompatible(compatibleResults.contains(m_result));
            hybrid.add(h_result);
        }
        return hybrid;
    }

    public void clear() {
        this.matcher.clear();
        this.matcher = null;
        ErrorLog.debug(String.valueOf(this.getClass().toString()) + ": Reset machmaker");
    }

    public boolean didRun() {
        return this.ranMatchmaker;
    }

    public void setOWLSMXP(boolean value) {
        this.owlsmxp = value;
    }

    public void setIntegrative(boolean value) {
        this.integrative = value;
    }
}

