/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.owlsmx.gui.util.tasks;

import de.dfki.owlsmx.analysis.MemoryContainer;
import de.dfki.owlsmx.gui.data.Query;
import de.dfki.owlsmx.gui.data.ServiceItem;
import de.dfki.owlsmx.gui.data.TestCollection;
import de.dfki.owlsmx.gui.util.GUIState;
import de.dfki.owlsmx.gui.util.SwingWorker;
import de.dfki.owlsmx.io.ErrorLog;
import java.io.File;
import java.io.FileNotFoundException;

public class AddServiceToRelevanceset {
    private int lengthOfTask;
    private int current = 0;
    private boolean done = false;
    private boolean canceled = false;
    private Query query;
    File[] files;

    public AddServiceToRelevanceset(File[] files, Query query) {
        if (files == null) {
            return;
        }
        this.lengthOfTask = files.length - 1;
        this.query = query;
        this.files = files;
    }

    public void go() {
        MemoryContainer.getInstance().setGUIMemory();
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                AddServiceToRelevanceset.this.current = 0;
                AddServiceToRelevanceset.this.done = false;
                AddServiceToRelevanceset.this.canceled = false;
                return new ActualTask(AddServiceToRelevanceset.this.files, AddServiceToRelevanceset.this.query);
            }
        };
        worker.start();
    }

    public int getLengthOfTask() {
        return this.lengthOfTask;
    }

    public int getCurrent() {
        return this.current;
    }

    public void stop() {
        this.canceled = true;
    }

    public boolean isDone() {
        return this.done;
    }

    public String getMessage() {
        return "Processing service " + this.current + "/" + this.lengthOfTask;
    }

    class ActualTask {
        ActualTask(File[] files, Query query) {
            while (!AddServiceToRelevanceset.this.canceled && !AddServiceToRelevanceset.this.done) {
                int i = 0;
                while (i < files.length) {
                    AddServiceToRelevanceset.this.current = i;
                    if (files[i].isFile() && (files[i].getAbsolutePath().endsWith(".owl") || files[i].getAbsolutePath().endsWith(".owls"))) {
                        try {
                            ServiceItem tmpService = TestCollection.getInstance().addService(files[i].toURI());
                            if (query == null) {
                                ErrorLog.instanceOf().report("Query was empty and I don't know why");
                            }
                            if (tmpService == null) {
                                ErrorLog.instanceOf().report("Service was not found for file" + files[i] + " and query " + query);
                            }
                            TestCollection.getInstance().addServiceToAnswerset(query.getURI(), tmpService.getURI());
                            if (AddServiceToRelevanceset.this.canceled) {
                                break;
                            }
                        }
                        catch (FileNotFoundException e) {
                            GUIState.displayWarning(e.getClass().toString(), e.getMessage());
                            e.printStackTrace();
                        }
                    }
                    ++i;
                }
                AddServiceToRelevanceset.this.done = true;
            }
        }
    }
}

