/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.owlsmx.gui.util.tasks;

import de.dfki.owlsmx.analysis.MemoryContainer;
import de.dfki.owlsmx.analysis.PassedTimeContainer;
import de.dfki.owlsmx.gui.data.ServiceItem;
import de.dfki.owlsmx.gui.data.TestCollection;
import de.dfki.owlsmx.gui.util.GUIState;
import de.dfki.owlsmx.gui.util.MatchmakerInterface;
import de.dfki.owlsmx.gui.util.SwingWorker;
import de.dfki.owlsmx.io.ErrorLog;
import java.util.Set;

public class AddServicesToMatchmakerTask {
    private int lengthOfTask;
    private int current = 0;
    private boolean done = false;
    private boolean canceled = false;
    private Set services = TestCollection.getInstance().getServices();

    public AddServicesToMatchmakerTask() {
        this.lengthOfTask = this.services.size();
    }

    public void go() {
        MemoryContainer.getInstance().clear();
        MemoryContainer.getInstance().setGUIMemory();
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                AddServicesToMatchmakerTask.this.current = 1;
                AddServicesToMatchmakerTask.this.done = false;
                AddServicesToMatchmakerTask.this.canceled = false;
                return new ActualTask(AddServicesToMatchmakerTask.this.services);
            }
        };
        worker.start();
    }

    public int getLengthOfTask() {
        return this.lengthOfTask;
    }

    public int getCurrent() {
        return this.current;
    }

    public void stop() {
        this.canceled = true;
    }

    public boolean isDone() {
        return this.done;
    }

    public String getMessage() {
        return "Processing service " + this.current + "/" + this.lengthOfTask + ".";
    }

    class ActualTask {
        ActualTask(Set services) {
            MatchmakerInterface.getInstance().createMatchmaker();
            PassedTimeContainer.getInstance().setStartTime();
            ErrorLog.debug(String.valueOf(this.getClass().toString()) + "Services to add: " + services.size());
            for (ServiceItem service : services) {
                ErrorLog.debug(String.valueOf(this.getClass().toString()) + ": Adding service: " + service.getURI().toString());
                MatchmakerInterface.getInstance().addService(service.getURI());
                if (GUIState.getInstance().getMemoryConsumption()) {
                    MemoryContainer.getInstance().addState(AddServicesToMatchmakerTask.this.current);
                }
                if (AddServicesToMatchmakerTask.this.canceled) break;
                AddServicesToMatchmakerTask addServicesToMatchmakerTask2 = AddServicesToMatchmakerTask.this;
                addServicesToMatchmakerTask2.current = addServicesToMatchmakerTask2.current + 1;
            }
            AddServicesToMatchmakerTask.this.done = true;
            AddServicesToMatchmakerTask.this.current = AddServicesToMatchmakerTask.this.lengthOfTask;
            MemoryContainer.getInstance().addState(AddServicesToMatchmakerTask.this.lengthOfTask);
        }
    }
}

