/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.owlsmx.gui.util.tasks;

import de.dfki.owlsmx.analysis.PassedTimeContainer;
import de.dfki.owlsmx.gui.data.Query;
import de.dfki.owlsmx.gui.data.TestCollection;
import de.dfki.owlsmx.gui.util.GUIState;
import de.dfki.owlsmx.gui.util.SwingWorker;
import java.util.SortedSet;

public class RunQueriesTask {
    private int lengthOfTask;
    private int current = 1;
    private boolean done = false;
    private boolean canceled = false;
    private SortedSet queries = TestCollection.getInstance().getQueries();
    private boolean isRunning = false;

    public RunQueriesTask() {
        this.lengthOfTask = this.queries.size();
    }

    public void go() {
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                RunQueriesTask.this.current = 1;
                RunQueriesTask.this.done = false;
                RunQueriesTask.this.canceled = false;
                return new ActualTask(RunQueriesTask.this.queries);
            }
        };
        this.isRunning = true;
        worker.start();
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public int getLengthOfTask() {
        return this.lengthOfTask;
    }

    public int getCurrent() {
        return this.current;
    }

    public void stop() {
        this.canceled = true;
    }

    public boolean isDone() {
        return this.done;
    }

    public String getMessage() {
        return "Processing request " + this.current + "/" + this.lengthOfTask + ".";
    }

    class ActualTask {
        ActualTask(SortedSet queries) {
            PassedTimeContainer.getInstance().clear();
            PassedTimeContainer.getInstance().setStartTime();
            int processed = 0;
            for (Query query : queries) {
                if (!query.isProcessed()) {
                    TestCollection.getInstance().runQuery(query);
                    ++processed;
                    if (GUIState.getInstance().getDisplayAQR()) {
                        PassedTimeContainer.getInstance().addState(RunQueriesTask.this.current);
                    }
                }
                if (RunQueriesTask.this.canceled) break;
                RunQueriesTask runQueriesTask2 = RunQueriesTask.this;
                runQueriesTask2.current = runQueriesTask2.current + 1;
            }
            RunQueriesTask.this.done = true;
            RunQueriesTask.this.current = RunQueriesTask.this.lengthOfTask;
        }
    }
}

