/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.owlsmx.jade;

import de.dfki.owlsmx.jade.behaviours.request.RequestAddServicesBehaviour;
import de.dfki.owlsmx.jade.behaviours.request.RequestClearBehaviour;
import de.dfki.owlsmx.jade.behaviours.request.RequestMatchBehaviour;
import de.dfki.owlsmx.jade.behaviours.request.RequestRemoveServicesBehaviour;
import de.dfki.owlsmx.jade.behaviours.request.RequestSendStatusBehaviour;
import de.dfki.owlsmx.jade.ontology.MatchmakerOntology;
import jade.content.lang.Codec;
import jade.content.lang.sl.SLCodec;
import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.CyclicBehaviour;
import jade.lang.acl.ACLMessage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class TestRequesterAgent
extends Agent {
    public void setup() {
        this.getContentManager().registerLanguage((Codec)new SLCodec(), "fipa-sl0");
        this.getContentManager().registerOntology(MatchmakerOntology.getInstance());
        Object[] args = this.getArguments();
        if (args.length < 1 || !(args[0] instanceof String)) {
            this.doDelete();
        }
        final AID matchmakerAgent = new AID((String)args[0], true);
        System.out.println(args[0]);
        final BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("commands:");
        System.out.println("  clear");
        System.out.println("  addservices [service uri's]");
        System.out.println("  removeservices [service uri's]");
        System.out.println("  match [service uri] [M0-M4] [degree of match] [syntactic similarity] [sorting type]");
        System.out.println("  sendstatus");
        this.addBehaviour((Behaviour)new CyclicBehaviour(this){

            public void action() {
                block40: {
                    String line = null;
                    try {
                        if (!reader.ready() || (line = reader.readLine()) == null) break block40;
                        StringTokenizer tokenizer = new StringTokenizer(line, " ,;");
                        tokenizer.nextToken();
                        if (line.startsWith("clear")) {
                            System.out.println("starting clear request behaviour...");
                            this.myAgent.addBehaviour((Behaviour)new RequestClearBehaviour(this.myAgent, matchmakerAgent){

                                @Override
                                protected void handleAgree(ACLMessage agree) {
                                    System.out.println("matchmaker agent agreed to clear request.");
                                }

                                @Override
                                protected void handleInform(ACLMessage inform) {
                                    System.out.println("matchmaker agent cleared his service registry.");
                                }

                                @Override
                                protected void handleFailure(ACLMessage failure) {
                                    System.err.println("error: matchmaker agent sent failure message!");
                                }
                            });
                            return;
                        }
                        if (line.startsWith("addservices")) {
                            TreeSet<String> services = new TreeSet<String>();
                            while (tokenizer.hasMoreTokens()) {
                                services.add(tokenizer.nextToken());
                            }
                            if (services.isEmpty()) {
                                System.err.println("error: no services specified!");
                                return;
                            }
                            this.myAgent.addBehaviour((Behaviour)new RequestAddServicesBehaviour(this.myAgent, matchmakerAgent, services){

                                @Override
                                protected void handleAgree(ACLMessage agree) {
                                    System.out.println("matchmaker agent agreed to add services.");
                                }

                                @Override
                                protected void handleInform(ACLMessage inform) {
                                    System.out.println("matchmaker agent successfully executed the add services request.");
                                }

                                @Override
                                protected void handleFailure(ACLMessage failure) {
                                    System.err.println("error: matchmaker agent sent failure message!");
                                }
                            });
                            return;
                        }
                        if (line.startsWith("removeservices")) {
                            TreeSet<String> services = new TreeSet<String>();
                            while (tokenizer.hasMoreTokens()) {
                                services.add(tokenizer.nextToken());
                            }
                            if (services.isEmpty()) {
                                System.err.println("error: no services specified!");
                                return;
                            }
                            this.myAgent.addBehaviour((Behaviour)new RequestRemoveServicesBehaviour(this.myAgent, matchmakerAgent, services){

                                @Override
                                protected void handleAgree(ACLMessage agree) {
                                    System.out.println("matchmaker agent agreed to remove services.");
                                }

                                @Override
                                protected void handleInform(ACLMessage inform) {
                                    System.out.println("matchmaker agent successfully executed the remove serivces request.");
                                }

                                @Override
                                protected void handleFailure(ACLMessage failure) {
                                    System.err.println("error: matchmaker agent sent failure message!");
                                }
                            });
                            return;
                        }
                        if (line.startsWith("match")) {
                            int sortingType;
                            int minimumDOM;
                            int variant;
                            URI serviceURI;
                            if (tokenizer.countTokens() != 5) {
                                System.err.println("error: invalid number of parameters!");
                                return;
                            }
                            String token = tokenizer.nextToken();
                            try {
                                serviceURI = new URI(token);
                            }
                            catch (URISyntaxException e) {
                                System.err.println("error: \"" + token + "\" is not a valid URI!");
                                return;
                            }
                            token = tokenizer.nextToken();
                            if (token.equals("M0")) {
                                variant = -1;
                            } else if (token.equals("M1")) {
                                variant = 0;
                            } else if (token.equals("M2")) {
                                variant = 1;
                            } else if (token.equals("M3")) {
                                variant = 2;
                            } else if (token.equals("M4")) {
                                variant = 3;
                            } else {
                                System.err.println("error: invalid OWLS-MX variant!");
                                return;
                            }
                            token = tokenizer.nextToken();
                            if (token.equals("EXACT")) {
                                minimumDOM = 0;
                            } else if (token.equals("PLUGIN")) {
                                minimumDOM = 1;
                            } else if (token.equals("SUBSUMES")) {
                                minimumDOM = 2;
                            } else if (token.equals("SUBSUMED_BY")) {
                                minimumDOM = 3;
                            } else if (token.equals("NEAREST_NEIGHBOUR")) {
                                minimumDOM = 4;
                            } else {
                                System.err.println("error: invalid minimum degree of match!");
                                return;
                            }
                            double minimumSIM = new Double(tokenizer.nextToken());
                            token = tokenizer.nextToken();
                            if (token.equals("SEMANTIC")) {
                                sortingType = 1;
                            } else if (token.equals("SYNTACTIC")) {
                                sortingType = 2;
                            } else if (token.equals("HYBRID")) {
                                sortingType = 0;
                            } else {
                                System.err.println("error: invalid sorting type!");
                                return;
                            }
                            this.myAgent.addBehaviour((Behaviour)new RequestMatchBehaviour(this.myAgent, matchmakerAgent, serviceURI, variant, minimumDOM, minimumSIM, sortingType){

                                @Override
                                protected void handleAgree(ACLMessage agree) {
                                    System.out.println("matchmaker agent agreed to the matching request.");
                                }

                                @Override
                                protected void handleInform(ACLMessage inform) {
                                    System.out.println("matchmaker agent successfully executed the matching request:");
                                    System.out.println(inform.getContent());
                                }

                                @Override
                                protected void handleFailure(ACLMessage failure) {
                                    System.err.println("error: matchmaker agent sent failure message!");
                                }
                            });
                            return;
                        }
                        if (line.startsWith("sendstatus")) {
                            System.out.println("starting sendstatus request behaviour...");
                            this.myAgent.addBehaviour((Behaviour)new RequestSendStatusBehaviour(this.myAgent, matchmakerAgent){

                                @Override
                                protected void handleAgree(ACLMessage agree) {
                                    System.out.println("matchmaker agent agreed to sendstatus request.");
                                }

                                @Override
                                protected void handleInform(ACLMessage inform) {
                                    System.out.println("matchmaker agent successfully sent his status:");
                                    System.out.println(inform.getContent());
                                }

                                @Override
                                protected void handleFailure(ACLMessage failure) {
                                    System.err.println("error: matchmaker agent sent failure message!");
                                }
                            });
                            return;
                        }
                        System.err.println("error: invalid command!");
                    }
                    catch (IOException e) {
                        System.err.println("error: IO error!");
                    }
                }
            }
        });
    }
}

