/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.owlsmx.jade.behaviours;

import de.dfki.owlsmx.SimilarityMatchingEngine;
import de.dfki.owlsmx.data.MatchedService;
import de.dfki.owlsmx.jade.behaviours.MatchMatchingExpression;
import de.dfki.owlsmx.jade.ontology.MatchAction;
import de.dfki.owlsmx.jade.ontology.MatchedServiceConcept;
import de.dfki.owlsmx.jade.ontology.MatchesPredicate;
import de.dfki.owlsmx.jade.ontology.MatchingResultConcept;
import de.dfki.owlsmx.jade.ontology.ServiceConcept;
import jade.content.ContentElement;
import jade.content.onto.basic.Action;
import jade.core.Agent;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.proto.SimpleAchieveREResponder;
import jade.util.leap.LinkedList;
import jade.util.leap.List;
import java.net.URI;
import java.util.SortedSet;

public class MatchResponderBehaviour
extends SimpleAchieveREResponder {
    private SimilarityMatchingEngine matchmaker;
    private MatchAction matchAction;

    public MatchResponderBehaviour(Agent agent, SimilarityMatchingEngine matchmaker) {
        super(agent, MessageTemplate.and((MessageTemplate)new MessageTemplate((MessageTemplate.MatchExpression)new MatchMatchingExpression(agent)), (MessageTemplate)SimpleAchieveREResponder.createMessageTemplate((String)"fipa-request")));
        this.matchmaker = matchmaker;
    }

    protected ACLMessage prepareResponse(ACLMessage request) {
        ACLMessage response = request.createReply();
        try {
            ContentElement content = this.myAgent.getContentManager().extractContent(request);
            this.matchAction = (MatchAction)((Action)content).getAction();
            response.setPerformative(1);
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setPerformative(10);
        }
        return response;
    }

    protected ACLMessage prepareResultNotification(ACLMessage request, ACLMessage response) {
        ACLMessage result = request.createReply();
        try {
            SortedSet resultSet;
            ServiceConcept service = this.matchAction.getService();
            int variant = this.matchAction.getVariant();
            int minimumDegreeOfMatch = this.matchAction.getMinimumDOM();
            double minimumSimilarity = this.matchAction.getMinimumSIM();
            int sortingType = this.matchAction.getSortingType();
            this.matchmaker.setSimilarityMeasure((short)variant);
            if (service.getContent() != null) {
                resultSet = this.matchmaker.matchRequest(service.getContent(), minimumDegreeOfMatch, minimumSimilarity, sortingType);
            } else {
                URI uri = new URI(service.getURI());
                resultSet = this.matchmaker.matchRequest(uri, minimumDegreeOfMatch, minimumSimilarity, sortingType);
            }
            MatchesPredicate matches = new MatchesPredicate();
            matches.setRequest(service);
            MatchingResultConcept matchingResult = new MatchingResultConcept();
            LinkedList resultList = new LinkedList();
            for (MatchedService next : resultSet) {
                MatchedServiceConcept matchedService = new MatchedServiceConcept();
                service = new ServiceConcept();
                service.setURI(next.getServiceURI().toString());
                if (next.getServiceAsString() != null) {
                    service.setContent(next.getServiceAsString());
                }
                matchedService.setService(service);
                matchedService.setDOM(next.getDegreeOfMatch());
                matchedService.setSIM(next.getSyntacticSimilarity());
                resultList.add((Object)matchedService);
            }
            matchingResult.setMatchedServices((List)resultList);
            matches.setResult(matchingResult);
            this.myAgent.getContentManager().fillContent(result, (ContentElement)matches);
            result.setPerformative(7);
        }
        catch (Throwable t) {
            t.printStackTrace();
            result.setPerformative(6);
        }
        return result;
    }
}

