/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.owlsmx.jade.behaviours.request;

import de.dfki.owlsmx.jade.ontology.MatchAction;
import de.dfki.owlsmx.jade.ontology.ServiceConcept;
import jade.content.Concept;
import jade.content.ContentElement;
import jade.content.lang.Codec;
import jade.content.onto.OntologyException;
import jade.content.onto.basic.Action;
import jade.core.AID;
import jade.core.Agent;
import jade.lang.acl.ACLMessage;
import jade.proto.SimpleAchieveREInitiator;
import java.net.URI;

public class RequestMatchBehaviour
extends SimpleAchieveREInitiator {
    private AID matchmakerAgent;
    private URI serviceURI = null;
    private int variant;
    private String serviceContent = null;
    private int minimumDegreeOfMatch = 5;
    private double minimumSimilarity = 0.0;
    private int sortingType = 0;

    public RequestMatchBehaviour(Agent myAgent, AID matchmakerAgent, URI serviceURI, int variant) {
        super(myAgent, null);
        this.matchmakerAgent = matchmakerAgent;
        this.serviceURI = serviceURI;
        this.variant = variant;
    }

    public RequestMatchBehaviour(Agent myAgent, AID matchmakerAgent, URI serviceURI, int variant, int minimumDegreeOfMatch, double minimumSimilarity) {
        super(myAgent, null);
        this.matchmakerAgent = matchmakerAgent;
        this.serviceURI = serviceURI;
        this.variant = variant;
        this.minimumDegreeOfMatch = minimumDegreeOfMatch;
        this.minimumSimilarity = minimumSimilarity;
    }

    public RequestMatchBehaviour(Agent myAgent, AID matchmakerAgent, URI serviceURI, int variant, int minimumDegreeOfMatch, double minimumSimilarity, int sortingType) {
        super(myAgent, null);
        this.matchmakerAgent = matchmakerAgent;
        this.serviceURI = serviceURI;
        this.variant = variant;
        this.minimumDegreeOfMatch = minimumDegreeOfMatch;
        this.minimumSimilarity = minimumSimilarity;
        this.sortingType = sortingType;
    }

    public RequestMatchBehaviour(Agent myAgent, AID matchmakerAgent, String serviceContent, int variant) {
        super(myAgent, null);
        this.matchmakerAgent = matchmakerAgent;
        this.serviceContent = serviceContent;
        this.variant = variant;
    }

    public RequestMatchBehaviour(Agent myAgent, AID matchmakerAgent, String serviceContent, int variant, int minimumDegreeOfMatch, double minimumSimilarity) {
        super(myAgent, null);
        this.matchmakerAgent = matchmakerAgent;
        this.serviceContent = serviceContent;
        this.variant = variant;
        this.minimumDegreeOfMatch = minimumDegreeOfMatch;
        this.minimumSimilarity = minimumSimilarity;
    }

    public RequestMatchBehaviour(Agent myAgent, AID matchmakerAgent, String serviceContent, int variant, int minimumDegreeOfMatch, double minimumSimilarity, int sortingType) {
        super(myAgent, null);
        this.matchmakerAgent = matchmakerAgent;
        this.serviceContent = serviceContent;
        this.variant = variant;
        this.minimumDegreeOfMatch = minimumDegreeOfMatch;
        this.minimumSimilarity = minimumSimilarity;
        this.sortingType = sortingType;
    }

    protected void handleAgree(ACLMessage agree) {
    }

    protected void handleRefuse(ACLMessage refuse) {
    }

    protected void handleInform(ACLMessage inform) {
    }

    protected void handleFailure(ACLMessage failure) {
    }

    protected ACLMessage prepareRequest(ACLMessage message) {
        ACLMessage requestMessage = new ACLMessage(16);
        requestMessage.setProtocol("fipa-request");
        requestMessage.setLanguage("fipa-sl0");
        requestMessage.setOntology("Matchmaker_ontology");
        requestMessage.addReceiver(this.matchmakerAgent);
        ServiceConcept service = new ServiceConcept();
        if (this.serviceURI != null) {
            service.setURI(this.serviceURI.toString());
        } else {
            service.setURI("");
            service.setContent(this.serviceContent);
        }
        MatchAction match = new MatchAction();
        match.setVariant(this.variant);
        match.setMinimumDOM(this.minimumDegreeOfMatch);
        match.setMinimumSIM(this.minimumSimilarity);
        match.setService(service);
        Action action = new Action(this.matchmakerAgent, (Concept)match);
        try {
            this.myAgent.getContentManager().fillContent(requestMessage, (ContentElement)action);
        }
        catch (Codec.CodecException e) {
            e.printStackTrace();
        }
        catch (OntologyException e) {
            e.printStackTrace();
        }
        return requestMessage;
    }
}

