/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.owlsmx.mxp;

import de.dfki.owlsmx.mxp.OWLSMXPCompatibilityMatrix;
import de.dfki.owlsmx.mxp.OWLSMXPMapping;
import de.dfki.owlsmx.mxp.OWLSMXPServiceInformation;
import de.dfki.owlsmx.mxp.OWLSMXPTypeCompatibilityChecker;
import de.dfki.owlsmx.mxp.exceptions.OWLSParsingException;
import de.dfki.owlsmx.mxp.exceptions.TypeNotFoundException;
import de.dfki.owlsmx.mxp.exceptions.WsdlParsingException;
import de.dfki.wsdlanalyzer.parser.SimpleTypeLookupTable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owls.process.Input;
import org.mindswap.owls.process.InputList;
import org.mindswap.owls.process.Output;
import org.mindswap.owls.process.OutputList;

public class OWLSMXP {
    private SimpleTypeLookupTable simpleTypeLookupTable = new SimpleTypeLookupTable();
    private Map serviceInfos = new HashMap();
    private boolean locked = false;
    private OWLSMXPCompatibilityMatrix compatibilityMatrix = new OWLSMXPCompatibilityMatrix();

    public void addService(OWLOntology service) {
        OWLSMXPTypeCompatibilityChecker checker;
        if (this.locked) {
            return;
        }
        OWLSMXPServiceInformation serviceInfo = null;
        try {
            serviceInfo = new OWLSMXPServiceInformation(service, this.simpleTypeLookupTable);
        }
        catch (Exception e) {
            return;
        }
        String serviceName = service.getService().getName();
        this.serviceInfos.put(serviceName, serviceInfo);
        InputList inputList = service.getService().getProcess().getInputs();
        OutputList outputList = service.getService().getProcess().getOutputs();
        int offset = this.compatibilityMatrix.getNumberOfRows();
        int i = 0;
        while (i < inputList.size()) {
            String inputName = String.valueOf(serviceName) + "#" + ((Input)inputList.get(i)).getLocalName();
            this.compatibilityMatrix.addRow(inputName);
            ++i;
        }
        i = 0;
        while (i < inputList.size()) {
            String candidateParameterName = ((Input)inputList.get(i)).getLocalName();
            int j = 0;
            while (j < this.compatibilityMatrix.getNumberOfColumns()) {
                String requestServiceName = this.compatibilityMatrix.getColumnName(j).split("#")[0];
                String requestParameterName = this.compatibilityMatrix.getColumnName(j).split("#")[1];
                OWLSMXPServiceInformation requestServiceInfo = (OWLSMXPServiceInformation)this.serviceInfos.get(requestServiceName);
                checker = new OWLSMXPTypeCompatibilityChecker(this.simpleTypeLookupTable, requestServiceInfo, serviceInfo);
                try {
                    boolean result = checker.matchOWLSParameterTypes(candidateParameterName, requestParameterName, true);
                    this.compatibilityMatrix.setEntry(offset + i, j, result);
                }
                catch (Exception result) {
                    // empty catch block
                }
                ++j;
            }
            ++i;
        }
        offset = this.compatibilityMatrix.getNumberOfColumns();
        i = 0;
        while (i < outputList.size()) {
            String outputName = String.valueOf(serviceName) + "#" + ((Output)outputList.get(i)).getLocalName();
            this.compatibilityMatrix.addColumn(outputName);
            ++i;
        }
        i = 0;
        while (i < this.compatibilityMatrix.getNumberOfRows()) {
            String candidateServiceName = this.compatibilityMatrix.getRowName(i).split("#")[0];
            String candidateParameterName = this.compatibilityMatrix.getRowName(i).split("#")[1];
            OWLSMXPServiceInformation candidateServiceInfo = (OWLSMXPServiceInformation)this.serviceInfos.get(candidateServiceName);
            int j = 0;
            while (j < outputList.size()) {
                String requestParameterName = ((Output)outputList.get(j)).getLocalName();
                checker = new OWLSMXPTypeCompatibilityChecker(this.simpleTypeLookupTable, serviceInfo, candidateServiceInfo);
                try {
                    boolean result = checker.matchOWLSParameterTypes(candidateParameterName, requestParameterName, true);
                    this.compatibilityMatrix.setEntry(i, offset + j, result);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++j;
            }
            ++i;
        }
    }

    public boolean checkDatatypeCompatibility(String firstServiceName, String outputParameterName, String secondServiceName, String inputParameterName) {
        return this.compatibilityMatrix.getEntry(String.valueOf(secondServiceName) + "#" + inputParameterName, String.valueOf(firstServiceName) + "#" + outputParameterName);
    }

    public String toString() {
        return this.compatibilityMatrix.toString();
    }

    public byte[] exportCompatibilityMatrix() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(this.compatibilityMatrix);
        return baos.toByteArray();
    }

    public void importCompatibilityMatrix(byte[] serializedCompatibilityMatrix) throws IOException, Exception {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(serializedCompatibilityMatrix);
            ObjectInputStream ois = new ObjectInputStream(bais);
            this.locked = true;
            this.compatibilityMatrix = (OWLSMXPCompatibilityMatrix)ois.readObject();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
    }

    public static boolean matchTypes(OWLOntology request, OWLOntology candidate, Map parameterMapping) throws IOException, TypeNotFoundException {
        OWLSMXPServiceInformation candidateInfo;
        OWLSMXPServiceInformation requestInfo;
        SimpleTypeLookupTable simpleTypeLookupTable = new SimpleTypeLookupTable();
        try {
            requestInfo = new OWLSMXPServiceInformation(request, simpleTypeLookupTable);
            candidateInfo = new OWLSMXPServiceInformation(candidate, simpleTypeLookupTable);
        }
        catch (IOException e) {
            throw e;
        }
        catch (WsdlParsingException e) {
            return false;
        }
        catch (OWLSParsingException e) {
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        Iterator iterator = parameterMapping.entrySet().iterator();
        boolean success = true;
        OWLSMXPTypeCompatibilityChecker checker = new OWLSMXPTypeCompatibilityChecker(simpleTypeLookupTable, requestInfo, candidateInfo);
        while (iterator.hasNext()) {
            boolean isInput;
            Map.Entry entry = iterator.next();
            String requestParameter = (String)entry.getKey();
            String candidateParameter = (String)entry.getValue();
            boolean result = checker.matchOWLSParameterTypes(candidateParameter, requestParameter, isInput = requestInfo.isInput(requestParameter));
            if (result) continue;
            success = false;
            break;
        }
        return success;
    }

    public static boolean matchTypes(OWLOntology request, OWLOntology candidate) throws IOException, TypeNotFoundException {
        OWLSMXPServiceInformation candidateInfo;
        OWLSMXPServiceInformation requestInfo;
        SimpleTypeLookupTable simpleTypeLookupTable = new SimpleTypeLookupTable();
        try {
            requestInfo = new OWLSMXPServiceInformation(request, simpleTypeLookupTable);
            candidateInfo = new OWLSMXPServiceInformation(candidate, simpleTypeLookupTable);
        }
        catch (IOException e) {
            throw e;
        }
        catch (WsdlParsingException e) {
            return false;
        }
        catch (OWLSParsingException e) {
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        OWLSMXPTypeCompatibilityChecker checker = new OWLSMXPTypeCompatibilityChecker(simpleTypeLookupTable, requestInfo, candidateInfo);
        InputList candidateInputs = candidate.getService().getProcess().getInputs();
        InputList requestInputs = request.getService().getProcess().getInputs();
        OWLSMXPMapping mapping = new OWLSMXPMapping(candidateInputs.size(), requestInputs.size());
        int i = 0;
        while (i < candidateInputs.size()) {
            String candidateInputName = ((Input)candidateInputs.get(i)).getLocalName();
            int j = 0;
            while (j < requestInputs.size()) {
                String requestInputName = ((Input)requestInputs.get(j)).getLocalName();
                boolean result = checker.matchOWLSParameterTypes(candidateInputName, requestInputName, true);
                if (result) {
                    mapping.addPossibleMappingElement(i, j);
                }
                ++j;
            }
            ++i;
        }
        if (!mapping.existsMapping()) {
            return false;
        }
        OutputList candidateOutputs = candidate.getService().getProcess().getOutputs();
        OutputList requestOutputs = request.getService().getProcess().getOutputs();
        mapping = new OWLSMXPMapping(requestOutputs.size(), candidateOutputs.size());
        int i2 = 0;
        while (i2 < requestOutputs.size()) {
            String requestOutputName = ((Output)requestOutputs.get(i2)).getLocalName();
            int j = 0;
            while (j < candidateOutputs.size()) {
                String candidateOutputName = ((Output)candidateOutputs.get(j)).getLocalName();
                boolean result = checker.matchOWLSParameterTypes(candidateOutputName, requestOutputName, false);
                if (result) {
                    mapping.addPossibleMappingElement(i2, j);
                }
                ++j;
            }
            ++i2;
        }
        return mapping.existsMapping();
    }
}

