/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.owlsmx.mxp;

import java.io.Serializable;
import java.util.Vector;

public class OWLSMXPCompatibilityMatrix
implements Serializable {
    private static final long serialVersionUID = 489323039384L;
    private Vector rowNames = new Vector();
    private Vector colNames = new Vector();
    private Vector matrix = new Vector();

    public void addRow(String rowName) {
        this.rowNames.add(rowName);
        this.matrix.add(new Vector());
        int i = 0;
        while (i < this.colNames.size()) {
            ((Vector)this.matrix.lastElement()).add(null);
            ++i;
        }
    }

    public void addColumn(String colName) {
        this.colNames.add(colName);
        int i = 0;
        while (i < this.rowNames.size()) {
            ((Vector)this.matrix.elementAt(i)).add(null);
            ++i;
        }
    }

    public void setEntry(int row, int col, boolean value) {
        if (row >= this.rowNames.size()) {
            return;
        }
        if (col >= this.colNames.size()) {
            return;
        }
        ((Vector)this.matrix.elementAt(row)).set(col, new Boolean(value));
    }

    public Boolean getEntry(int row, int col) {
        if (row >= this.rowNames.size()) {
            return null;
        }
        if (col >= this.colNames.size()) {
            return null;
        }
        return (Boolean)((Vector)this.matrix.elementAt(row)).elementAt(col);
    }

    public Boolean getEntry(String rowName, String columnName) {
        int row = this.rowNames.indexOf(rowName);
        int col = this.colNames.indexOf(columnName);
        return this.getEntry(row, col);
    }

    public int getNumberOfRows() {
        return this.rowNames.size();
    }

    public int getNumberOfColumns() {
        return this.colNames.size();
    }

    public String getRowName(int row) {
        if (row >= this.rowNames.size()) {
            return null;
        }
        return (String)this.rowNames.elementAt(row);
    }

    public String getColumnName(int col) {
        if (col >= this.colNames.size()) {
            return null;
        }
        return (String)this.colNames.elementAt(col);
    }

    public String toString() {
        String result = "\ncompatibility matrix:\n--------------------\nrows: ";
        int i = 0;
        while (i < this.rowNames.size()) {
            result = String.valueOf(result) + this.rowNames.elementAt(i) + " ";
            ++i;
        }
        result = String.valueOf(result) + "\ncols: ";
        i = 0;
        while (i < this.colNames.size()) {
            result = String.valueOf(result) + this.colNames.elementAt(i) + " ";
            ++i;
        }
        result = String.valueOf(result) + "\n\n";
        i = 0;
        while (i < this.rowNames.size()) {
            int j = 0;
            while (j < this.colNames.size()) {
                Boolean value = this.getEntry(i, j);
                result = value == null ? String.valueOf(result) + "n/a " : (value != false ? String.valueOf(result) + "yes " : String.valueOf(result) + " no ");
                ++j;
            }
            result = String.valueOf(result) + "\n";
            ++i;
        }
        result = String.valueOf(result) + "\n";
        return result;
    }
}

