/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.owlsmx.mxp;

public class OWLSMXPMapping {
    private boolean[][] matrix;
    private int numberOfSources;
    private int numberOfTargets;

    OWLSMXPMapping(int numberOfSources, int numberOfTargets) {
        this.numberOfSources = numberOfSources;
        this.numberOfTargets = numberOfTargets;
        this.matrix = new boolean[numberOfTargets][numberOfSources];
        int i = 0;
        while (i < numberOfTargets) {
            int j = 0;
            while (j < numberOfSources) {
                this.matrix[i][j] = false;
                ++j;
            }
            ++i;
        }
    }

    void addPossibleMappingElement(int source, int target) {
        this.matrix[target][source] = true;
    }

    boolean existsMapping() {
        if (this.numberOfSources == 0) {
            return true;
        }
        if (this.numberOfTargets == 0) {
            return false;
        }
        int i = 0;
        while (i < this.numberOfTargets) {
            if (this.matrix[i][0]) {
                OWLSMXPMapping subMapping = new OWLSMXPMapping(this.numberOfSources - 1, this.numberOfTargets - 1);
                int l = 1;
                while (l < this.numberOfSources) {
                    int k = 0;
                    while (k < this.numberOfTargets) {
                        if (k != i) {
                            int source = l - 1;
                            int target = k < i ? k : k - 1;
                            if (this.matrix[k][l]) {
                                subMapping.addPossibleMappingElement(source, target);
                            }
                        }
                        ++k;
                    }
                    ++l;
                }
                if (subMapping.existsMapping()) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    void printMatrix() {
        int i = 0;
        while (i < this.numberOfSources) {
            int j = 0;
            while (j < this.numberOfTargets) {
                if (this.matrix[j][i]) {
                    System.out.print("1");
                } else {
                    System.out.print("0");
                }
                ++j;
            }
            System.out.println();
            ++i;
        }
        System.out.println();
    }
}

