/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.owlsmx.mxp;

import de.dfki.owlsmx.mxp.exceptions.OWLSParsingException;
import de.dfki.owlsmx.mxp.exceptions.TypeNotFoundException;
import de.dfki.owlsmx.mxp.exceptions.WsdlParsingException;
import de.dfki.wsdlanalyzer.parser.SimpleTypeLookupTable;
import de.dfki.wsdlanalyzer.parser.WsdlFileParser;
import de.dfki.wsdlanalyzer.types.ComplexType;
import de.dfki.wsdlanalyzer.types.Message;
import de.dfki.wsdlanalyzer.types.MessageParameter;
import de.dfki.wsdlanalyzer.types.WsdlFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.mindswap.owl.OWLOntology;
import org.mindswap.owls.grounding.Grounding;
import org.mindswap.owls.grounding.MessageMap;
import org.mindswap.owls.grounding.MessageMapList;
import org.mindswap.owls.grounding.WSDLAtomicGrounding;
import org.mindswap.owls.process.AtomicProcess;
import org.mindswap.owls.process.Process;
import org.mindswap.owls.service.Service;

public class OWLSMXPServiceInformation {
    public static short SIMPLE_TYPE = 0;
    public static short COMPLEX_TYPE = 1;
    private Map inputParameterTypes = new HashMap();
    private Map outputParameterTypes = new HashMap();
    private URL wsdlURL = null;
    private WsdlFile wsdlFile = null;
    private SimpleTypeLookupTable simpleTypeLookupTable;

    public OWLSMXPServiceInformation(OWLOntology service, SimpleTypeLookupTable simpleTypeLookupTable) throws IOException, WsdlParsingException, OWLSParsingException {
        this.simpleTypeLookupTable = simpleTypeLookupTable;
        this.fetchServiceInformation(service);
    }

    private void fetchServiceInformation(OWLOntology owlsService) throws IOException, WsdlParsingException, OWLSParsingException {
        MessageParameter messagePart2;
        String messagePartName;
        String owlsParameterName;
        WSDLAtomicGrounding wsdlGrounding;
        try {
            Service service = owlsService.getService();
            Process process = service.getProcess();
            Grounding grounding = service.getGrounding();
            wsdlGrounding = (WSDLAtomicGrounding)grounding.getAtomicGrounding((AtomicProcess)process);
        }
        catch (Exception e) {
            throw new OWLSParsingException();
        }
        this.wsdlURL = wsdlGrounding.getDescriptionURL();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.wsdlURL.openStream()));
        FileWriter fileWriter = new FileWriter("temp.wsdl");
        String line = null;
        while ((line = bufferedReader.readLine()) != null) {
            fileWriter.write(String.valueOf(line) + "\n");
        }
        bufferedReader.close();
        fileWriter.close();
        WsdlFileParser wsdlParser = new WsdlFileParser("temp.wsdl", this.simpleTypeLookupTable);
        wsdlParser.parseWsdl();
        this.wsdlFile = wsdlParser.getWsdlfile();
        File tempFile = new File("temp.wsdl");
        tempFile.delete();
        String inputMessageName = wsdlGrounding.getInputMessage().toString();
        inputMessageName = inputMessageName.contains("#") ? inputMessageName.split("#")[1] : inputMessageName.substring(inputMessageName.lastIndexOf(47) + 1);
        String outputMessageName = wsdlGrounding.getOutputMessage().toString();
        outputMessageName = outputMessageName.contains("#") ? outputMessageName.split("#")[1] : outputMessageName.substring(outputMessageName.lastIndexOf(47) + 1);
        Message inputMessage = this.wsdlFile.getMessageList().getMessage(inputMessageName);
        Message outputMessage = this.wsdlFile.getMessageList().getMessage(outputMessageName);
        MessageMapList inputMapping = wsdlGrounding.getInputMap();
        MessageMapList outputMapping = wsdlGrounding.getOutputMap();
        for (MessageMap messageMap : inputMapping) {
            owlsParameterName = messageMap.getOWLSParameter().getLocalName();
            messagePartName = messageMap.getGroundingParameter();
            messagePartName = messagePartName.contains("#") ? messagePartName.split("#")[1] : messagePartName.substring(messagePartName.lastIndexOf(47) + 1);
            messagePart2 = null;
            for (MessageParameter messagePart2 : inputMessage.getParameterList()) {
                if (messagePart2.getName().equals(messagePartName)) break;
                messagePart2 = null;
            }
            if (messagePart2 == null) {
                throw new WsdlParsingException();
            }
            this.inputParameterTypes.put(owlsParameterName, messagePart2.getType());
        }
        for (MessageMap messageMap : outputMapping) {
            owlsParameterName = messageMap.getOWLSParameter().getLocalName();
            messagePartName = messageMap.getGroundingParameter();
            messagePartName = messagePartName.contains("#") ? messagePartName.split("#")[1] : messagePartName.substring(messagePartName.lastIndexOf(47) + 1);
            messagePart2 = null;
            for (MessageParameter messagePart2 : outputMessage.getParameterList()) {
                if (messagePart2.getName().equals(messagePartName)) break;
                messagePart2 = null;
            }
            if (messagePart2 == null) {
                throw new WsdlParsingException();
            }
            this.outputParameterTypes.put(owlsParameterName, messagePart2.getType());
        }
    }

    public boolean hasSimpleType(String owlsParameter) throws TypeNotFoundException {
        return this.getType(owlsParameter) == SIMPLE_TYPE;
    }

    public boolean hasComplexType(String owlsParameter) throws TypeNotFoundException {
        return this.getType(owlsParameter) == COMPLEX_TYPE;
    }

    public short getType(String owlsParameter) throws TypeNotFoundException {
        String typeName = (String)this.inputParameterTypes.get(owlsParameter);
        if (typeName == null) {
            typeName = (String)this.outputParameterTypes.get(owlsParameter);
        }
        if (typeName == null) {
            throw new TypeNotFoundException();
        }
        if (this.simpleTypeLookupTable.lookupSimpleType(typeName)) {
            return SIMPLE_TYPE;
        }
        return COMPLEX_TYPE;
    }

    public ComplexType getComplexType(String owlsParameter) throws TypeNotFoundException {
        if (!this.hasComplexType(owlsParameter)) {
            return null;
        }
        String typeName = (String)this.inputParameterTypes.get(owlsParameter);
        if (typeName == null) {
            typeName = (String)this.outputParameterTypes.get(owlsParameter);
        }
        return this.wsdlFile.getTypeList().getType(typeName);
    }

    public String getSimpleType(String owlsParameter) throws TypeNotFoundException {
        if (!this.hasSimpleType(owlsParameter)) {
            return null;
        }
        String result = (String)this.inputParameterTypes.get(owlsParameter);
        if (result == null) {
            result = (String)this.outputParameterTypes.get(owlsParameter);
        }
        return result;
    }

    public String getTypeName(String owlsParameter) {
        String result = (String)this.inputParameterTypes.get(owlsParameter);
        if (result == null) {
            result = (String)this.outputParameterTypes.get(owlsParameter);
        }
        return result;
    }

    public boolean isInput(String owlsParameter) {
        return this.inputParameterTypes.containsKey(owlsParameter);
    }

    public boolean isOutput(String owlsParameter) {
        return this.outputParameterTypes.containsKey(owlsParameter);
    }

    public WsdlFile getWsdlFile() {
        return this.wsdlFile;
    }

    public String toString() {
        String result = "wsdl file: " + this.wsdlURL.toString() + "\n";
        result = String.valueOf(result) + "inputs:\n";
        for (Map.Entry entry : this.inputParameterTypes.entrySet()) {
            result = String.valueOf(result) + (String)entry.getKey() + " -> " + (String)entry.getValue() + " (";
            try {
                if (this.hasSimpleType((String)entry.getKey())) {
                    result = String.valueOf(result) + "simple type)\n";
                    continue;
                }
                result = String.valueOf(result) + "complex type)\n";
            }
            catch (Exception e) {
                result = String.valueOf(result) + "n/a)\n";
            }
        }
        result = String.valueOf(result) + "outputs:\n";
        for (Map.Entry entry : this.outputParameterTypes.entrySet()) {
            result = String.valueOf(result) + (String)entry.getKey() + " -> " + (String)entry.getValue() + " (";
            try {
                if (this.hasSimpleType((String)entry.getKey())) {
                    result = String.valueOf(result) + "simple type)\n";
                    continue;
                }
                result = String.valueOf(result) + "complex type)\n";
            }
            catch (Exception e) {
                result = String.valueOf(result) + "n/a)\n";
            }
        }
        return result;
    }
}

