/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.owlsmx.mxp;

import de.dfki.owlsmx.mxp.OWLSMXPMapping;
import de.dfki.owlsmx.mxp.OWLSMXPServiceInformation;
import de.dfki.owlsmx.mxp.exceptions.TypeNotFoundException;
import de.dfki.wsdlanalyzer.parser.SimpleTypeLookupTable;
import de.dfki.wsdlanalyzer.types.Attribute;
import de.dfki.wsdlanalyzer.types.ComplexType;
import de.dfki.wsdlanalyzer.types.Element;
import de.dfki.wsdlanalyzer.types.WsdlFile;
import java.util.ArrayList;
import java.util.Iterator;

public class OWLSMXPTypeCompatibilityChecker {
    private SimpleTypeLookupTable simpleTypeLookupTable;
    private OWLSMXPServiceInformation requestService;
    private OWLSMXPServiceInformation candidateService;
    private WsdlFile requestFile;
    private WsdlFile candidateFile;

    OWLSMXPTypeCompatibilityChecker(SimpleTypeLookupTable simpleTypeLookupTable, OWLSMXPServiceInformation requestService, OWLSMXPServiceInformation candidateService) {
        this.simpleTypeLookupTable = simpleTypeLookupTable;
        this.requestService = requestService;
        this.candidateService = candidateService;
        this.requestFile = requestService.getWsdlFile();
        this.candidateFile = candidateService.getWsdlFile();
    }

    public boolean matchSimpleTypes(String candidateType, String requestType) {
        int matchingScore = this.simpleTypeLookupTable.getMatchingScore(candidateType, requestType);
        return matchingScore == 1;
    }

    public boolean matchMixedTypes(ComplexType candidateType, String requestType) {
        return false;
    }

    public boolean matchMixedTypes(String candidateType, ComplexType requestType) {
        return false;
    }

    public boolean matchComplexTypes(ComplexType candidateType, ComplexType requestType, boolean isInput) {
        if (candidateType.getGrouping() != candidateType.getGrouping()) {
            return false;
        }
        Iterator<Attribute> candidateAttributeIter = candidateType.attributeIterator();
        Iterator<Attribute> requestAttributeIter = requestType.attributeIterator();
        ArrayList<Attribute> requestAttributes = new ArrayList<Attribute>();
        while (requestAttributeIter.hasNext()) {
            Attribute requestAttribute = requestAttributeIter.next();
            if (requestAttribute.getUse() == null || !requestAttribute.getUse().equals("required")) continue;
            requestAttributes.add(requestAttribute);
        }
        ArrayList<Attribute> candidateAttributes = new ArrayList<Attribute>();
        while (candidateAttributeIter.hasNext()) {
            Attribute candidateAttribute = candidateAttributeIter.next();
            if (candidateAttribute.getUse() != null && candidateAttribute.getUse().equals("prohibited")) continue;
            candidateAttributes.add(candidateAttribute);
        }
        OWLSMXPMapping mapping = new OWLSMXPMapping(requestAttributes.size(), candidateAttributes.size());
        int i = 0;
        while (i < requestAttributes.size()) {
            Attribute requestAttribute = (Attribute)requestAttributes.get(i);
            String requestAttributeType = requestAttribute.getType();
            int j = 0;
            while (j < candidateAttributes.size()) {
                Attribute candidateAttribute = (Attribute)candidateAttributes.get(j);
                String candidateAttributeType = candidateAttribute.getType();
                boolean result = this.matchSimpleTypes(candidateAttributeType, requestAttributeType);
                if (result) {
                    mapping.addPossibleMappingElement(i, j);
                }
                ++j;
            }
            ++i;
        }
        if (!mapping.existsMapping()) {
            return false;
        }
        ArrayList<Element> candidateElements = candidateType.getElementList();
        ArrayList<Element> requestElements = requestType.getElementList();
        mapping = new OWLSMXPMapping(requestElements.size(), candidateElements.size());
        int i2 = 0;
        while (i2 < requestElements.size()) {
            Element requestElement = requestElements.get(i2);
            String requestElementType = requestElement.getType();
            int j = 0;
            while (j < candidateElements.size()) {
                Element candidateElement = candidateElements.get(j);
                String candidateElementType = candidateElement.getType();
                boolean result = this.matchTypes(candidateElementType, requestElementType, isInput);
                if (result) {
                    mapping.addPossibleMappingElement(i2, j);
                }
                ++j;
            }
            ++i2;
        }
        return mapping.existsMapping();
    }

    public boolean matchTypes(String parameter1, String parameter2, boolean isInput) {
        boolean parameter1HasSimpleType = false;
        boolean parameter2HasSimpleType = false;
        if (this.simpleTypeLookupTable.lookupSimpleType(parameter1)) {
            parameter1HasSimpleType = true;
        }
        if (this.simpleTypeLookupTable.lookupSimpleType(parameter2)) {
            parameter2HasSimpleType = true;
        }
        if (parameter1HasSimpleType && parameter2HasSimpleType) {
            return this.matchSimpleTypes(parameter1, parameter2);
        }
        if (parameter1HasSimpleType && !parameter2HasSimpleType) {
            ComplexType parameter2Type = isInput ? this.candidateFile.getTypeList().getType(parameter2) : this.requestFile.getTypeList().getType(parameter2);
            return this.matchMixedTypes(parameter1, parameter2Type);
        }
        if (!parameter1HasSimpleType && parameter2HasSimpleType) {
            ComplexType parameter1Type = isInput ? this.requestFile.getTypeList().getType(parameter1) : this.candidateFile.getTypeList().getType(parameter1);
            return this.matchMixedTypes(parameter1Type, parameter2);
        }
        if (!parameter1HasSimpleType && !parameter2HasSimpleType) {
            ComplexType parameter2Type;
            ComplexType parameter1Type;
            if (isInput) {
                parameter1Type = this.requestFile.getTypeList().getType(parameter1);
                parameter2Type = this.candidateFile.getTypeList().getType(parameter2);
            } else {
                parameter1Type = this.candidateFile.getTypeList().getType(parameter1);
                parameter2Type = this.requestFile.getTypeList().getType(parameter2);
            }
            return this.matchComplexTypes(parameter1Type, parameter2Type, isInput);
        }
        return false;
    }

    public boolean matchOWLSParameterTypes(String candidateParameter, String requestParameter, boolean isInput) throws TypeNotFoundException {
        String parameter1Type;
        String parameter2Type;
        if (isInput) {
            parameter2Type = this.candidateService.getTypeName(candidateParameter);
            parameter1Type = this.requestService.getTypeName(requestParameter);
        } else {
            parameter1Type = this.candidateService.getTypeName(candidateParameter);
            parameter2Type = this.requestService.getTypeName(requestParameter);
        }
        if (parameter1Type == null || parameter2Type == null) {
            throw new TypeNotFoundException();
        }
        return this.matchTypes(parameter1Type, parameter2Type, isInput);
    }
}

