/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.owlsmx.reasoning;

import de.dfki.owlsmx.exceptions.MatchingException;
import java.net.URI;
import java.net.URISyntaxException;
import org.semanticweb.owl.io.owl_rdf.OWLRDFParser;
import org.semanticweb.owl.util.OWLConnection;

public class ReasoningUtils {
    OWLConnection conn;
    OWLRDFParser parser;
    private static ReasoningUtils instance = null;

    public static ReasoningUtils getInstance() throws MatchingException {
        if (instance == null) {
            instance = new ReasoningUtils();
        }
        return instance;
    }

    private ReasoningUtils() {
    }

    private boolean contains(String Instring, String containedString) {
        return Instring.indexOf(containedString) >= 0;
    }

    public URI getOntologyURI(String path) throws MatchingException {
        if (path.startsWith("#") || !this.contains(path, "#")) {
            throw new MatchingException(String.valueOf(path) + " doesn't contain the OntologyURL");
        }
        try {
            return new URI(path.substring(0, path.indexOf("#")));
        }
        catch (URISyntaxException e) {
            throw new MatchingException("URI error: Couldn't get ontologyURI of " + path);
        }
    }
}

