/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.owlsmx.similaritymeasures;

import de.dfki.owlsmx.Indexer.Index;
import de.dfki.owlsmx.data.LocalOntologyContainer;
import de.dfki.owlsmx.exceptions.MatchingException;
import de.dfki.owlsmx.io.ErrorLog;
import de.dfki.owlsmx.reasoning.PelletReasoner;
import de.dfki.owlsmx.similaritymeasures.SimilarityMeasure;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Iterator;
import org.mindswap.pellet.TuBox;

public class ConstraintSimilarity
extends SimilarityMeasure {
    private boolean debug = false;

    public ConstraintSimilarity() {
    }

    public ConstraintSimilarity(Index index) {
    }

    public ConstraintSimilarity(SimilarityMeasure measure) {
    }

    private HashSet advancedSplit(HashSet set, String text) {
        int openbrackets1 = 0;
        int openbrackets2 = 0;
        int i = 0;
        while (i < text.length()) {
            if (text.charAt(i) == '[') {
                ++openbrackets1;
            } else if (text.charAt(i) == '(') {
                ++openbrackets2;
            } else if (text.charAt(i) == ']') {
                --openbrackets1;
            } else if (text.charAt(i) == ')') {
                --openbrackets2;
            } else if (text.charAt(i) == ',' && openbrackets1 == 0 && openbrackets2 == 0) {
                set.add(text.substring(0, i));
                set.add(text.substring(i + 1));
                return set;
            }
            ++i;
        }
        return set;
    }

    private HashSet removeAnd(HashSet set, String text) {
        text = text.substring(4, text.lastIndexOf(")"));
        set.add(text);
        return set;
    }

    private HashSet removePrime(HashSet set, String text) {
        set.add(text.substring(7, text.indexOf(",")));
        set.add(text.substring(text.indexOf(",") + 1, text.lastIndexOf("]")));
        return set;
    }

    private HashSet removeList(HashSet set, String text) {
        text = text.substring(1, text.lastIndexOf("]"));
        if (this.debug) {
            System.out.println("    removed [] from: " + text);
        }
        return this.advancedSplit(set, text);
    }

    private HashSet getConstraints(String text) {
        HashSet<String> set = new HashSet<String>();
        set.add(text);
        Iterator iter = set.iterator();
        boolean changed = true;
        HashSet tmpset = new HashSet();
        while (changed) {
            changed = false;
            tmpset.clear();
            for (String tmpstring : set) {
                if (this.debug) {
                    System.out.println("getConstraints: " + tmpstring);
                }
                if (tmpstring.startsWith("[prime-")) {
                    if (this.debug) {
                        System.out.println("                starts with [prime-");
                    }
                    tmpset = this.removePrime(tmpset, tmpstring);
                    changed = true;
                    continue;
                }
                if (tmpstring.startsWith("and(")) {
                    if (this.debug) {
                        System.out.println("                starts with and(");
                    }
                    tmpset = this.removeAnd(tmpset, tmpstring);
                    changed = true;
                    continue;
                }
                if (tmpstring.startsWith("[")) {
                    if (this.debug) {
                        System.out.println("                starts with [");
                    }
                    tmpset = this.removeList(tmpset, tmpstring);
                    changed = true;
                    continue;
                }
                tmpset.add(tmpstring);
            }
            if (!changed) continue;
            set = new HashSet(tmpset);
        }
        return set;
    }

    private double computeSimilarity(HashSet set1, HashSet set2) {
        float overall = set1.size() + set2.size();
        HashSet set3 = new HashSet(set1);
        set1.removeAll(new HashSet(set2));
        set2.removeAll(new HashSet(set3));
        double set1_not_set2 = set1.size();
        double set2_not_set1 = set2.size();
        double loi = (set1_not_set2 + set2_not_set1) / (double)overall;
        return 1.0 - loi;
    }

    @Override
    public double computeSimilarity(PelletReasoner reason, LocalOntologyContainer localOntology, String clazz1, String clazz2) {
        double similarity = 0.0;
        try {
            String unfolded1 = reason.unfoldTerm(localOntology.getClass(clazz1));
            String unfolded2 = reason.unfoldTerm(localOntology.getClass(clazz2));
            similarity = this.computeSimilarity(this.getConstraints(unfolded1), this.getConstraints(unfolded2));
        }
        catch (TuBox.NotUnfoldableException e) {
            ErrorLog.instanceOf().report(String.valueOf(this.getClass().toString()) + "|computeSimilarity: " + e.getMessage() + "\n Could not unfold " + clazz1 + " " + clazz2);
            e.printStackTrace();
        }
        catch (MatchingException e) {
            ErrorLog.instanceOf().report(String.valueOf(this.getClass().toString()) + "|computeSimilarity: " + e.getMessage() + "\n Could not unfold " + clazz1 + " " + clazz2);
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            ErrorLog.instanceOf().report(String.valueOf(this.getClass().toString()) + "|computeSimilarity: " + e.getMessage() + "\n Could not unfold " + clazz1 + " " + clazz2);
            e.printStackTrace();
        }
        return similarity;
    }

    @Override
    public double computeSimilarity(String query, String token1, String service, String token2) throws MatchingException {
        return this.computeSimilarity(this.getConstraints(token1), this.getConstraints(token2));
    }

    @Override
    public void updateDocument(String document, String tokens) {
    }

    @Override
    public boolean usesIndex() {
        return false;
    }

    @Override
    public short getSimilarityType() {
        return 0;
    }
}

