/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.owlsmx.similaritymeasures;

import com.hp.hpl.jena.ontology.OntClass;
import de.dfki.owlsmx.Indexer.Index;
import de.dfki.owlsmx.Indexer.SimpleIndex;
import de.dfki.owlsmx.data.LocalOntologyContainer;
import de.dfki.owlsmx.exceptions.MatchingException;
import de.dfki.owlsmx.reasoning.PelletReasoner;
import de.dfki.owlsmx.similaritymeasures.SimilarityMeasureInterface;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.mindswap.pellet.TuBox;

public abstract class SimilarityMeasure
implements SimilarityMeasureInterface {
    protected Index index;
    protected HashMap similarities = new HashMap();
    public static final short SIMILARITY_NONE = -1;
    public static final short SIMILARITY_LOI = 0;
    public static final short SIMILARITY_EXTENDED_JACCARD = 1;
    public static final short SIMILARITY_COSINE = 2;
    public static final short SIMILARITY_JENSEN_SHANNON = 3;
    public static final short TERMWEIGHT_TERMFREQUENCY = 200;
    public static final short TERMWEIGHT_BINARY = 201;
    public static final short TERMWEIGHT_AUGMENTED = 202;
    public static final short TERMWEIGHT_LOGARITHMIC = 203;
    public static final short TERMWEIGHT_RELATIVE = 204;

    public abstract short getSimilarityType();

    SimilarityMeasure() {
        this.index = SimpleIndex.instanceOf();
    }

    SimilarityMeasure(Index index) {
        this.index = index;
    }

    SimilarityMeasure(SimilarityMeasure measure) {
        this.index = measure != null && measure.usesIndex() ? measure.getIndex() : SimpleIndex.instanceOf();
    }

    public void setIndex(Index index) {
        if (!this.usesIndex()) {
            return;
        }
        this.index = index;
    }

    public Index getIndex() {
        return this.index;
    }

    public boolean usesIndex() {
        return true;
    }

    @Override
    public abstract double computeSimilarity(PelletReasoner var1, LocalOntologyContainer var2, String var3, String var4);

    @Override
    public HashMap getStoredSimilarities(OntClass clazz) {
        String classname = clazz.getURI().toString();
        return (HashMap)this.similarities.get(classname);
    }

    public void remember(OntClass clazz) {
        String classname = clazz.getURI().toString();
        if (!this.similarities.containsKey(classname)) {
            this.similarities.put(classname, new HashMap());
        }
    }

    public void forget(OntClass clazz) {
        String classname = clazz.getURI().toString();
        if (this.similarities.containsKey(classname)) {
            this.similarities.remove(classname);
        }
    }

    @Override
    public String unfoldTerm(PelletReasoner reason, LocalOntologyContainer localOntology, String term) throws TuBox.NotUnfoldableException, MatchingException, URISyntaxException {
        String result = reason.unfoldTerm(localOntology.getClass(term));
        System.out.println(String.valueOf(this.getClass().toString()) + "|unfoldTerm: " + result);
        return result;
    }

    public void addDocument(String document, Map termFrequencies) {
        SimpleIndex.instanceOf().addDocument(document, termFrequencies);
    }
}

