/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.owlsmx.tokenizer;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class Tokenizer {
    String string = "";
    Map tokens = new HashMap();
    Iterator tokenIterator;

    public Tokenizer() {
    }

    public Tokenizer(String string) {
        this.string = string;
        this.tokenize();
    }

    public boolean hasNext() {
        return this.tokenIterator != null && this.tokenIterator.hasNext();
    }

    public String next() throws Exception {
        if (this.tokenIterator == null) {
            this.tokenIterator = this.iterator();
        }
        if (this.hasNext()) {
            return (String)this.tokenIterator.next();
        }
        throw new Exception("Tokenizer out of bound");
    }

    public void clear() {
        this.tokenIterator = null;
        this.tokens = new HashMap();
        this.string = "";
    }

    public void setString(String string) {
        this.clear();
        this.string = string;
        this.tokenize();
    }

    public int getFrequency(String token) {
        if (!this.tokens.containsKey(token)) {
            return 0;
        }
        return (Integer)this.tokens.get(token);
    }

    public Iterator iterator() {
        return this.tokens.keySet().iterator();
    }

    public Set getTokens() {
        return this.tokens.keySet();
    }

    public Map getTokenFrequencies() {
        return this.tokens;
    }

    protected void tokenize() {
        if (this.string == null || this.string == "") {
            return;
        }
        String token = "";
        char[] characters = this.string.toCharArray();
        int i = 0;
        while (i < characters.length) {
            char tmpChar = characters[i];
            if (this.isTokenChar(tmpChar)) {
                token = String.valueOf(token) + tmpChar;
                if (i == characters.length - 1) {
                    this.filterToken(token);
                }
            } else if (token != "") {
                this.filterToken(token);
                token = "";
            }
            ++i;
        }
    }

    protected void updateToken(String token) {
        int frequency = 0;
        if (this.tokens.containsKey(token)) {
            frequency = (Integer)this.tokens.get(token);
        }
        this.tokens.put(token, new Integer(frequency + 1));
    }

    protected boolean isTokenChar(char c) {
        return !Character.isWhitespace(c);
    }

    protected void filterToken(String token) {
        if (!token.equals("")) {
            this.updateToken(token);
        }
    }

    public Map getTokenFrequencies(String string) {
        this.setString(string);
        return this.getTokenFrequencies();
    }
}

