/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.owlsmx.utils;

import de.dfki.owlsmx.exceptions.MatchingException;
import de.dfki.owlsmx.utils.StringUtils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.semanticweb.owl.model.OWLClass;
import org.semanticweb.owl.model.OWLOntology;

public class OntologyUtils {
    public static URI getOntologyURI(URI ClassURI) throws MatchingException {
        String path = ClassURI.toString();
        if (path.startsWith("#") || !StringUtils.contains(path, "#")) {
            throw new MatchingException(String.valueOf(ClassURI.toString()) + " doesn't contain the OntologyURL");
        }
        try {
            return new URI(path.substring(0, path.indexOf("#")));
        }
        catch (URISyntaxException e) {
            throw new MatchingException("URI error: Couldn't get ontologyURI of " + ClassURI.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean classInSet(OWLClass clazz, Set classes) throws MatchingException {
        try {
            OWLClass current_clazz;
            String token = clazz.getURI().toString();
            if (!StringUtils.contains(token, "#")) {
                return false;
            }
            token = token.substring(token.lastIndexOf("#"));
            Iterator iter = classes.iterator();
            do {
                if (iter.hasNext()) continue;
                return false;
            } while ((current_clazz = (OWLClass)iter.next()).getURI().toString().indexOf(token) < 0);
            return true;
        }
        catch (Exception e) {
            throw new MatchingException(e.getMessage());
        }
    }

    public static Set classesNotInOntology(Set classes, OWLOntology ontology) throws MatchingException {
        HashSet<OWLClass> result = new HashSet<OWLClass>();
        try {
            Set ontology_classes = ontology.getClasses();
            for (OWLClass clazz : classes) {
                if (!OntologyUtils.classInSet(clazz, ontology_classes)) continue;
                result.add(clazz);
            }
        }
        catch (Exception e) {
            throw new MatchingException(e.getMessage());
        }
        return result;
    }

    public static String getLocalConcept(String localURI, String absoluteURI) throws MatchingException {
        if (OntologyUtils.containsGlobalOntologyURI(absoluteURI)) {
            String uri = absoluteURI;
            return String.valueOf(localURI) + uri.substring(uri.lastIndexOf("#"));
        }
        throw new MatchingException("Couldn't retrieve local URI of " + absoluteURI);
    }

    public static Vector getLocalConcepts(String localURI, Vector absoluteURIs) throws MatchingException {
        Vector<String> result = new Vector<String>();
        int i = 0;
        while (i < absoluteURIs.size()) {
            result.add(OntologyUtils.getLocalConcept(localURI, (String)absoluteURIs.get(i)));
            ++i;
        }
        return result;
    }

    public static boolean containsGlobalOntologyURI(String line) {
        String testline = line.toLowerCase();
        return (testline.indexOf("http://") >= 0 || testline.indexOf("file:/") >= 0) && testline.indexOf("#") >= 0 && testline.indexOf("xmlns:") < 0 && testline.indexOf("xmlschema#") < 0 && testline.indexOf("http://www.w3.org/2001/xmlschema") < 0 && testline.indexOf("entity") < 0;
    }

    public static String removeURI(String line) {
        if (!OntologyUtils.containsGlobalOntologyURI(line)) {
            return line;
        }
        int pos = 0;
        if (line.toLowerCase().indexOf("http://") >= 0) {
            pos = line.toLowerCase().indexOf("http://");
        } else if (line.toLowerCase().indexOf("file:/") >= 0) {
            pos = line.toLowerCase().indexOf("file:/");
        } else {
            return line;
        }
        String result = String.valueOf(line.substring(0, pos)) + line.substring(line.indexOf("#"));
        return result;
    }

    public static void makeOntologyLocal(String localURI, String filename) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(filename));
        Vector<String> vec = new Vector<String>();
        String line = "";
        String localized = "";
        while ((line = reader.readLine()) != null) {
            line = line.trim();
            localized = OntologyUtils.removeURI(line);
            vec.add(String.valueOf(localized) + "\n");
        }
        reader.close();
        FileWriter writer = new FileWriter(filename, false);
        int i = 0;
        while (i < vec.size()) {
            writer.write((String)vec.get(i));
            ++i;
        }
        writer.flush();
        writer.close();
    }
}

