/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.owlsmx.utils;

import de.dfki.owlsmx.Indexer.SimpleIndex;
import de.dfki.owlsmx.stemmer.PorterStemmer;
import de.dfki.owlsmx.tokenizer.PrimitiveConceptTokenizer;
import de.dfki.owlsmx.utils.CollectionUtils;
import java.util.Map;

public class StringUtils {
    static PorterStemmer stemmer = PorterStemmer.instanceOf();

    public static boolean contains(String Instring, String containedString) {
        return Instring.indexOf(containedString) >= 0;
    }

    public static String getStemmedConceptName(String uri) {
        String result = "";
        result = StringUtils.contains(uri, "#") ? uri.substring(uri.indexOf("#") + 1) : uri;
        if (StringUtils.contains(result, "#") || StringUtils.contains(result, "http") || StringUtils.contains(result, "file")) {
            System.out.println("stemmedConcept is a Uri " + result);
        }
        if ((result = stemmer.stem(result)) == null) {
            System.out.println("stemmedConcept is null " + result);
        }
        return result;
    }

    public static Map getPrimitiveConcepts(String unfoldedConcept) {
        PrimitiveConceptTokenizer token = new PrimitiveConceptTokenizer(unfoldedConcept);
        return token.getTokenFrequencies();
    }

    public static void main(String[] args) {
        String test = "and([prime-http://www.develin.de/owl#DieselFZ,and([all(http://www.develin.de/owl#faehrtMit,and([prime-http://www.develin.de/owl#Diesel,http://www.develin.de/owl#Krafstoff])),and([prime-http://www.develin.de/owl#KFZ,and([and([and([and([all(http://www.develin.de/owl#faehrtAuf,and([prime-http://www.develin.de/owl#Rad,_TOP_])),all(http://www.develin.de/owl#angetriebenDurch,and([prime-http://www.develin.de/owl#Motor,_TOP_]))]),all(http://www.develin.de/owl#moeglicherUntergrund,and([prime-http://www.develin.de/owl#Strasse,_TOP_]))]),all(http://www.develin.de/owl#faehrtMit,and([prime-http://www.develin.de/owl#Kraftstoff,_TOP_]))]),and([prime-http://www.develin.de/owl#FZ,_TOP_])])])])])";
        Map pc = StringUtils.getPrimitiveConcepts(test);
        CollectionUtils.print(pc);
        SimpleIndex index = SimpleIndex.instanceOf();
        index.addDocument("DieselFZ", pc);
        if (index.getIDF("_TOP_") == 0.2) {
            System.out.println("IDF of _TOP_: 0.2 ");
        } else {
            System.out.println("Miscalculated IDF of _TOP_ it should be 0.2 but is " + index.getIDF("_TOP_"));
        }
    }
}

