/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.wsdlanalyzer.mapping;

import de.dfki.wsdlanalyzer.mapping.MappingPartList;
import de.dfki.wsdlanalyzer.types.NodeIdentifier;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

public class Mapping
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String requirementsName;
    private String candidateName;
    private NodeIdentifier requirementsIdentifier;
    private NodeIdentifier candidateIdentifier;
    private ArrayList<MappingPartList> mappingPartLists;
    private int score;
    private int size;
    private boolean anymatch;
    private int requirementminoccur;
    private int requirementmaxoccur;
    private int candidateminoccur;
    private int candidatemaxoccur;

    public Mapping() {
        this.mappingPartLists = new ArrayList();
        this.score = 0;
        this.size = 0;
        this.anymatch = false;
        this.requirementminoccur = 1;
        this.requirementmaxoccur = 1;
        this.candidateminoccur = 1;
        this.candidatemaxoccur = 1;
    }

    public Mapping(String requirements, String candidate) {
        this.requirementsName = requirements;
        this.candidateName = candidate;
        this.requirementsIdentifier = null;
        this.candidateIdentifier = null;
        this.mappingPartLists = new ArrayList();
        this.score = 0;
        this.size = 0;
        this.anymatch = false;
        this.requirementminoccur = 1;
        this.requirementmaxoccur = 1;
        this.candidateminoccur = 1;
        this.candidatemaxoccur = 1;
    }

    public Mapping(String requirements, String candidate, NodeIdentifier requirementsId, NodeIdentifier candidateId) {
        this.requirementsName = requirements;
        this.candidateName = candidate;
        this.requirementsIdentifier = requirementsId;
        this.candidateIdentifier = candidateId;
        this.mappingPartLists = new ArrayList();
        this.score = 0;
        this.size = 0;
        this.anymatch = false;
        this.requirementminoccur = 1;
        this.requirementmaxoccur = 1;
        this.candidateminoccur = 1;
        this.candidatemaxoccur = 1;
    }

    public int getScore() {
        return this.score;
    }

    public void setScore(int value) {
        this.score = value;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isAnymatch() {
        return this.anymatch;
    }

    public void setAnymatch(boolean anymatch) {
        this.anymatch = anymatch;
    }

    public int getCandidatemaxoccur() {
        return this.candidatemaxoccur;
    }

    public void setCandidatemaxoccur(int candidatemaxoccur) {
        this.candidatemaxoccur = candidatemaxoccur;
    }

    public int getCandidateminoccur() {
        return this.candidateminoccur;
    }

    public void setCandidateminoccur(int candidateminoccur) {
        this.candidateminoccur = candidateminoccur;
    }

    public int getRequirementmaxoccur() {
        return this.requirementmaxoccur;
    }

    public void setRequirementmaxoccur(int requirementmaxoccur) {
        this.requirementmaxoccur = requirementmaxoccur;
    }

    public int getRequirementminoccur() {
        return this.requirementminoccur;
    }

    public void setRequirementminoccur(int requirementminoccur) {
        this.requirementminoccur = requirementminoccur;
    }

    public String getRequirementsName() {
        return this.requirementsName;
    }

    public void setRequirementsName(String requirementsName) {
        this.requirementsName = requirementsName;
    }

    public String getCandidateName() {
        return this.candidateName;
    }

    public void setCandidateName(String candidateName) {
        this.candidateName = candidateName;
    }

    public NodeIdentifier getRequirementsIdentifier() {
        return this.requirementsIdentifier;
    }

    public void setRequirementsIdentifier(NodeIdentifier requirementsIdentifier) {
        this.requirementsIdentifier = requirementsIdentifier;
    }

    public NodeIdentifier getCandidateIdentifier() {
        return this.candidateIdentifier;
    }

    public void setCandidateIdentifier(NodeIdentifier candidateIdentifier) {
        this.candidateIdentifier = candidateIdentifier;
    }

    public ArrayList<MappingPartList> getMappingPartLists() {
        return this.mappingPartLists;
    }

    public void setMappingPartLists(ArrayList<MappingPartList> mappingPartLists) {
        this.score = mappingPartLists.get(0).getScore();
        this.mappingPartLists = mappingPartLists;
    }

    public boolean addMappingPartList(MappingPartList list) {
        if (this.score < list.getScore()) {
            this.mappingPartLists.clear();
            this.score = list.getScore();
            return this.mappingPartLists.add(list);
        }
        if (this.score == list.getScore()) {
            return this.mappingPartLists.add(list);
        }
        return false;
    }

    public MappingPartList get(int arg0) {
        return this.mappingPartLists.get(arg0);
    }

    public Iterator<MappingPartList> mappingPartListIterator() {
        return this.mappingPartLists.iterator();
    }

    public boolean isEmpty() {
        return this.mappingPartLists.isEmpty();
    }

    public void addScoreBonus(int bonus) {
        this.score += bonus;
    }

    public Mapping getMappingForCandidate(String name) {
        if (this.candidateName.equals(name)) {
            return this;
        }
        int i = 0;
        while (i < this.mappingPartLists.size()) {
            MappingPartList mappingPartList = this.get(i);
            Mapping mapping = mappingPartList.getMappingForCandidate(name);
            if (mapping != null) {
                return mapping;
            }
            ++i;
        }
        return null;
    }

    public Mapping getMappingForRequirement(String name) {
        if (this.requirementsName.equals(name)) {
            return this;
        }
        int i = 0;
        while (i < this.mappingPartLists.size()) {
            MappingPartList mappingPartList = this.get(i);
            Mapping mapping = mappingPartList.getMappingForRequirement(name);
            if (mapping != null) {
                return mapping;
            }
            ++i;
        }
        return null;
    }

    public Mapping getElementMapping() {
        if (this.mappingPartLists.isEmpty()) {
            return this;
        }
        MappingPartList mappingPartList = this.mappingPartLists.get(0);
        return mappingPartList.get(0).getElementMapping();
    }

    public void printMapping(int i) {
        switch (i) {
            case 0: {
                System.out.println("******* Files: *******\n");
                break;
            }
            case 1: {
                System.out.println("******* Services: *******\n");
                break;
            }
            case 2: {
                System.out.println("******* Ports: *******\n");
                break;
            }
            case 3: {
                System.out.println("******* Bindings: *******\n");
                break;
            }
            case 4: {
                System.out.println("******* PortTypes: *******\n");
                break;
            }
            case 5: {
                System.out.println("******* Operations: *******\n");
                break;
            }
            case 6: {
                System.out.println("******* Input/Output/Fault: *******\n");
                break;
            }
            case 7: {
                System.out.println("******* Messages: *******\n");
                break;
            }
            case 8: {
                System.out.println("******* Parameters: *******\n");
                break;
            }
            default: {
                System.out.println("******* Types: *******\n");
            }
        }
        System.out.println(String.valueOf(this.requirementsName) + " mapped to " + this.candidateName);
        if (this.requirementsIdentifier != null && this.candidateIdentifier != null) {
            System.out.println("NodeIdentifier: ");
            System.out.println(String.valueOf(this.requirementsIdentifier.toString()) + ", " + this.candidateIdentifier.toString());
        }
        System.out.println("Score: " + this.score + "\n");
        System.out.println("Number of alternatives: " + this.mappingPartLists.size() + "\n");
        if (!this.mappingPartLists.isEmpty()) {
            MappingPartList mappingList = this.mappingPartLists.get(0);
            mappingList.print(i + 1);
        } else if (this.isAnymatch()) {
            switch (i) {
                case 0: {
                    System.out.println("services anyMatch!!!\n");
                    break;
                }
                case 1: {
                    System.out.println("ports anyMatch!!!\n");
                    break;
                }
                case 2: {
                    System.out.println("bindings anyMatch!!!\n");
                    break;
                }
                case 3: {
                    System.out.println("portTypes anyMatch!!!\n");
                    break;
                }
                case 4: {
                    System.out.println("operations anyMatch!!!\n");
                    break;
                }
                case 5: {
                    System.out.println("messages anyMatch!!!\n");
                    break;
                }
                case 6: {
                    System.out.println("parameters anyMatch!!!\n");
                    break;
                }
                case 7: {
                    System.out.println("types anyMatch!!!\n");
                    break;
                }
                default: {
                    System.out.println("types anyMatch!!!\n");
                }
            }
        }
    }

    public void print() {
        System.out.println("\n###Mapping###\n");
        System.out.println("req: " + this.requirementsName + ", id: " + this.requirementsIdentifier.toString());
        System.out.println("can: " + this.candidateName + ", id: " + this.candidateIdentifier.toString());
    }

    public String log(int i) {
        String mappingLog = "";
        switch (i) {
            case 0: {
                mappingLog = String.valueOf(mappingLog) + "******* Files: *******\n";
                break;
            }
            case 1: {
                mappingLog = String.valueOf(mappingLog) + "******* Services: *******\n";
                break;
            }
            case 2: {
                mappingLog = String.valueOf(mappingLog) + "******* Ports: *******\n";
                break;
            }
            case 3: {
                mappingLog = String.valueOf(mappingLog) + "******* Bindings: *******\n";
                break;
            }
            case 4: {
                mappingLog = String.valueOf(mappingLog) + "******* PortTypes: *******\n";
                break;
            }
            case 5: {
                mappingLog = String.valueOf(mappingLog) + "******* Operations: *******\n";
                break;
            }
            case 6: {
                mappingLog = String.valueOf(mappingLog) + "******* Input/Output/Fault: *******\n";
                break;
            }
            case 7: {
                mappingLog = String.valueOf(mappingLog) + "******* Messages: *******\n";
                break;
            }
            case 8: {
                mappingLog = String.valueOf(mappingLog) + "******* Parameters: *******\n";
                break;
            }
            default: {
                mappingLog = String.valueOf(mappingLog) + "******* Types: *******\n";
            }
        }
        mappingLog = String.valueOf(mappingLog) + this.requirementsName + " mapped to " + this.candidateName;
        if (this.requirementsIdentifier != null && this.candidateIdentifier != null) {
            mappingLog = String.valueOf(mappingLog) + "\nNodeIdentifier: \n";
            mappingLog = String.valueOf(mappingLog) + this.requirementsIdentifier.toString() + ", " + this.candidateIdentifier.toString() + "\n";
        }
        mappingLog = String.valueOf(mappingLog) + "Score: " + this.score + "\n";
        mappingLog = String.valueOf(mappingLog) + "Number of alternatives: " + this.mappingPartLists.size() + "\n";
        if (!this.mappingPartLists.isEmpty()) {
            MappingPartList mappingList = this.mappingPartLists.get(0);
            mappingLog = String.valueOf(mappingLog) + mappingList.log(i + 1);
        } else if (this.isAnymatch()) {
            switch (i) {
                case 0: {
                    mappingLog = String.valueOf(mappingLog) + "services anyMatch!!!\n";
                    break;
                }
                case 1: {
                    mappingLog = String.valueOf(mappingLog) + "ports anyMatch!!!\n";
                    break;
                }
                case 2: {
                    mappingLog = String.valueOf(mappingLog) + "bindings anyMatch!!!\n";
                    break;
                }
                case 3: {
                    mappingLog = String.valueOf(mappingLog) + "portTypes anyMatch!!!\n";
                    break;
                }
                case 4: {
                    mappingLog = String.valueOf(mappingLog) + "operations anyMatch!!!\n";
                    break;
                }
                case 5: {
                    mappingLog = String.valueOf(mappingLog) + "messages anyMatch!!!\n";
                    break;
                }
                case 6: {
                    mappingLog = String.valueOf(mappingLog) + "parameters anyMatch!!!\n";
                    break;
                }
                case 7: {
                    mappingLog = String.valueOf(mappingLog) + "types anyMatch!!!\n";
                    break;
                }
                default: {
                    mappingLog = String.valueOf(mappingLog) + "types anyMatch!!!\n";
                }
            }
        }
        return mappingLog;
    }
}

